@extends('backend.layouts.app')
<script src="{{ static_asset('martex/js/ckeditor/ckeditor.js') }}"></script>
@section('content')
<style>
        body {
            font-size: 12px;
        }
        #map{
            width: 100%;
            height: 250px;
        }
        #edit_map{
            width: 100%;
            height: 250px;
        }
        .pac-container{
            z-index: 100000;
        }

    </style>
    <div class="row">
        <div class="col-lg-12 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0 h6">Informações do serviço</h5>
                </div>
                <div class="card-body">
                    <form id="add_form" class="form-horizontal" action="{{ route('servico.update', $servico->id) }}"
                        method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PATCH')
                        <div class="form-body">
                        <br>
                        <hr>
                        <h4 class="card-title">Seção GPS</h4>
                        <hr>
                        <br>
                        <div class="form-group row">
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label class="mr-sm-2" for="">Título</label>
                                    <input type="text" class="form-control" name="map_title"
                                        value="{{ $servico->map_title }}">
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label class="mr-sm-2" for="">Celular</label>
                                    <input type="text" class="form-control" name="map_cellphone" id="map_cellphone"
                                        value="{{ $servico->map_cellphone }}">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="mr-sm-2" for="">Endereço</label>
                                    <input type="text" class="form-control" name="address"
                                        value="{{ $servico->address }}">
                                </div>
                            </div>
                        </div>
                        <br>
                        <hr>
                        <h4 class="card-title">Seção 1</h4>
                        <hr>
                        <br>
                        <div class="form-group row">
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_1_conteudo_0"
                                value="{{ $servico->section_1_conteudo_0 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_1_conteudo_1"
                                value="{{ $servico->section_1_conteudo_1 }}">
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Link Botão</label>
                              <input type="text" class="form-control" name="section_1_link_2"
                                value="{{ $servico->section_1_link_2 }}">
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Texto Âncora</label>
                              <input type="text" class="form-control" name="section_1_link_alt_2"
                                value="{{ $servico->section_1_link_alt_2 }}">
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Nome Botão</label>
                              <input type="text" class="form-control" name="section_1_link_conteudo_2"
                                value="{{$servico->section_1_link_conteudo_2}}">
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for=""> {{ translate("Image") }}<small>(859x974px)</small></label>
                              <div class="input-group" data-toggle="aizuploader" data-type="image">
                                <div class="input-group-prepend">
                                  <div class="input-group-text bg-soft-secondary font-weight-medium">
                                    {{ translate("Browse") }}
                                  </div>
                                </div>
                                <div class="form-control file-amount"> {{ translate("Choose File") }} </div>
                                <input type="hidden" name="section_1_img_3" class="selected-files"
                                  value="{{ $servico->section_1_img_3 }}">
                              </div>
                              <div class="file-preview box"></div>
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Legenda</label>
                              <input type="text" class="form-control" name="section_1_image_alt_3"
                                value="{{ $servico->section_1_image_alt_3 }}">
                            </div>
                          </div>
                        </div>
                        <br>
                        <hr>
                        <h4 class="card-title">Seção 2</h4>
                        <hr>
                        <br>
                        <div class="form-group row">
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_2_conteudo_4"
                                value="{{ $servico->section_2_conteudo_4 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_2_conteudo_5"
                                value="{{ $servico->section_2_conteudo_5 }}">
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for=""> {{ translate("Image") }}<small>(250x250px)</small></label>
                              <div class="input-group" data-toggle="aizuploader" data-type="image">
                                <div class="input-group-prepend">
                                  <div class="input-group-text bg-soft-secondary font-weight-medium">
                                    {{ translate("Browse") }}
                                  </div>
                                </div>
                                <div class="form-control file-amount"> {{ translate("Choose File") }} </div>
                                <input type="hidden" name="section_2_img_6" class="selected-files"
                                  value="{{ $servico->section_2_img_6 }}">
                              </div>
                              <div class="file-preview box"></div>
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Legenda</label>
                              <input type="text" class="form-control" name="section_2_image_alt_6"
                                value="{{ $servico->section_2_image_alt_6 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_2_conteudo_7"
                                value="{{ $servico->section_2_conteudo_7 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_2_conteudo_8"
                                value="{{ $servico->section_2_conteudo_8 }}">
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for=""> {{ translate("Image") }}<small>(250x250px)</small></label>
                              <div class="input-group" data-toggle="aizuploader" data-type="image">
                                <div class="input-group-prepend">
                                  <div class="input-group-text bg-soft-secondary font-weight-medium">
                                    {{ translate("Browse") }}
                                  </div>
                                </div>
                                <div class="form-control file-amount"> {{ translate("Choose File") }} </div>
                                <input type="hidden" name="section_2_img_9" class="selected-files"
                                  value="{{ $servico->section_2_img_9 }}">
                              </div>
                              <div class="file-preview box"></div>
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Legenda</label>
                              <input type="text" class="form-control" name="section_2_image_alt_9"
                                value="{{ $servico->section_2_image_alt_9 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_2_conteudo_10"
                                value="{{ $servico->section_2_conteudo_10 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_2_conteudo_11"
                                value="{{ $servico->section_2_conteudo_11 }}">
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for=""> {{ translate("Image") }}<small>(250x250px)</small></label>
                              <div class="input-group" data-toggle="aizuploader" data-type="image">
                                <div class="input-group-prepend">
                                  <div class="input-group-text bg-soft-secondary font-weight-medium">
                                    {{ translate("Browse") }}
                                  </div>
                                </div>
                                <div class="form-control file-amount"> {{ translate("Choose File") }} </div>
                                <input type="hidden" name="section_2_img_12" class="selected-files"
                                  value="{{ $servico->section_2_img_12 }}">
                              </div>
                              <div class="file-preview box"></div>
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Legenda</label>
                              <input type="text" class="form-control" name="section_2_image_alt_12"
                                value="{{ $servico->section_2_image_alt_12 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_2_conteudo_13"
                                value="{{ $servico->section_2_conteudo_13 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_2_conteudo_14"
                                value="{{ $servico->section_2_conteudo_14 }}">
                            </div>
                          </div>
                        </div>
                        <br>
    
                        <hr>
                        <h4 class="card-title">Seção 3</h4>
    
                        <hr>
                        <br>
                        <div class="form-group row">
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for=""> {{ translate("Image") }}<small>(1000x770px)</small></label>
                              <div class="input-group" data-toggle="aizuploader" data-type="image">
                                <div class="input-group-prepend">
                                  <div class="input-group-text bg-soft-secondary font-weight-medium">
                                    {{ translate("Browse") }}
                                  </div>
                                </div>
                                <div class="form-control file-amount"> {{ translate("Choose File") }} </div>
                                <input type="hidden" name="section_3_img_15" class="selected-files"
                                  value="{{ $servico->section_3_img_15 }}">
                              </div>
                              <div class="file-preview box"></div>
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Legenda</label>
                              <input type="text" class="form-control" name="section_3_image_alt_15"
                                value="{{ $servico->section_3_image_alt_15 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_3_conteudo_16"
                                value="{{ $servico->section_3_conteudo_16 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_3_conteudo_17"
                                value="{{ $servico->section_3_conteudo_17 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_3_conteudo_18"
                                value="{{ $servico->section_3_conteudo_18 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_3_conteudo_19"
                                value="{{ $servico->section_3_conteudo_19 }}">
                            </div>
                          </div>
                        </div>
                        <br>
    
                        <hr>
                        <h4 class="card-title">Seção 4</h4>
    
                        <hr>
                        <br>
                        <div class="form-group row">
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_4_conteudo_20"
                                value="{{ $servico->section_4_conteudo_20 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_4_conteudo_21"
                                value="{{ $servico->section_4_conteudo_21 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_4_conteudo_22"
                                value="{{ $servico->section_4_conteudo_22 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_4_conteudo_23"
                                value="{{ $servico->section_4_conteudo_23 }}">
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for=""> {{ translate("Image") }}<small>(645x840px)</small></label>
                              <div class="input-group" data-toggle="aizuploader" data-type="image">
                                <div class="input-group-prepend">
                                  <div class="input-group-text bg-soft-secondary font-weight-medium">
                                    {{ translate("Browse") }}
                                  </div>
                                </div>
                                <div class="form-control file-amount"> {{ translate("Choose File") }} </div>
                                <input type="hidden" name="section_4_img_24" class="selected-files"
                                  value="{{ $servico->section_4_img_24 }}">
                              </div>
                              <div class="file-preview box"></div>
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Legenda</label>
                              <input type="text" class="form-control" name="section_4_image_alt_24"
                                value="{{ $servico->section_4_image_alt_24 }}">
                            </div>
                          </div>
                        </div>
                        <br>
    
                        <hr>
                        <h4 class="card-title">Seção 5</h4>
    
                        <hr>
                        <br>
                        <div class="form-group row">
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for=""> {{ translate("Image") }}<small>(635x770px)</small></label>
                              <div class="input-group" data-toggle="aizuploader" data-type="image">
                                <div class="input-group-prepend">
                                  <div class="input-group-text bg-soft-secondary font-weight-medium">
                                    {{ translate("Browse") }}
                                  </div>
                                </div>
                                <div class="form-control file-amount"> {{ translate("Choose File") }} </div>
                                <input type="hidden" name="section_5_img_25" class="selected-files"
                                  value="{{ $servico->section_5_img_25 }}">
                              </div>
                              <div class="file-preview box"></div>
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Legenda</label>
                              <input type="text" class="form-control" name="section_5_image_alt_25"
                                value="{{ $servico->section_5_image_alt_25 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_5_conteudo_26"
                                value="{{ $servico->section_5_conteudo_26 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_5_conteudo_27"
                                value="{{ $servico->section_5_conteudo_27 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_5_conteudo_28"
                                value="{{ $servico->section_5_conteudo_28 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_5_conteudo_29"
                                value="{{ $servico->section_5_conteudo_29 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_5_conteudo_30"
                                value="{{ $servico->section_5_conteudo_30 }}">
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Link Botão</label>
                              <input type="text" class="form-control" name="section_5_link_31"
                                value="{{ $servico->section_5_link_31 }}">
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Texto Âncora</label>
                              <input type="text" class="form-control" name="section_5_link_alt_31"
                                value="{{ $servico->section_5_link_alt_31 }}">
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Nome Botão</label>
                              <input type="text" class="form-control" name="section_5_link_conteudo_31"
                                value="{{$servico->section_5_link_conteudo_31}}">
                            </div>
                          </div>
                        </div>
                        <br>
    
                        <hr>
                        <h4 class="card-title">Seção 6</h4>
    
                        <hr>
                        <br>
                        <div class="form-group row">
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for=""> {{ translate("Image") }}<small>(1015x390px)</small></label>
                              <div class="input-group" data-toggle="aizuploader" data-type="image">
                                <div class="input-group-prepend">
                                  <div class="input-group-text bg-soft-secondary font-weight-medium">
                                    {{ translate("Browse") }}
                                  </div>
                                </div>
                                <div class="form-control file-amount"> {{ translate("Choose File") }} </div>
                                <input type="hidden" name="section_6_img_32" class="selected-files"
                                  value="{{ $servico->section_6_img_32 }}">
                              </div>
                              <div class="file-preview box"></div>
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Legenda</label>
                              <input type="text" class="form-control" name="section_6_image_alt_32"
                                value="{{ $servico->section_6_image_alt_32 }}">
                            </div>
                          </div>
                        </div>
                        <br>
    
                        <hr>
                        <h4 class="card-title">Seção 7</h4>
    
                        <hr>
                        <br>
                        <div class="form-group row">
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_7_conteudo_33"
                                value="{{ $servico->section_7_conteudo_33 }}">
                            </div>
                          </div>
                        </div>
                        <br>
    
                        <hr>
                        <h4 class="card-title">Seção 8</h4>
    
                        <hr>
                        <br>
                        <div class="form-group row">
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_8_conteudo_34"
                                value="{{ $servico->section_8_conteudo_34 }}">
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Link Botão</label>
                              <input type="text" class="form-control" name="section_8_link_35"
                                value="{{ $servico->section_8_link_35 }}">
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Texto Âncora</label>
                              <input type="text" class="form-control" name="section_8_link_alt_35"
                                value="{{ $servico->section_8_link_alt_35 }}">
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for=""> {{ translate("Image") }}<small>(250x250px)</small></label>
                              <div class="input-group" data-toggle="aizuploader" data-type="image">
                                <div class="input-group-prepend">
                                  <div class="input-group-text bg-soft-secondary font-weight-medium">
                                    {{ translate("Browse") }}
                                  </div>
                                </div>
                                <div class="form-control file-amount"> {{ translate("Choose File") }} </div>
                                <input type="hidden" name="section_8_img_36" class="selected-files"
                                  value="{{ $servico->section_8_img_36 }}">
                              </div>
                              <div class="file-preview box"></div>
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Legenda</label>
                              <input type="text" class="form-control" name="section_8_image_alt_36"
                                value="{{ $servico->section_8_image_alt_36 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_8_conteudo_37"
                                value="{{ $servico->section_8_conteudo_37 }}">
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Link Botão</label>
                              <input type="text" class="form-control" name="section_8_link_38"
                                value="{{ $servico->section_8_link_38 }}">
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Texto Âncora</label>
                              <input type="text" class="form-control" name="section_8_link_alt_38"
                                value="{{ $servico->section_8_link_alt_38 }}">
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for=""> {{ translate("Image") }}<small>(250x250px)</small></label>
                              <div class="input-group" data-toggle="aizuploader" data-type="image">
                                <div class="input-group-prepend">
                                  <div class="input-group-text bg-soft-secondary font-weight-medium">
                                    {{ translate("Browse") }}
                                  </div>
                                </div>
                                <div class="form-control file-amount"> {{ translate("Choose File") }} </div>
                                <input type="hidden" name="section_8_img_39" class="selected-files"
                                  value="{{ $servico->section_8_img_39 }}">
                              </div>
                              <div class="file-preview box"></div>
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Legenda</label>
                              <input type="text" class="form-control" name="section_8_image_alt_39"
                                value="{{ $servico->section_8_image_alt_39 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_8_conteudo_40"
                                value="{{ $servico->section_8_conteudo_40 }}">
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Link Botão</label>
                              <input type="text" class="form-control" name="section_8_link_41"
                                value="{{ $servico->section_8_link_41 }}">
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Texto Âncora</label>
                              <input type="text" class="form-control" name="section_8_link_alt_41"
                                value="{{ $servico->section_8_link_alt_41 }}">
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for=""> {{ translate("Image") }}<small>(250x250px)</small></label>
                              <div class="input-group" data-toggle="aizuploader" data-type="image">
                                <div class="input-group-prepend">
                                  <div class="input-group-text bg-soft-secondary font-weight-medium">
                                    {{ translate("Browse") }}
                                  </div>
                                </div>
                                <div class="form-control file-amount"> {{ translate("Choose File") }} </div>
                                <input type="hidden" name="section_8_img_42" class="selected-files"
                                  value="{{ $servico->section_8_img_42 }}">
                              </div>
                              <div class="file-preview box"></div>
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Legenda</label>
                              <input type="text" class="form-control" name="section_8_image_alt_42"
                                value="{{ $servico->section_8_image_alt_42 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_8_conteudo_43"
                                value="{{ $servico->section_8_conteudo_43 }}">
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Link Botão</label>
                              <input type="text" class="form-control" name="section_8_link_44"
                                value="{{ $servico->section_8_link_44 }}">
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Texto Âncora</label>
                              <input type="text" class="form-control" name="section_8_link_alt_44"
                                value="{{ $servico->section_8_link_alt_44 }}">
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for=""> {{ translate("Image") }}<small>(250x250px)</small></label>
                              <div class="input-group" data-toggle="aizuploader" data-type="image">
                                <div class="input-group-prepend">
                                  <div class="input-group-text bg-soft-secondary font-weight-medium">
                                    {{ translate("Browse") }}
                                  </div>
                                </div>
                                <div class="form-control file-amount"> {{ translate("Choose File") }} </div>
                                <input type="hidden" name="section_8_img_45" class="selected-files"
                                  value="{{ $servico->section_8_img_45 }}">
                              </div>
                              <div class="file-preview box"></div>
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Legenda</label>
                              <input type="text" class="form-control" name="section_8_image_alt_45"
                                value="{{ $servico->section_8_image_alt_45 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_8_conteudo_46"
                                value="{{ $servico->section_8_conteudo_46 }}">
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Link Botão</label>
                              <input type="text" class="form-control" name="section_8_link_47"
                                value="{{ $servico->section_8_link_47 }}">
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Texto Âncora</label>
                              <input type="text" class="form-control" name="section_8_link_alt_47"
                                value="{{ $servico->section_8_link_alt_47 }}">
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Nome Botão</label>
                              <input type="text" class="form-control" name="section_8_link_conteudo_47"
                                value="{{$servico->section_8_link_conteudo_47}}">
                            </div>
                          </div>
                        </div>
                        <br>
    
                        <hr>
                        <h4 class="card-title">Seção 9</h4>
    
                        <hr>
                        <br>
                        <div class="form-group row">
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_9_conteudo_48"
                                value="{{ $servico->section_9_conteudo_48 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_9_conteudo_49"
                                value="{{ $servico->section_9_conteudo_49 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_9_conteudo_50"
                                value="{{ $servico->section_9_conteudo_50 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_9_conteudo_51"
                                value="{{ $servico->section_9_conteudo_51 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_9_conteudo_52"
                                value="{{ $servico->section_9_conteudo_52 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_9_conteudo_53"
                                value="{{ $servico->section_9_conteudo_53 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_9_conteudo_54"
                                value="{{ $servico->section_9_conteudo_54 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_9_conteudo_55"
                                value="{{ $servico->section_9_conteudo_55 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_9_conteudo_56"
                                value="{{ $servico->section_9_conteudo_56 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_9_conteudo_57"
                                value="{{ $servico->section_9_conteudo_57 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_9_conteudo_58"
                                value="{{ $servico->section_9_conteudo_58 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_9_conteudo_59"
                                value="{{ $servico->section_9_conteudo_59 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_9_conteudo_60"
                                value="{{ $servico->section_9_conteudo_60 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_9_conteudo_61"
                                value="{{ $servico->section_9_conteudo_61 }}">
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Link Botão</label>
                              <input type="text" class="form-control" name="section_9_link_62"
                                value="{{ $servico->section_9_link_62 }}">
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Texto Âncora</label>
                              <input type="text" class="form-control" name="section_9_link_alt_62"
                                value="{{ $servico->section_9_link_alt_62 }}">
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Nome Botão</label>
                              <input type="text" class="form-control" name="section_9_link_conteudo_62"
                                value="{{$servico->section_9_link_conteudo_62}}">
                            </div>
                          </div>
                        </div>
                        <br>
    
                        <hr>
                        <h4 class="card-title">Seção 10</h4>
    
                        <hr>
                        <br>
                        <div class="form-group row">
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_10_conteudo_63"
                                value="{{ $servico->section_10_conteudo_63 }}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_10_conteudo_64"
                                value="{{ $servico->section_10_conteudo_64 }}">
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Link Botão</label>
                              <input type="text" class="form-control" name="section_10_link_65"
                                value="{{ $servico->section_10_link_65 }}">
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Texto Âncora</label>
                              <input type="text" class="form-control" name="section_10_link_alt_65"
                                value="{{ $servico->section_10_link_alt_65 }}">
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Nome Botão</label>
                              <input type="text" class="form-control" name="section_10_link_conteudo_65"
                                value="{{$servico->section_10_link_conteudo_65}}">
                            </div>
                          </div>
                          <div class="col-md-12">
                            <div class="form-group">
                              <label class="mr-sm-2" for="">Conteúdo</label>
                              <input type="text" class="form-control" name="section_10_conteudo_66"
                                value="{{ $servico->section_10_conteudo_66 }}">
                            </div>
                          </div>
                        </div>
                        <div class="clearfix"></div>
    
                      </div>
                        <div class="row mb-3">
                            <input id="searchInput" class="controls" type="text" placeholder="{{translate('Enter a location')}}">
                            <div id="map"></div>
                            <ul id="geoData">
                                <li style="display: none;">{{ translate('Full Address') }}: <span id="location"></span></li>
                                <li style="display: none;">{{ translate('Postal Code') }}: <span id="postal_code"></span></li>
                                <li style="display: none;">{{ translate('Country') }}: <span id="country"></span></li>
                                <li style="display: none;">{{ translate('Latitude') }}: <span id="lat"></span></li>
                                <li style="display: none;">{{ translate('Longitude') }}: <span id="lon"></span></li>
                            </ul>
                        </div>
                        <div class="row">
                            <div class="col-md-2" id="">
                                <label for="exampleInputuname">{{ translate('Longitude') }}</label>
                            </div>
                            <div class="col-md-10" id="">
                                <input type="text" class="form-control mb-3" id="longitude" name="delivery_pickup_longitude" readonly="" value="{{ $servico->delivery_pickup_longitude }}">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-2" id="">
                                <label for="exampleInputuname">{{ translate('Latitude') }}</label>
                            </div>
                            <div class="col-md-10" id="">
                                <input type="text" class="form-control mb-3" id="latitude" name="delivery_pickup_latitude" readonly="" value="{{ $servico->delivery_pickup_latitude }}">
                            </div>
                        </div>
                        <br>
                        <hr>
                        <h4 class="card-title">Texto SEO</h4>
                        <hr>
                        <br>
                        <div class="form-group row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="col-form-label" for="">Breve</label>
                                    <textarea name="textocorrido" class="ckeditor" id="ckeditor" cols="30" rows="10"><?php if (isset($servico->textocorrido) && !empty($servico->textocorrido)) {
                                        echo $servico->textocorrido;
                                    } ?></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-md-3 col-form-label">{{ translate('Slug') }}</label>
                            <div class="col-md-9">
                                <input type="text" placeholder="{{ translate('Slug') }}" name="slug"
                                    id="slug" value="{{ $servico->slug }}" class="form-control" required>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label class="col-md-3 col-form-label">{{ translate('Meta Title') }}</label>
                            <div class="col-md-9">
                                <input type="text" class="form-control" name="meta_title"
                                    value="{{ $servico->meta_title }}" placeholder="{{ translate('Meta Title') }}">
                            </div>
                        </div>


                        <div class="form-group row">
                            <label class="col-md-3 col-form-label">{{ translate('Meta Description') }}</label>
                            <div class="col-md-9">
                                <textarea name="meta_description" rows="5" class="form-control">{{ $servico->meta_description }}</textarea>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label class="col-md-3 col-form-label">
                                {{ translate('Meta Keywords') }}
                            </label>
                            <div class="col-md-9">
                                <input type="text" class="form-control" id="meta_keywords" name="meta_keywords"
                                    value="{{ $servico->meta_keywords }}"
                                    placeholder="{{ translate('Meta Keywords') }}">
                            </div>
                        </div>

                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Save') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        function makeSlug(val) {
            let str = val;
            let output = str.replace(/\s+/g, '-').toLowerCase();
            $('#slug').val(output);
        }
    </script>
    <script>
            const phoneInput = document.getElementById('map_cellphone');
            
            phoneInput.addEventListener('input', function(event) {
                let value = phoneInput.value.replace(/\D/g, ''); // Remove non-numeric characters
                
                if (value.length > 11) {
                    value = value.slice(0, 11); // Limit to 11 digits
                }
                
                // Format value as (00) 00000-0000
                const formattedValue = value
                    .replace(/^(\d{2})(\d{0,5})/, '($1) $2')
                    .replace(/(\d{5})(\d{0,4})/, '$1-$2');
                
                phoneInput.value = formattedValue;
            });
        function initialize(id_format = '') {
            let default_longtitude = '';
            let default_latitude = '';
            @if (get_setting('google_map_longtitude') != '' && get_setting('google_map_longtitude') != '')
                default_longtitude = {{ get_setting('google_map_longtitude') }};
                default_latitude = {{ get_setting('google_map_latitude') }};
            @endif

            var lat = -33.8688;
            var long = 151.2195;

            if (document.getElementById('latitude').value != '' &&
                document.getElementById('longitude').value != '') {
                lat = parseFloat(document.getElementById('latitude').value);
                long = parseFloat(document.getElementById('longitude').value);
            } else if (default_longtitude != '' &&
                default_latitude != '') {
                lat = default_latitude;
                long = default_longtitude;
            }


            var map = new google.maps.Map(document.getElementById('map'), {
                center: {
                    lat: lat,
                    lng: long
                },
                zoom: 13
            });

            var myLatlng = new google.maps.LatLng(lat, long);

            var input = document.getElementById(id_format + 'searchInput');
            // console.log(input);
            map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);

            var autocomplete = new google.maps.places.Autocomplete(input);

            autocomplete.bindTo('bounds', map);

            var infowindow = new google.maps.InfoWindow();
            var marker = new google.maps.Marker({
                map: map,
                position: myLatlng,
                anchorPoint: new google.maps.Point(0, -29),
                draggable: true,
            });

            map.addListener('click', function(event) {
                marker.setPosition(event.latLng);
                document.getElementById(id_format + 'latitude').value = event.latLng.lat();
                document.getElementById(id_format + 'longitude').value = event.latLng.lng();
                infowindow.setContent('Latitude: ' + event.latLng.lat() + '<br>Longitude: ' + event.latLng.lng());
                infowindow.open(map, marker);
            });

            google.maps.event.addListener(marker, 'dragend', function(event) {
                document.getElementById(id_format + 'latitude').value = event.latLng.lat();
                document.getElementById(id_format + 'longitude').value = event.latLng.lng();
                infowindow.setContent('Latitude: ' + event.latLng.lat() + '<br>Longitude: ' + event.latLng.lng());
                infowindow.open(map, marker);
            });

            autocomplete.addListener('place_changed', function() {
                infowindow.close();
                marker.setVisible(false);
                var place = autocomplete.getPlace();

                if (!place.geometry) {
                    window.alert("Autocomplete's returned place contains no geometry");
                    return;
                }

                // If the place has a geometry, then present it on a map.
                if (place.geometry.viewport) {
                    map.fitBounds(place.geometry.viewport);
                } else {
                    map.setCenter(place.geometry.location);
                    map.setZoom(17);
                }
                /*
                marker.setIcon(({
                    url: place.icon,
                    size: new google.maps.Size(71, 71),
                    origin: new google.maps.Point(0, 0),
                    anchor: new google.maps.Point(17, 34),
                    scaledSize: new google.maps.Size(35, 35)
                }));
                */
                marker.setPosition(place.geometry.location);
                marker.setVisible(true);

                var address = '';
                if (place.address_components) {
                    address = [
                        (place.address_components[0] && place.address_components[0].short_name || ''),
                        (place.address_components[1] && place.address_components[1].short_name || ''),
                        (place.address_components[2] && place.address_components[2].short_name || '')
                    ].join(' ');
                }

                infowindow.setContent('<div><strong>' + place.name + '</strong><br>' + address);
                infowindow.open(map, marker);

                //Location details
                for (var i = 0; i < place.address_components.length; i++) {
                    if (place.address_components[i].types[0] == 'postal_code') {
                        document.getElementById('postal_code').innerHTML = place.address_components[i].long_name;
                    }
                    if (place.address_components[i].types[0] == 'country') {
                        document.getElementById('country').innerHTML = place.address_components[i].long_name;
                    }
                }
                document.getElementById('location').innerHTML = place.formatted_address;
                document.getElementById(id_format + 'latitude').value = place.geometry.location.lat();
                document.getElementById(id_format + 'longitude').value = place.geometry.location.lng();
            });

        }
    </script>

    <script src="https://maps.googleapis.com/maps/api/js?key={{ env('MAP_API_KEY') }}&libraries=places&language=en&callback=initialize" async defer></script>
@endsection
