<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Servicoall;
use App\Models\Servicosall;
use Artisan;
use CoreComponentRepository;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\URL;
use Str;

class ServicoallController extends Controller
{

    public function index(Request $request)
    {
        $items = Servicoall::where('theme', get_setting('homepage_select'))->get();

        if ($items->isNotEmpty()) {
            $transformedArray = $items->map(function($item) {
                return [$item->type => $item->value];
            })->reduce(function($carry, $item) {
                return array_merge($carry, $item);
            }, []);
            $item = (object) $transformedArray;
        } else {
            $item = [];
        }

        return view('backend.themes.servicoall.' . get_setting('homepage_select') . '.edit', compact('item'));
    }

    public function create()
    {
        $originalItem = Servicosall::first();
        if (!$originalItem) {
            $item = new Servicosall();
            $item->title = Str::random(10);
            $item->slug = Str::slug(Str::random(10));
            $item->save();
            return redirect()->route('servico.edit', $item->id);
        }
        $item = $originalItem->replicate();
        $item->slug = Str::slug(Str::random(10));
        $item->save();
        return redirect()->route('servico.edit', $item->id);
    }


    public function edit($id)
    {
        $items = Servicoall::where('theme', get_setting('homepage_select'))->get();

        if ($items->isNotEmpty()) {
            $transformedArray = $items->map(function($item) {
                return [$item->type => $item->value];
            })->reduce(function($carry, $item) {
                return array_merge($carry, $item);
            }, []);
            $item = (object) $transformedArray;
        } else {
            $item = [];
        }

        return view('backend.themes.servicoall.' . get_setting('homepage_select') . '.edit', compact('item'));
    }

    public function destroy($id)
    {
        Servicosall::find($id)->delete();
        $relatedServicos = Servicoall::where('product', $id)->get();
        if ($relatedServicos->isNotEmpty()) {
            foreach ($relatedServicos as $relatedServico) {
                $relatedServico->delete();
            }
        }
        return redirect()->back();
    }

    public function general_setting()
    {
        $items = Servicoall::where('theme', get_setting('homepage_select'))->get();

        if ($items->isNotEmpty()) {
            $transformedArray = $items->map(function($item) {
                return [$item->type => $item->value];
            })->reduce(function($carry, $item) {
                return array_merge($carry, $item);
            }, []);
            $item = (object) $transformedArray;
        } else {
            $item = [];
        }

        return view('backend.themes.servicoall.' . get_setting('homepage_select') . '.edit', compact('item'));
    }

    public function all_servico(){
        $services = Servicosall::all();
        return view("frontend.".get_setting('homepage_select').".servico", compact('services'));
    }

    public function update(Request $request){
        foreach ($request->types as $key => $type) {
            if (gettype($type) == 'array') {
                $lang = array_key_first($type);
                $type = $type[$lang];
                $business_settings = Servicoall::where('type', $type)->where('lang', $lang)->first();
            } else {
                $business_settings = Servicoall::where('type', $type)->first();
            }
            if ($business_settings != null) {
                if (gettype($request[$type]) == 'array') {
                    $business_settings->value = json_encode($request[$type]);
                } else {
                    $business_settings->value = $request[$type];
                }
                $business_settings->theme = get_setting('homepage_select');
                $business_settings->save();
            } else {
                $business_settings = new Servicoall;
                $business_settings->theme = get_setting('homepage_select');
                $business_settings->type = $type;
                if (gettype($request[$type]) == 'array') {
                    $business_settings->value = json_encode($request[$type]);
                } else {
                    $business_settings->value = $request[$type];
                }
                $business_settings->save();
            }
        }

        Artisan::call('cache:clear');

        flash(translate("Configurações atualizadas com sucesso"))->success();
        if ($request->has('tab')) {
            return Redirect::to(URL::previous() . "#" . $request->tab);
        }
        return redirect()->back();
    }
}


