<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Sliders;
use Artisan;
use CoreComponentRepository;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\URL;
use Str;

class SlidersController extends Controller
{

    public function index(Request $request)
    {
        $sort_search = null;
        $query = Sliders::query();
        if ($request->search != null) {
            $query->where('title', 'like', '%' . $request->search . '%');
            $sort_search = $request->search;
        }
        $items = $query->paginate(15);
        return view('backend.themes.sliders.' . get_setting('homepage_select') . '.index', compact('items', 'sort_search'));
    }

    public function create()
    {
        $item = new Sliders();
            $item->title = Str::random(10);
            $item->slug = Str::slug(Str::random(10));
            $item->save();
            return redirect()->route('sliders.edit', $item->id);
    }


    public function edit($id)
    {
        $itemnew = Sliders::find($id);

        return view('backend.themes.sliders.' . get_setting('homepage_select') . '.edit', compact('itemnew'));
    }

    public function destroy($id)
    {
        Sliders::find($id)->delete();
        
        return redirect()->back();
    }

    public function editSliders()
    {
        $items = Sliders::where('theme', get_setting('homepage_select'))->get();

        if ($items->isNotEmpty()) {
            $transformedArray = $items->map(function($item) {
                return [$item->type => $item->value];
            })->reduce(function($carry, $item) {
                return array_merge($carry, $item);
            }, []);
            $item = (object) $transformedArray;
        } else {
            dd('Nenhum item encontrado');
        }

        return view('backend.themes.' . get_setting('homepage_select') . '.sliders.edit', compact('item'));
    }

    public function update(Request $request,$id){
        $item = Sliders::find($id);
        $item->title = $request->title ?? '';
        $item->slug = $request->slug ?? '';
        
        foreach ($request->types as $key => $type) {
            if (gettype($type) == 'array') {
                $lang = array_key_first($type);
                $type = $type[$lang];
            }
                if (gettype($request[$type]) == 'array') {
                    $item->value = json_encode($request[$type]);
                } else {
                    $item->value = $request[$type];
                }
        }
        $item->save();
        Artisan::call('cache:clear');

        flash(translate("Configurações atualizadas com sucesso"))->success();
        if ($request->has('tab')) {
            return Redirect::to(URL::previous() . "#" . $request->tab);
        }
        return redirect()->back();
    }
}


