<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\BlogCategory;
use App\Models\Blog;
use App\Models\Unidades;
use Storage;
use Image;
use enshrined\svgSanitize\Sanitizer;

class UnidadesController extends Controller
{

    public function index(Request $request)
    {
        $sort_search = null;
        $query = Unidades::query();
    
        if ($request->search != null){
            $query->where('title', 'like', '%'.$request->search.'%');
            $sort_search = $request->search;
        }
    
        $servicos = $query->paginate(15);
    
        return view('backend.servico.index', compact('servicos', 'sort_search'));
    }

    public function clone($id)
    {
        $servico = Unidades::findOrFail($id);
        $newServico = $servico->replicate();
        $newServico->save();
    
        return redirect()->route('unidades.index')->with('success', 'Serviço clonado com sucesso!');
    }

    public function create()
    {
        $blog_categories = BlogCategory::all();
        return view('backend.servico.create', compact('blog_categories'));
    }

    public function store(Request $request)
    {
        $servico = new Unidades();
        $servico->delivery_pickup_longitude = $request->delivery_pickup_longitude;
        $servico->delivery_pickup_latitude = $request->delivery_pickup_latitude;
        $servico->map_title = $request->map_title;
        $servico->map_cellphone = $request->map_cellphone;
        $servico->address = $request->address;
        $servico->imagem = $request->imagem;
        $servico->save();
        flash(translate('Unidade Criada'))->success();
        return redirect()->route('unidades.index');
    }

    public function show($id)
    {
        
    }

    public function edit($id)
    {
        $servico = Unidades::find($id);
        return view('backend.servico.edit', compact('servico'));
    }

    public function update(Request $request, $id)
    {        
        $servico = Unidades::find($id);
        $servico->delivery_pickup_longitude = $request->delivery_pickup_longitude;
        $servico->delivery_pickup_latitude = $request->delivery_pickup_latitude;
        $servico->map_title = $request->map_title;
        $servico->map_cellphone = $request->map_cellphone;
        $servico->address = $request->address;
        $servico->imagem = $request->imagem;
        $servico->save();
        flash(translate('Unidade Atualizada'))->success();
        return redirect()->route('unidades.index');
    }
    
    public function change_status(Request $request) {
        $blog = Unidades::find($request->id);
        $blog->status = $request->status;
        $blog->save();
        return 1;
    }

    public function destroy($id)
    {
        Servico::find($id)->delete();
        
        return redirect('admin/servico');
    }

}
