<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Servicosall extends Model {
    public $timestamps = false;
    protected $table = "tabela_servicos";
    
    public function servicos()
    {
        return $this->hasMany(Servicoall::class, 'product', 'id');
    }

    public function getFilteredServicos()
    {
        return $this->servicos()
                    ->whereIn('type', ['section_card_img_1', 'section_card_conteudo_2', 'section_card_conteudo_3'])
                    ->pluck('value', 'type');
    }
}
