@extends('backend.layouts.app')

@section('content')

<div class="card">
    <div class="card-header">
        <h5 class="mb-0 h6">{{translate('Produtos Classificados')}}</h5>
    </div>
    <div class="card-body">
        <table class="table aiz-table mb-0">
            <thead>
                <tr>
                    <th data-breakpoints="lg">#</th>
                    <th>{{translate('Nome')}}</th>
                    <th data-breakpoints="lg">{{translate('Imagem')}}</th>
                    <th data-breakpoints="lg">{{translate('Enviado por')}}</th>
                    <th data-breakpoints="lg">{{translate('Status do cliente')}}</th>
                    <th data-breakpoints="lg">{{translate('Publicado')}}</th>
                    <th class="text-right" width="10%">{{translate('Opções')}}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($products as $key => $product)
                    <tr>
                        <td>{{ ($key+1) + ($products->currentPage() - 1)*$products->perPage() }}</td>
                        <td><a href="{{ route('customer.product', $product->slug) }}" class="text-reset text-truncate-2" target="_blank">{{$product->getTranslation('name')}}</a></td>
                        <td><img src="{{ uploaded_asset($product->thumbnail_img) }}" alt="{{translate('Imagem do produto')}}" class="h-50px"></td>
                        <td>{{$product->added_by}}</td>
                        <td>
                            @if ($product->status == 1)
                                <span class="badge badge-inline badge-success">{{ translate('PUBLICADO') }}</span>
                            @else
                                <span class="badge badge-inline badge-danger">{{ translate('NÃO PUBLICADO') }}</span>
                            @endif
                        </td>
                        <td>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input
                                    @can('publish_classified_product') onchange="update_published(this)" @endcan
                                    value="{{ $product->id }}" type="checkbox" <?php if($product->published == 1) echo "checked";?>
                                    @if(!auth()->user()->can('publish_classified_product')) disabled @endif
                                >
                                <span class="slider round"></span>
                            </label>
                        </td>
                        <td class="text-right">
                            <a class="btn btn-soft-primary btn-icon btn-circle btn-sm" href="{{route('customer.product', $product->slug)}}" title="{{ translate('Mostrar') }}">
                                <i class="las la-eye"></i>
                            </a>
                            @can('delete_classified_product')
                                <a href="#" class="btn btn-soft-danger btn-icon btn-circle btn-sm confirm-delete" data-href="{{route('classified_products.destroy', $product->id)}}}}" title="{{ translate('Excluir') }}">
                                    <i class="las la-trash"></i>
                                </a>
                            @endcan
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
        <div class="aiz-pagination">
            {{ $products->links() }}
        </div>
    </div>
</div>
@endsection

@section('modal')
    @include('modals.delete_modal')
@endsection

@section('script')
    <script type="text/javascript">s

        function update_published(el){

            if('{{env('DEMO_MODE')}}' == 'On'){
                AIZ.plugins.notify('info', '{{ translate('Os dados não podem ser alterados no modo de demonstração.') }}');
                return;
            }

            if(el.checked){
                var status = 1;
            }
            else{
                var status = 0;
            }
            $.post('{{ route('classified_products.published') }}', {_token:'{{ csrf_token() }}', id:el.value, status:status}, function(data){
                if(data == 1){
                    AIZ.plugins.notify('success', '{{ translate('Produtos publicados atualizados com sucesso') }}');
                }
                else{
                    AIZ.plugins.notify('danger', '{{ translate('Algo deu errado') }}');
                }
            });
        }
    </script>
@endsection
