@extends('backend.layouts.app')
@section('content')

<div class="aiz-titlebar text-left mt-2 mb-3">
	<div class="align-items-center">
			<h1 class="h3">{{translate('Atualizar informações do pacote')}}</h1>
	</div>
</div>

<div class="row">
    <div class="col-lg-8 mx-auto">
        <div class="card">
            <div class="card-body p-0">
                <!-- Error Meassages -->
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                
                <ul class="nav nav-tabs nav-fill language-bar">
                  @foreach (get_all_active_language() as $key => $language)
                    <li class="nav-item">
                      <a class="nav-link text-reset @if ($language->code == $lang) active @endif py-3" href="{{ route('customer_packages.edit', ['id'=>$customer_package->id, 'lang'=> $language->code] ) }}">
                        <img src="{{ static_asset('assets/img/flags/'.$language->code.'.png') }}" height="11" class="mr-1">
                        <span>{{$language->name}}</span>
                      </a>
                    </li>
                      @endforeach
                </ul>
                <form class="p-4" action="{{ route('customer_packages.update', $customer_package->id) }}" method="POST">
                    <input type="hidden" name="_method" value="PATCH">
                    <input type="hidden" name="lang" value="{{ $lang }}">
                  	@csrf
                    <div class="form-group row">
                        <label class="col-sm-3 col-from-label">
                            {{translate('Nome do pacote')}}
                            <span class="text-danger">*</span> 
                            <i class="las la-language text-danger" title="{{translate('Traduzível')}}"></i>
                        </label>
                        <div class="col-sm-9">
                            <input type="text" placeholder="{{translate('Nome')}}" id="name" name="name" value="{{ $customer_package->getTranslation('name', $lang) }}" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-3 col-from-label">
                            {{translate('Quantia')}}
                            <span class="text-danger">*</span> 
                        </label>
                        <div class="col-sm-9">
                            <input type="number" lang="en" min="0" step="0.01" placeholder="{{translate('Quantia')}}" value="{{ $customer_package->amount }}" id="amount" name="amount" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-3 col-from-label">
                            {{translate('Carregamento de produto')}}
                            <span class="text-danger">*</span> 
                        </label>
                        <div class="col-sm-9">
                            <input type="number" lang="en" min="0" step="1" placeholder="{{translate('Carregamento de produto')}}" value="{{ $customer_package->product_upload }}" id="product_upload" name="product_upload" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-md-3 col-form-label" for="signinSrEmail">
                            {{translate('Logotipo do pacote')}}
                            <span class="text-danger">*</span> 
                        </label>
                        <div class="col-md-9">
                            <div class="input-group" data-toggle="aizuploader" data-type="image">
                                <div class="input-group-prepend">
                                    <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate('Navegar')}}</div>
                                </div>
                                <div class="form-control file-amount">{{ translate('Escolha arquivo') }}</div>
                                <input type="hidden" name="logo" value="{{$customer_package->logo}}" class="selected-files">
                            </div>
                            <div class="file-preview box sm">
                            </div>
                        </div>
                    </div>
                    <div class="form-group mb-0 text-right">
                        <button type="submit" class="btn btn-primary">{{translate('Salvar')}}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@endsection
