@extends('backend.layouts.app')

@section('content')

    <div class="aiz-titlebar text-left mt-2 mb-3">
        <h5 class="mb-0 h6">{{ translate('Editar modelo de e-mail') }}</h5>
    </div>

    <div class="col-lg-8 mx-auto">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0 h6">{{ translate('Editar modelo de e-mail') }}</h5>
            </div>
            <div class="card-body">
                <form class="p-4" action="{{ route('email-templates.update', $emailTemplate->id) }}" method="POST"
                    enctype="multipart/form-data">
                    <input name="_method" type="hidden" value="PATCH">
                    @csrf
                    <div class="form-group row">
                        <label class="col-md-3 col-from-label" for="email_type">{{ translate('Tipo de e-mail') }}</label>
                        <div class="col-md-9">
                            <input type="text" id="email_type" value="{{ translate($emailTemplate->email_type) }}" class="form-control" readonly>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-md-3 col-from-label" for="subject">{{ translate('Assunto') }}</label>
                        <div class="col-md-9">
                            <input type="text" placeholder="{{ translate('Assunto do e-mail') }}" id="subject"
                                name="subject" value="{{ $emailTemplate->subject }}"
                                class="form-control" required>
                        </div>
                    </div>
                    
                    <div class="form-group row">
                        <label class="col-md-3 col-from-label" for="default_text">{{ translate('Texto padrão') }}</label>
                        <div class="col-md-9">
                            @if($emailTemplate->is_dafault_text_editable == 1)
                                <textarea type="text" 
                                    name="default_text" 
                                    id="default_text" 
                                    class="aiz-text-editor" 
                                    data-min-height="350px" 
                                    data-buttons='[["font", ["bold", "underline", "italic"]],["para", ["ul", "ol"]],["insert", ["link"]],["view", ["undo","redo"]]]'
                                    placeholder="{{ translate('Texto padrão') }}" required>
                                    {{ $emailTemplate->default_text }}
                                </textarea>
                                <small class="form-text text-danger">{{ translate('N.B: Não altere as variáveis ​​como') }} [[ ____ ]]</small>
                            @else
                                <small class="form-text fs-13 text-danger">{{ translate('O conteúdo não é editável para este e-mail.') }}</small>
                            @endif
                        </div>
                    </div>
                    
                    <div class="form-group mb-0 text-right">
                        <button type="submit" class="btn btn-primary">{{ translate('Salvar') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection
