@extends('backend.layouts.app')

@section('content')
    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0 h6">{{translate('Configuração de bate-papo do Facebook')}}</h5>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('facebook_chat.update') }}" method="POST">
                        @csrf
                        <div class="form-group row">
                            <div class="col-md-3">
                                <label class="col-from-label">{{translate('Bate-papo do Facebook')}}</label>
                            </div>
                            <div class="col-md-7">
                                <label class="aiz-switch aiz-switch-success mb-0">
                                    <input value="1" name="facebook_chat" type="checkbox" @if (get_setting('facebook_chat') == 1)
                                        checked
                                    @endif>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="FACEBOOK_PAGE_ID">
                            <div class="col-md-3">
                                <label class="col-from-label">{{translate('ID da página do Facebook')}}</label>
                            </div>
                            <div class="col-md-7">
                                <input type="text" class="form-control" name="FACEBOOK_PAGE_ID" value="{{  env('FACEBOOK_PAGE_ID') }}" placeholder="{{ translate('ID da página do Facebook') }}" required>
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-sm btn-primary">{{translate('Salvar')}}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card bg-gray-light">
              <div class="card-header">
                  <h5 class="mb-0 h6">{{ translate('Tenha cuidado ao configurar o bate-papo do Facebook. Para configuração incorreta, você não obterá o ícone do messenger no site do usuário final.') }}</h5>
              </div>
                <div class="card-body">
                    <ul class="list-group mar-no">
                        <li class="list-group-item text-dark">1. {{ translate('Faça login na sua página do Facebook') }}</li>
                        <li class="list-group-item text-dark">2. {{ translate('Encontre a opção Sobre da sua página do Facebook') }}.</li>
                        <li class="list-group-item text-dark">3. {{ translate('Na parte inferior, você pode encontrar o “ID da página do Facebook”') }}.</li>
                        <li class="list-group-item text-dark">4. {{ translate('Vá em Configurações da sua página e encontre a opção "Mensagens Avançadas"') }}.</li>
                        <li class="list-group-item text-dark">5. {{ translate('Role a página para baixo e você obterá "domínio na lista branca"') }}.</li>
                        <li class="list-group-item text-dark">6. {{ translate('Defina o nome de domínio do seu site') }}.</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
@endsection
