@extends('backend.layouts.app')

@section('content')
    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0 h6">{{translate('Configuração de comentários do Facebook')}}</h5>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('facebook-comment.update') }}" method="POST">
                        @csrf
                        <div class="form-group row">
                            <div class="col-md-5">
                                <label class="col-from-label">{{translate('Comentário no Facebook')}}</label>
                            </div>
                            <div class="col-md-7">
                                <label class="aiz-switch aiz-switch-success mb-0">
                                    @php
                                        $facebook_comment_data = \App\Models\BusinessSetting::where('type', 'facebook_comment')->first();
                                    @endphp
                                    <input value="1" name="facebook_comment" type="checkbox" @if ($facebook_comment_data && $facebook_comment_data->value == 1) checked @endif>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="FACEBOOK_APP_ID">
                            <div class="col-md-5">
                                <label class="col-from-label">{{translate('ID do aplicativo do Facebook')}}</label>
                            </div>
                            <div class="col-md-7">
                                <input type="text" class="form-control" name="FACEBOOK_APP_ID" value="{{  env('FACEBOOK_APP_ID') }}" placeholder="{{ translate('ID do aplicativo do Facebook') }}" required>
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-sm btn-primary">{{translate('Salvar')}}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card bg-gray-light">
              <div class="card-header">
                  <h5 class="mb-0 h6">{{ translate('Tenha cuidado ao configurar os comentários do Facebook. Para configuração incorreta, você não receberá uma seção de comentários no site do usuário final.') }}</h5>
              </div>
                <div class="card-body">
                    <ul class="list-group mar-no">
                        <li class="list-group-item text-dark">
                            1. {{ translate('Faça login na sua página do Facebook') }}
                        </li>
                        <li class="list-group-item text-dark">
                            2. {{ translate('Depois vá para este URL https://developers.facebook.com/apps/') }}.
                        </li>
                        <li class="list-group-item text-dark">
                            3. {{ translate('Crie seu aplicativo') }}.
                        </li>
                        <li class="list-group-item text-dark">
                            4. {{ translate('Na página do painel você obterá seu ID do aplicativo') }}.
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
@endsection
