@extends('backend.layouts.app')

@section('content')

<div class="row">
    <div class="col-lg-8 mx-auto">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0 h6">{{translate('Informações do ponto de coleta')}}</h5>
            </div>
            <form action="{{ route('pick_up_points.store') }}" method="POST">
            	@csrf
                <div class="card-body">
                    <div class="form-group row row">
                        <label class="col-sm-3 col-from-label" for="name">{{translate('Nome')}}</label>
                        <div class="col-sm-9">
                            <input type="text" placeholder="{{translate('Nome')}}" id="name" name="name" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group row row">
                        <label class="col-sm-3 col-from-label" for="address">{{translate('Localização')}}</label>
                        <div class="col-sm-9">
                            <textarea name="address" rows="8" class="form-control" required></textarea>
                        </div>
                    </div>
                    <div class="form-group row row">
                        <label class="col-sm-3 col-from-label" for="phone">{{translate('Telefone')}}</label>
                        <div class="col-sm-9">
                            <input type="text" placeholder="{{translate('Telefone')}}" id="phone" name="phone" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group row row">
                        <label class="col-sm-3 col-from-label">{{translate('Status do ponto de coleta')}}</label>
                        <div class="col-sm-3">
                            <label class="aiz-switch aiz-switch-success mb-0" style="margin-top:5px;">
                        		<input value="1" type="checkbox" name="pick_up_status">
                        		<span class="slider round"></span>
                            </label>
                        </div>
                    </div>
                    <div class="form-group row row">
                        <label class="col-sm-3 col-from-label" for="name">{{translate('Gerente de ponto de coleta')}}</label>
                        <div class="col-sm-9">
                            <select name="staff_id" class="form-control aiz-selectpicker" required>
                                @foreach(\App\Models\Staff::all() as $staff)
                                    @if ($staff->user != null)
                                        <option value="{{$staff->id}}">{{$staff->user->name}}</option>
                                    @endif
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="form-group mb-0 text-right">
                        <button type="submit" class="btn btn-primary">{{translate('Salvar')}}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection
