@extends('backend.layouts.app')

@section('content')
	<div class="row">
		<div class="col-lg-8 col-xxl-6 mx-auto">
			<div class="card">
				<div class="card-header d-block d-md-flex">
					<h3 class="h6 mb-0">{{ translate('Atualize seu sistema') }}</h3>
					<span>{{ translate('Versão atual') }}: {{ get_setting('current_version') }}</span>
				</div>
				<div class="card-body">
					<div class="alert alert-info mb-5">
						<ul class="mb-0">
							<li class="">
								{{ translate('Certifique-se de que seu servidor atenda a todos os requisitos.') }}
								<a href="{{route('system_server')}}">{{ translate('Verifique aqui') }}</a>
							</li>
							<li class="">{{ translate('Baixe a versão mais recente do codecanyon.') }}</li>
							<li class="">{{ translate('Extraia o zip baixado. Você encontrará o arquivo updates.zip nesses arquivos extraídos.') }}</li>
							<li class="">{{ translate('Carregue esse arquivo zip aqui e clique em atualizar agora.') }}</li>
							<li class="">{{ translate('Se você estiver usando algum complemento, certifique-se de atualizá-lo após a atualização.') }}</li>
							<li class="">{{ translate('Desligue o modo de manutenção antes de atualizar.') }}</li>
						</ul>
					</div>
					<form action="{{ route('update') }}" method="post" enctype="multipart/form-data">
						@csrf
						<div class="row gutters-5">
							<div class="col-md">
        						<div class="input-group " data-toggle="aizuploader" data-type="archive">
        							<div class="input-group-prepend">
        								<div class="input-group-text bg-soft-secondary">{{ translate('Navegar') }}</div>
        							</div>
        							<div class="form-control file-amount">{{ translate('Escolha arquivo') }}</div>
        							<input type="hidden" name="update_zip" value="" class="selected-files">
        						</div>
        						<div class="file-preview box"></div>
							</div>
							<div class="col-md-auto">
								<button type="submit" class="btn btn-primary btn-block">{{ translate('Atualizar agora') }}</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
@endsection
