@extends("backend.layouts.app")
@section("content")
<div class="row">
    <div class="col-lg-10 mx-auto">
        <form id="add_form" class="form-horizontal" action="{{ route('homeall.update') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="form-body">
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Section 1</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_1">
                                <input type="checkbox" name="show_section_1" value="1" {{ isset($item->show_section_1) && $item->show_section_1 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="col-form-label">Banner</label>
                                                <div class="row card-body">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-form-label">{{ translate("Imagem/video") }} </label>
                                                            <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                                                <div class="input-group-prepend">
                                                                    <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                                                </div>
                                                                <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                                                <input type="hidden" name="types[]" value="section_1_img_1">
                                                                <input type="hidden" name="section_1_img_1" class="selected-files" value="{{ $item->section_1_img_1 ?? '' }}">
                                                            </div>
                                                            <div class="file-preview box"></div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 col-sm-12">
                                                        <label class="col-form-label">Legenda</label>
                                                        <input type="hidden" name="types[]" value="section_1_img_alt_1">
                                                        <input class="form-control" type="text" name="section_1_img_alt_1" value="{{ $item->section_1_img_alt_1 ?? '' }}"/>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label class="col-form-label">Título</label>
                                                            <input type="hidden" name="types[]" value="section_1_conteudo_1">
                                                            <input type="text" class="form-control" name="section_1_conteudo_1" value="{{ $item->section_1_conteudo_1 ?? '' }}" />
                                                        </div>
                                                    </div>
                                                </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Section 2</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_2">
                                <input type="checkbox" name="show_section_2" value="1" {{ isset($item->show_section_2) && $item->show_section_2 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="col-form-label">Parques</label>
                                    @php
                                    $indice = 0;
                                    @endphp
                                    <input type="hidden" name="types[]" value="parques">
                                    <div class="parques-target">
                                        @if(isset($item->parques) && $item->parques != null && $item->parques != 'null')
                                        @foreach(json_decode($item->parques, true) as $key => $value)
                                        <div class="card shadow-lg">
                                            <div class="row card-body">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-form-label">{{ translate("Image") }} </label>
                                                        <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                                            <div class="input-group-prepend">
                                                                <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                                            </div>
                                                            <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                                            <input type="hidden" name="parques[{{ $key }}][imagem]" class="selected-files" value="{{ $value['imagem'] }}">
                                                        </div>
                                                        <div class="file-preview box"></div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-sm-12">
                                                    <label class="col-form-label">Legenda</label>
                                                    <input class="form-control" type="text" name="parques[{{ $key }}][legenda]" value="{{ $value['legenda'] }}" />
                                                </div>
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label class="col-form-label">Título</label>
                                                        <input type="text" class="form-control" name="parques[{{ $key }}][titulo]"
                                                            value="{{ $value['titulo'] }}">
                                                    </div>
                                                </div>
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label class="col-form-label">Texto</label>
                                                        <input type="text" class="form-control" name="parques[{{ $key }}][texto]"
                                                            value="{{ $value['texto'] }}">
                                                    </div>
                                                </div>
                                                <div class="col-md-4 col-sm-12">
                                                    <label class="col-form-label">Texto do Botão</label>
                                                    <input class="form-control" type="text" name="parques[{{ $key }}][botao]" value="{{ $value['botao'] }}" />
                                                </div>
                                                <div class="col-md-4 col-sm-12">
                                                    <label class="col-form-label">Link do Botão</label>
                                                    <input class="form-control" type="text" name="parques[{{ $key }}][link]" value="{{ $value['link'] }}" />
                                                </div>
                                                <div class="col-md-4 col-sm-12">
                                                    <label class="col-form-label">Legenda SEO</label>
                                                    <input class="form-control" type="text" name="parques[{{ $key }}][seo]" value="{{ $value['seo'] }}" />
                                                </div>
                                                <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                    <i class="las la-times"></i>
                                                </button>
                                            </div>
                                        </div>
                                        @php
                                        $indice++;
                                        @endphp
                                        @endforeach
                                        @endif
                                    </div>
                                    <button type="button" class="btn btn-soft-secondary btn-sm add-new-button add-new-button"
                                        data-toggle="add-more"
                                        data-content='
                                        <div class="card shadow-lg">
                                            <div class="row card-body">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-form-label">{{ translate("Image") }} </label>
                                                        <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                                            <div class="input-group-prepend">
                                                                <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                                            </div>
                                                            <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                                            <input type="hidden" name="parques[][imagem]" class="selected-files">
                                                        </div>
                                                        <div class="file-preview box"></div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-sm-12">
                                                    <label class="col-form-label">Legenda</label>
                                                    <input class="form-control" type="text" name="parques[][legenda]"/>
                                                </div>
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label class="col-form-label">Título</label>
                                                        <input type="text" class="form-control" name="parques[][titulo]">
                                                    </div>
                                                </div>
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label class="col-form-label">Texto</label>
                                                        <input type="text" class="form-control" name="parques[][texto]">
                                                    </div>
                                                </div>
                                                <div class="col-md-4 col-sm-12">
                                                    <label class="col-form-label">Texto do Botão</label>
                                                    <input class="form-control" type="text" name="parques[][botao]" />
                                                </div>
                                                <div class="col-md-4 col-sm-12">
                                                    <label class="col-form-label">Link do Botão</label>
                                                    <input class="form-control" type="text" name="parques[][link]" />
                                                </div>
                                                <div class="col-md-4 col-sm-12">
                                                    <label class="col-form-label">Legenda SEO</label>
                                                    <input class="form-control" type="text" name="parques[][seo]" />
                                                </div>
                                                <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                        <i class="las la-times"></i>
                                                </button>
                                            </div>
                                        </div>
                                        '
                                        data-target=".parques-target" data-indice="{{ $indice }}">
                                        {{ translate('Add New') }}
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Section 3</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_3">
                                <input type="checkbox" name="show_section_3" value="1" {{ isset($item->show_section_3) && $item->show_section_3 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Sub Título</label>
                                <input type="hidden" name="types[]" value="section_3_conteudo_5">
                                <input class="form-control" type="text" name="section_3_conteudo_5" value="{{ $item->section_3_conteudo_5 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_3_conteudo_6">
                                <input class="form-control" type="text" name="section_3_conteudo_6" value="{{ $item->section_3_conteudo_6 ?? '' }}" />
                            </div>
                            
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_3_conteudo_8">
                                <input class="form-control" type="text" name="section_3_conteudo_8" value="{{ $item->section_3_conteudo_8 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Descrição</label>
                                <input type="hidden" name="types[]" value="section_3_conteudo_9">
                                <input class="form-control" type="text" name="section_3_conteudo_9" value="{{ $item->section_3_conteudo_9 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_3_img_7">
                                        <input type="hidden" name="section_3_img_7" class="selected-files" value="{{ $item->section_3_img_7 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_3_image_alt_7">
                                <input class="form-control" type="text" name="section_3_image_alt_7" value="{{ $item->section_3_image_alt_7 ?? '' }}" />
                            </div>
                            
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_3_conteudo_11">
                                <input class="form-control" type="text" name="section_3_conteudo_11" value="{{ $item->section_3_conteudo_11 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Descrição</label>
                                <input type="hidden" name="types[]" value="section_3_conteudo_12">
                                <input class="form-control" type="text" name="section_3_conteudo_12" value="{{ $item->section_3_conteudo_12 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_3_img_10">
                                        <input type="hidden" name="section_3_img_10" class="selected-files" value="{{ $item->section_3_img_10 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_3_image_alt_10">
                                <input class="form-control" type="text" name="section_3_image_alt_10" value="{{ $item->section_3_image_alt_10 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_3_conteudo_14">
                                <input class="form-control" type="text" name="section_3_conteudo_14" value="{{ $item->section_3_conteudo_14 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_3_conteudo_15">
                                <input class="form-control" type="text" name="section_3_conteudo_15" value="{{ $item->section_3_conteudo_15 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_3_img_13">
                                        <input type="hidden" name="section_3_img_13" class="selected-files" value="{{ $item->section_3_img_13 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_3_image_alt_13">
                                <input class="form-control" type="text" name="section_3_image_alt_13" value="{{ $item->section_3_image_alt_13 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_3_conteudo_17">
                                <input class="form-control" type="text" name="section_3_conteudo_17" value="{{ $item->section_3_conteudo_17 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_3_conteudo_18">
                                <input class="form-control" type="text" name="section_3_conteudo_18" value="{{ $item->section_3_conteudo_18 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_3_img_16">
                                        <input type="hidden" name="section_3_img_16" class="selected-files" value="{{ $item->section_3_img_16 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_3_image_alt_16">
                                <input class="form-control" type="text" name="section_3_image_alt_16" value="{{ $item->section_3_image_alt_16 ?? '' }}" />
                            </div>
                            
                             <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_3_img_31">
                                        <input type="hidden" name="section_3_img_31" class="selected-files" value="{{ $item->section_3_img_31 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_3_image_alt_31">
                                <input class="form-control" type="text" name="section_3_image_alt_31" value="{{ $item->section_3_image_alt_31 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_3_conteudo_32">
                                <input class="form-control" type="text" name="section_3_conteudo_32" value="{{ $item->section_3_conteudo_32 ?? '' }}" />
                            </div>
                           
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Section 4</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_4">
                                <input type="checkbox" name="show_section_4" value="1" {{ isset($item->show_section_4) && $item->show_section_4 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_33">
                                <input class="form-control" type="text" name="section_4_conteudo_33" value="{{ $item->section_4_conteudo_33 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_34">
                                <input class="form-control" type="text" name="section_4_conteudo_34" value="{{ $item->section_4_conteudo_34 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_35">
                                <input class="form-control" type="text" name="section_4_conteudo_35" value="{{ $item->section_4_conteudo_35 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_36">
                                <input class="form-control" type="text" name="section_4_conteudo_36" value="{{ $item->section_4_conteudo_36 ?? '' }}" />
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Section 5</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_5">
                                <input type="checkbox" name="show_section_5" value="1" {{ isset($item->show_section_5) && $item->show_section_5 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                                    <div class="col-md-12 col-sm-12">
                                        <label class="col-form-label">Título</label>
                                        <input type="hidden" name="types[]" value="section_5_conteudo_37">
                                        <input class="form-control" type="text" name="section_5_conteudo_37" value="{{ $item->section_5_conteudo_37 ?? '' }}" />
                                    </div>
                                    <div class="col-md-12 col-sm-12">
                                        <label class="col-form-label">Título</label>
                                        <input type="hidden" name="types[]" value="section_5_conteudo_38">
                                        <input class="form-control" type="text" name="section_5_conteudo_38" value="{{ $item->section_5_conteudo_38 ?? '' }}" />
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>{{ translate("Image") }} </label>
                                            <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                                <div class="input-group-prepend">
                                                    <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                                </div>
                                                <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                                <input type="hidden" name="types[]" value="section_5_img_39">
                                                <input type="hidden" name="section_5_img_39" class="selected-files" value="{{ $item->section_5_img_39 ?? '' }}">
                                            </div>
                                            <div class="file-preview box"></div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-sm-12">
                                        <label class="col-form-label">Legenda</label>
                                        <input type="hidden" name="types[]" value="section_5_image_alt_39">
                                        <input class="form-control" type="text" name="section_5_image_alt_39" value="{{ $item->section_5_image_alt_39 ?? '' }}" />
                                    </div>
                                    <div class="col-md-12 col-sm-12">
                                        <label class="col-form-label">Título</label>
                                        <input type="hidden" name="types[]" value="section_5_conteudo_40">
                                        <input class="form-control" type="text" name="section_5_conteudo_40" value="{{ $item->section_5_conteudo_40 ?? '' }}" />
                                    </div>
                                    <div class="col-md-12 col-sm-12">
                                        <label class="col-form-label">Título</label>
                                        <input type="hidden" name="types[]" value="section_5_conteudo_41">
                                        <input class="form-control" type="text" name="section_5_conteudo_41" value="{{ $item->section_5_conteudo_41 ?? '' }}" />
                                    </div>
                                    <div class="col-md-12 col-sm-12">
                                        <label class="col-form-label">Título</label>
                                        <input type="hidden" name="types[]" value="section_5_conteudo_42">
                                        <input class="form-control" type="text" name="section_5_conteudo_42" value="{{ $item->section_5_conteudo_42 ?? '' }}" />
                                    </div>
                            <div class="form-group mb-0 text-right">
                                <button type="submit" class="btn btn-primary">
                                    {{ translate('Salvar') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Section 6</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_6">
                                <input type="checkbox" name="show_section_6" value="1" {{ isset($item->show_section_6) && $item->show_section_6 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_6_img_60">
                                        <input type="hidden" name="section_6_img_60" class="selected-files" value="{{ $item->section_6_img_60 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_6_conteudo_61">
                                <input class="form-control" type="text" name="section_6_conteudo_61" value="{{ $item->section_6_conteudo_61 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Texto do Botão</label>
                                <input type="hidden" name="types[]" value="section_6_link_conteudo_63">
                                <input class="form-control" type="text" name="section_6_link_conteudo_63" value="{{ $item->section_6_link_conteudo_63 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Link do Botão</label>
                                <input type="hidden" name="types[]" value="section_6_link_62">
                                <input class="form-control" type="text" name="section_6_link_62" value="{{ $item->section_6_link_62 ?? '' }}" />
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Section 8</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_8">
                                <input type="checkbox" name="show_section_8" value="1" {{ isset($item->show_section_8) && $item->show_section_8 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_8_img_88">
                                        <input type="hidden" name="section_8_img_88" class="selected-files" value="{{ $item->section_8_img_88 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_8_image_alt_88">
                                <input class="form-control" type="text" name="section_8_image_alt_88" value="{{ $item->section_8_image_alt_88 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_8_conteudo_89">
                                <input class="form-control" type="text" name="section_8_conteudo_89" value="{{ $item->section_8_conteudo_89 ?? '' }}" />
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Section 10</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_10">
                                <input type="checkbox" name="show_section_10" value="1" {{ isset($item->show_section_10) && $item->show_section_10 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_10_conteudo_93">
                                <input class="form-control" type="text" name="section_10_conteudo_93" value="{{ $item->section_10_conteudo_93 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_10_conteudo_94">
                                <input class="form-control" type="text" name="section_10_conteudo_94" value="{{ $item->section_10_conteudo_94 ?? '' }}" />
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Section 11</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_10">
                                <input type="checkbox" name="show_section_10" value="1" {{ isset($item->show_section_11) && $item->show_section_11 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_11_conteudo_96">
                                <input class="form-control" type="text" name="section_11_conteudo_96" value="{{ $item->section_11_conteudo_96 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_11_conteudo_97">
                                <input class="form-control" type="text" name="section_11_conteudo_97" value="{{ $item->section_11_conteudo_97 ?? '' }}" />
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Comentários</label>
                                    @php
                                        $indice = 0;
                                    @endphp
                                    <div class="parceiros-target">
                                        @if($item->parceiros != null && $item->parceiros != 'null')
                                            @foreach(json_decode($item->parceiros, true) as $key => $value)
                                                    <div class="card shadow-lg">
                                                        <div class="row card-body">
                                                            <div class="col-md-6">
                                                                <div class="form-group">
                                                                    <label>{{ translate('Image') }}</label>
                                                                    <div class="input-group" data-toggle="aizuploader" data-type="image">
                                                                        <div class="input-group-prepend">
                                                                            <div class="input-group-text bg-soft-secondary font-weight-medium">
                                                                                {{ translate('Browse') }}
                                                                            </div>
                                                                        </div>
                                                                        <div class="form-control file-amount">{{ translate('Choose File') }}</div>
                                                                        <input type="hidden" name="parceiros[{{ $key }}][imagem]" class="selected-files"
                                                                            value="{{ $value['imagem'] }}">
                                                                    </div>
                                                                    <div class="file-preview box"></div>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <div class="form-group">
                                                                    <label>Legenda</label>
                                                                    <input type="text" class="form-control" name="parceiros[{{ $key }}][legenda]"
                                                                        value="{{ $value['legenda'] }}">
                                                                </div>
                                                            </div>
                                                        <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                            <i class="las la-times"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                @php
                                                    $indice++;
                                                @endphp
                                            @endforeach
                                        @endif
                                    </div>
                                <button type="button" class="btn btn-soft-secondary btn-sm add-new-button add-new-button"
                                data-toggle="add-more"
                                data-content='
                                        <div class="card shadow-lg">
                                            <div class="row card-body">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label>{{ translate('Image') }}</label>
                                                            <div class="input-group" data-toggle="aizuploader" data-type="image">
                                                                <div class="input-group-prepend">
                                                                    <div class="input-group-text bg-soft-secondary font-weight-medium">
                                                                        {{ translate('Browse') }}
                                                                    </div>
                                                                </div>
                                                                <div class="form-control file-amount">{{ translate('Choose File') }}</div>
                                                                <input type="hidden" name="parceiros[][imagem]" class="selected-files">
                                                            </div>
                                                            <div class="file-preview box"></div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label>Legenda</label>
                                                            <input type="text" class="form-control" name="parceiros[][legenda]">
                                                        </div>
                                                    </div>
                                                <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                        <i class="las la-times"></i>
                                                </button>
                                            </div>
                                        </div>
                                        '
                                data-target=".parceiros-target" data-indice="{{ $indice }}">
                                {{ translate('Novo item') }}
                            </button>
                                </div>
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card shadow-lg">
                <div class="card-body">
                    <div class="form-group row">
                        <label class="col-md-3 col-form-label">{{ translate('Meta Title') }}</label>
                        <div class="col-md-9">
                            <input type="hidden" name="types[]" value="meta_title">
                            <input type="text" class="form-control" name="meta_title"
                                value="{{ $item->meta_title ?? '' }}"
                                placeholder="{{ translate('Meta Title') }}">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-md-3 col-form-label">{{ translate('Meta Description') }}</label>
                        <div class="col-md-9">
                            <input type="hidden" name="types[]" value="meta_description">
                            <textarea name="meta_description" rows="5" class="form-control">{{ $item->meta_description ?? '' }}</textarea>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-md-3 col-form-label">
                            {{ translate('Meta Keywords') }}
                        </label>
                        <div class="col-md-9">
                            <input type="hidden" name="types[]" value="meta_keywords">
                            <input type="text" class="form-control" id="meta_keywords"
                                name="meta_keywords" value="{{ $item->meta_keywords ?? '' }}"
                                placeholder="{{ translate('Meta Keywords') }}">
                        </div>
                    </div>
                    <div class="form-group mb-0 text-right">
                        <button type="submit" class="btn btn-primary">
                            {{ translate('Salvar') }}
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
@section('script')
<script>
    function makeSlug(val) {
        let output = val.replace(/\s+/g, "-").toLowerCase();
        $("#slug").val(output);
    }
    $(document).ready(function() {
        $(document).on("click", ".add-new-button", function() {
            $(".aiz-text-editor").each(function() {
                AIZ.plugins.textEditor($(this));
            });
        });
        AIZ.plugins.bootstrapSelect("refresh");
    });
</script>
@endsection

{{--<div class="col-md-12">
    <div class="form-group">
        <label>Comentários</label>
@php
            $indice = 0;
@endphp
        <div class="section_8_conteudo_61-target">
@if($item->section_8_conteudo_61 != null && $item->section_8_conteudo_61 != 'null')
@foreach(json_decode($item->section_8_conteudo_61, true) as $key => $value)
                    <div class="card shadow-lg">
                        <div class="row card-body">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate('Image') }}</label>
<div class="input-group" data-toggle="aizuploader" data-type="image">
    <div class="input-group-prepend">
        <div class="input-group-text bg-soft-secondary font-weight-medium">
            {{ translate('Browse') }}
        </div>
    </div>
    <div class="form-control file-amount">{{ translate('Choose File') }}</div>
    <input type="hidden" name="logos[{{ $key }}][imagem]" class="selected-files"
        value="{{ $value['imagem'] }}">
</div>
<div class="file-preview box"></div>
</div>
</div>
<div class="col-md-6">
    <div class="form-group">
        <label>Legenda</label>
        <input type="text" class="form-control" name="logos[{{ $key }}][legenda]"
            value="{{ $value['legenda'] }}">
    </div>
</div>
<div class="col-md-12">
    <div class="form-group">
        <label>Título</label>
        <input type="text" class="form-control" name="logos[{{ $key }}][titulo]"
            value="{{ $value['titulo'] }}">
    </div>
</div>
<div class="col-md-12">
    <div class="form-group">
        <label>Texto corrido</label>
        <textarea name="logos[{{ $key }}][corrido]" class="form-control" data-min-height="300" cols="30" rows="5">{{ $value['corrido'] }}</textarea>
    </div>
</div>
<button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
    <i class="las la-times"></i>
</button>
</div>
</div>
@php
$indice++;
@endphp
@endforeach
@endif
</div>
<button type="button" class="btn btn-soft-secondary btn-sm add-new-button add-new-button"
    data-toggle="add-more"
    data-content='
            <div class="card shadow-lg">
                <div class="row card-body">
                        <div class="col-md-6">
                <div class="form-group">
                    <label>{{ translate('Image') }}</label>
                    <div class="input-group" data-toggle="aizuploader" data-type="image">
                        <div class="input-group-prepend">
                            <div class="input-group-text bg-soft-secondary font-weight-medium">
                                {{ translate('Browse') }}</div>
                        </div>
                        <div class="form-control file-amount">{{ translate('Choose File') }}</div>
                        <input type="hidden" name="logos[][imagem]" class="selected-files">
                    </div>
                    <div class="file-preview box"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>Legenda</label>
                    <input type="text" class="form-control" name="logos[][legenda]">
                </div>
            </div>
            <div class="col-md-12">
                <div class="form-group">
                    <label>Título</label>
                    <input type="text" class="form-control" name="logos[][titulo]">
                </div>
            </div>
            <div class="col-md-12">
                <div class="form-group">
                    <label>Texto corrido</label>
                    <textarea name="logos[][corrido]" class="form-control" data-min-height="300" cols="30" rows="5"></textarea>
                </div>
            </div>
                    <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                            <i class="las la-times"></i>
                    </button>
                </div>
            </div>
            '
    data-target=".section_8_conteudo_61-target" data-indice="{{ $indice }}">
    {{ translate('Add New') }}
</button>
</div>
</div> --}}