@extends("backend.layouts.app")
@section("content")
<div class="row">
    <div class="col-lg-10 mx-auto">
        <form id="add_form" class="form-horizontal" action="{{ route('homeall.update') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="form-body">
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Seção 1</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_1">
                                <input type="checkbox" name="show_section_1" value="1" {{ isset ($item->show_section_1) && $item->show_section_1 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_1_conteudo_1">
                                <input class="form-control" type="text" name="section_1_conteudo_1" value="{{ $item->section_1_conteudo_1 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Texto corrido</label>
                                <input type="hidden" name="types[]" value="section_1_textarea_2">
                                <textarea name="section_1_textarea_2" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_1_textarea_2 ?? '' }}</textarea>
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Texto do Botão</label>
                                <input type="hidden" name="types[]" value="section_1_link_conteudo_3">
                                <input class="form-control" type="text" name="section_1_link_conteudo_3" value="{{ $item->section_1_link_conteudo_3 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Link do Botão</label>
                                <input type="hidden" name="types[]" value="section_1_link_3">
                                <input class="form-control" type="text" name="section_1_link_3" value="{{ $item->section_1_link_3 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Legenda SEO</label>
                                <input type="hidden" name="types[]" value="section_1_link_alt_3">
                                <input class="form-control" type="text" name="section_1_link_alt_3" value="{{ $item->section_1_link_alt_3 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_1_img_4">
                                        <input type="hidden" name="section_1_img_4" class="selected-files" value="{{ $item->section_1_img_4 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_1_image_alt_4">
                                <input class="form-control" type="text" name="section_1_image_alt_4" value="{{ $item->section_1_image_alt_4 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_1_conteudo_5">
                                <input class="form-control" type="text" name="section_1_conteudo_5" value="{{ $item->section_1_conteudo_5 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_1_img_6">
                                        <input type="hidden" name="section_1_img_6" class="selected-files" value="{{ $item->section_1_img_6 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_1_image_alt_6">
                                <input class="form-control" type="text" name="section_1_image_alt_6" value="{{ $item->section_1_image_alt_6 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_1_conteudo_7">
                                <input class="form-control" type="text" name="section_1_conteudo_7" value="{{ $item->section_1_conteudo_7 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_1_conteudo_8">
                                <input class="form-control" type="text" name="section_1_conteudo_8" value="{{ $item->section_1_conteudo_8 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_1_conteudo_9">
                                <input class="form-control" type="text" name="section_1_conteudo_9" value="{{ $item->section_1_conteudo_9 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_1_img_10">
                                        <input type="hidden" name="section_1_img_10" class="selected-files" value="{{ $item->section_1_img_10 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_1_image_alt_10">
                                <input class="form-control" type="text" name="section_1_image_alt_10" value="{{ $item->section_1_image_alt_10 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Texto do Botão</label>
                                <input type="hidden" name="types[]" value="section_1_link_conteudo_11">
                                <input class="form-control" type="text" name="section_1_link_conteudo_11" value="{{ $item->section_1_link_conteudo_11 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Link do Botão</label>
                                <input type="hidden" name="types[]" value="section_1_link_11">
                                <input class="form-control" type="text" name="section_1_link_11" value="{{ $item->section_1_link_11 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Legenda SEO</label>
                                <input type="hidden" name="types[]" value="section_1_link_alt_11">
                                <input class="form-control" type="text" name="section_1_link_alt_11" value="{{ $item->section_1_link_alt_11 ?? '' }}" />
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Seção 2</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_2">
                                <input type="checkbox" name="show_section_2" value="1" {{ isset ($item->show_section_2) && $item->show_section_2 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>{{ translate("Image") }} </label>
                                <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                    </div>
                                    <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                    <input type="hidden" name="types[]" value="section_2_img_10">
                                    <input type="hidden" name="section_2_img_10" class="selected-files" value="{{ $item->section_2_img_10 ?? '' }}">
                                </div>
                                <div class="file-preview box"></div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="col-form-label">Comentários</label>
                                @php
                                $indice = 0;
                                @endphp
                                <input type="hidden" name="types[]" value="coment">
                                <div class="coment-target">
                                    @if(isset($item->coment) && $item->coment != null && $item->coment != 'null')
                                    @foreach(json_decode($item->coment, true) as $key => $value)
                                    <div class="card shadow-lg">
                                        <div class="row card-body">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="col-form-label">Título</label>
                                                    <input type="text" class="form-control" name="coment[{{ $key }}][titulo]"
                                                        value="{{ $value['titulo'] }}">
                                                </div>
                                            </div>
                                            <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                <i class="las la-times"></i>
                                            </button>
                                        </div>
                                    </div>
                                    @php
                                    $indice++;
                                    @endphp
                                    @endforeach
                                    @endif
                                </div>
                                <button type="button" class="btn btn-soft-secondary btn-sm add-new-button add-new-button"
                                    data-toggle="add-more"
                                    data-content='
                                        <div class="card shadow-lg">
                                            <div class="row card-body">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label class="col-form-label">Título</label>
                                                        <input type="text" class="form-control" name="coment[][titulo]">
                                                    </div>
                                                </div>
                                                <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                        <i class="las la-times"></i>
                                                </button>
                                            </div>
                                        </div>
                                        '
                                    data-target=".coment-target" data-indice="{{ $indice }}">
                                    {{ translate('Add New') }}
                                </button>
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Seção 3</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_3">
                                <input type="checkbox" name="show_section_3" value="1" {{ isset ($item->show_section_3) && $item->show_section_3 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_3_img_13">
                                        <input type="hidden" name="section_3_img_13" class="selected-files" value="{{ $item->section_3_img_13 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_3_image_alt_13">
                                <input class="form-control" type="text" name="section_3_image_alt_13" value="{{ $item->section_3_image_alt_13 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_3_conteudo_14">
                                <input class="form-control" type="text" name="section_3_conteudo_14" value="{{ $item->section_3_conteudo_14 ?? '' }}" />
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Ícones</label>
                                    @php
                                    $indice = 0;
                                    @endphp
                                    <input type="hidden" name="types[]" value="icons">
                                    <div class="icons-target">
                                        @if(isset($item->icons) && $item->icons != null && $item->icons != 'null')
                                        @foreach(json_decode($item->icons, true) as $key => $value)
                                        <div class="card shadow-lg">
                                            <div class="row card-body">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>{{ translate("Image") }} </label>
                                                        <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                                            <div class="input-group-prepend">
                                                                <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                                            </div>
                                                            <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                                            <input type="hidden" name="icons[{{ $key }}][imagem]" class="selected-files" value="{{ $value['imagem'] }}">
                                                        </div>
                                                        <div class="file-preview box"></div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-sm-12">
                                                    <label class="col-form-label">Legenda</label>
                                                    <input class="form-control" type="text" name="icons[{{ $key }}][legenda]" value="{{ $value['legenda'] }}" />
                                                </div>
                                                <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                    <i class="las la-times"></i>
                                                </button>
                                            </div>
                                        </div>
                                        @php
                                        $indice++;
                                        @endphp
                                        @endforeach
                                        @endif
                                    </div>
                                    <button type="button" class="btn btn-soft-secondary btn-sm add-new-button add-new-button"
                                        data-toggle="add-more"
                                        data-content='
                                            <div class="card shadow-lg">
                                                <div class="row card-body">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label>{{ translate("Image") }} </label>
                                                            <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                                                <div class="input-group-prepend">
                                                                    <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                                                </div>
                                                                <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                                                <input type="hidden" name="icons[][imagem]" class="selected-files">
                                                            </div>
                                                            <div class="file-preview box"></div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 col-sm-12">
                                                        <label class="col-form-label">Legenda</label>
                                                        <input class="form-control" type="text" name="icons[][legenda]" />
                                                    </div>
                                                    <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                            <i class="las la-times"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            '
                                        data-target=".icons-target" data-indice="{{ $indice }}">
                                        Adicionar
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Seção 4</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_4">
                                <input type="checkbox" name="show_section_4" value="1" {{ isset ($item->show_section_4) && $item->show_section_4 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_4_img_15">
                                        <input type="hidden" name="section_4_img_15" class="selected-files" value="{{ $item->section_4_img_15 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_4_image_alt_15">
                                <input class="form-control" type="text" name="section_4_image_alt_15" value="{{ $item->section_4_image_alt_15 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_16">
                                <input class="form-control" type="text" name="section_4_conteudo_16" value="{{ $item->section_4_conteudo_16 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_17">
                                <input class="form-control" type="text" name="section_4_conteudo_17" value="{{ $item->section_4_conteudo_17 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Texto corrido</label>
                                <input type="hidden" name="types[]" value="section_4_textarea_18">
                                <textarea name="section_4_textarea_18" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_4_textarea_18 ?? '' }}</textarea>
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_19">
                                <input class="form-control" type="text" name="section_4_conteudo_19" value="{{ $item->section_4_conteudo_19 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Texto corrido</label>
                                <input type="hidden" name="types[]" value="section_4_textarea_20">
                                <textarea name="section_4_textarea_20" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_4_textarea_20 ?? '' }}</textarea>
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_21">
                                <input class="form-control" type="text" name="section_4_conteudo_21" value="{{ $item->section_4_conteudo_21 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Texto corrido</label>
                                <input type="hidden" name="types[]" value="section_4_textarea_22">
                                <textarea name="section_4_textarea_22" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_4_textarea_22 ?? '' }}</textarea>
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_23">
                                <input class="form-control" type="text" name="section_4_conteudo_23" value="{{ $item->section_4_conteudo_23 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Texto corrido</label>
                                <input type="hidden" name="types[]" value="section_4_textarea_24">
                                <textarea name="section_4_textarea_24" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_4_textarea_24 ?? '' }}</textarea>
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Texto do Botão</label>
                                <input type="hidden" name="types[]" value="section_4_link_conteudo_25">
                                <input class="form-control" type="text" name="section_4_link_conteudo_25" value="{{ $item->section_4_link_conteudo_25 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Link do Botão</label>
                                <input type="hidden" name="types[]" value="section_4_link_25">
                                <input class="form-control" type="text" name="section_4_link_25" value="{{ $item->section_4_link_25 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Legenda SEO</label>
                                <input type="hidden" name="types[]" value="section_4_link_alt_25">
                                <input class="form-control" type="text" name="section_4_link_alt_25" value="{{ $item->section_4_link_alt_25 ?? '' }}" />
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Seção 5</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_5">
                                <input type="checkbox" name="show_section_5" value="1" {{ isset ($item->show_section_5) && $item->show_section_5 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_5_img_26">
                                        <input type="hidden" name="section_5_img_26" class="selected-files" value="{{ $item->section_5_img_26 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_5_image_alt_26">
                                <input class="form-control" type="text" name="section_5_image_alt_26" value="{{ $item->section_5_image_alt_26 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_5_conteudo_27">
                                <input class="form-control" type="text" name="section_5_conteudo_27" value="{{ $item->section_5_conteudo_27 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_5_conteudo_28">
                                <input class="form-control" type="text" name="section_5_conteudo_28" value="{{ $item->section_5_conteudo_28 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_5_conteudo_29">
                                <input class="form-control" type="text" name="section_5_conteudo_29" value="{{ $item->section_5_conteudo_29 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_5_conteudo_30">
                                <input class="form-control" type="text" name="section_5_conteudo_30" value="{{ $item->section_5_conteudo_30 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_5_conteudo_31">
                                <input class="form-control" type="text" name="section_5_conteudo_31" value="{{ $item->section_5_conteudo_31 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Texto do Botão</label>
                                <input type="hidden" name="types[]" value="section_5_link_conteudo_32">
                                <input class="form-control" type="text" name="section_5_link_conteudo_32" value="{{ $item->section_5_link_conteudo_32 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Link do Botão</label>
                                <input type="hidden" name="types[]" value="section_5_link_32">
                                <input class="form-control" type="text" name="section_5_link_32" value="{{ $item->section_5_link_32 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Legenda SEO</label>
                                <input type="hidden" name="types[]" value="section_5_link_alt_32">
                                <input class="form-control" type="text" name="section_5_link_alt_32" value="{{ $item->section_5_link_alt_32 ?? '' }}" />
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Seção 6</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_6">
                                <input type="checkbox" name="show_section_6" value="1" {{ isset ($item->show_section_6) && $item->show_section_6 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_6_conteudo_33">
                                <input class="form-control" type="text" name="section_6_conteudo_33" value="{{ $item->section_6_conteudo_33 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Texto corrido</label>
                                <input type="hidden" name="types[]" value="section_6_textarea_34">
                                <textarea name="section_6_textarea_34" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_6_textarea_34 ?? '' }}</textarea>
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Texto do Botão</label>
                                <input type="hidden" name="types[]" value="section_6_link_conteudo_35">
                                <input class="form-control" type="text" name="section_6_link_conteudo_35" value="{{ $item->section_6_link_conteudo_35 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Link do Botão</label>
                                <input type="hidden" name="types[]" value="section_6_link_35">
                                <input class="form-control" type="text" name="section_6_link_35" value="{{ $item->section_6_link_35 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Legenda SEO</label>
                                <input type="hidden" name="types[]" value="section_6_link_alt_35">
                                <input class="form-control" type="text" name="section_6_link_alt_35" value="{{ $item->section_6_link_alt_35 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Texto do Botão</label>
                                <input type="hidden" name="types[]" value="section_6_link_conteudo_36">
                                <input class="form-control" type="text" name="section_6_link_conteudo_36" value="{{ $item->section_6_link_conteudo_36 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Link do Botão</label>
                                <input type="hidden" name="types[]" value="section_6_link_36">
                                <input class="form-control" type="text" name="section_6_link_36" value="{{ $item->section_6_link_36 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Legenda SEO</label>
                                <input type="hidden" name="types[]" value="section_6_link_alt_36">
                                <input class="form-control" type="text" name="section_6_link_alt_36" value="{{ $item->section_6_link_alt_36 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_6_img_37">
                                        <input type="hidden" name="section_6_img_37" class="selected-files" value="{{ $item->section_6_img_37 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_6_image_alt_37">
                                <input class="form-control" type="text" name="section_6_image_alt_37" value="{{ $item->section_6_image_alt_37 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_6_conteudo_38">
                                <input class="form-control" type="text" name="section_6_conteudo_38" value="{{ $item->section_6_conteudo_38 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_6_img_39">
                                        <input type="hidden" name="section_6_img_39" class="selected-files" value="{{ $item->section_6_img_39 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_6_image_alt_39">
                                <input class="form-control" type="text" name="section_6_image_alt_39" value="{{ $item->section_6_image_alt_39 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_6_conteudo_40">
                                <input class="form-control" type="text" name="section_6_conteudo_40" value="{{ $item->section_6_conteudo_40 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_6_conteudo_41">
                                <input class="form-control" type="text" name="section_6_conteudo_41" value="{{ $item->section_6_conteudo_41 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_6_conteudo_42">
                                <input class="form-control" type="text" name="section_6_conteudo_42" value="{{ $item->section_6_conteudo_42 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_6_conteudo_43">
                                <input class="form-control" type="text" name="section_6_conteudo_43" value="{{ $item->section_6_conteudo_43 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_6_img_44">
                                        <input type="hidden" name="section_6_img_44" class="selected-files" value="{{ $item->section_6_img_44 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_6_image_alt_44">
                                <input class="form-control" type="text" name="section_6_image_alt_44" value="{{ $item->section_6_image_alt_44 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_6_img_45">
                                        <input type="hidden" name="section_6_img_45" class="selected-files" value="{{ $item->section_6_img_45 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_6_image_alt_45">
                                <input class="form-control" type="text" name="section_6_image_alt_45" value="{{ $item->section_6_image_alt_45 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_6_conteudo_46">
                                <input class="form-control" type="text" name="section_6_conteudo_46" value="{{ $item->section_6_conteudo_46 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_6_img_47">
                                        <input type="hidden" name="section_6_img_47" class="selected-files" value="{{ $item->section_6_img_47 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_6_image_alt_47">
                                <input class="form-control" type="text" name="section_6_image_alt_47" value="{{ $item->section_6_image_alt_47 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_6_img_48">
                                        <input type="hidden" name="section_6_img_48" class="selected-files" value="{{ $item->section_6_img_48 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_6_image_alt_48">
                                <input class="form-control" type="text" name="section_6_image_alt_48" value="{{ $item->section_6_image_alt_48 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_6_img_49">
                                        <input type="hidden" name="section_6_img_49" class="selected-files" value="{{ $item->section_6_img_49 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_6_image_alt_49">
                                <input class="form-control" type="text" name="section_6_image_alt_49" value="{{ $item->section_6_image_alt_49 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_6_conteudo_50">
                                <input class="form-control" type="text" name="section_6_conteudo_50" value="{{ $item->section_6_conteudo_50 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_6_img_51">
                                        <input type="hidden" name="section_6_img_51" class="selected-files" value="{{ $item->section_6_img_51 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_6_image_alt_51">
                                <input class="form-control" type="text" name="section_6_image_alt_51" value="{{ $item->section_6_image_alt_51 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_6_img_52">
                                        <input type="hidden" name="section_6_img_52" class="selected-files" value="{{ $item->section_6_img_52 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_6_image_alt_52">
                                <input class="form-control" type="text" name="section_6_image_alt_52" value="{{ $item->section_6_image_alt_52 ?? '' }}" />
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Seção 7</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_7">
                                <input type="checkbox" name="show_section_7" value="1" {{ isset ($item->show_section_7) && $item->show_section_7 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_7_conteudo_53">
                                <input class="form-control" type="text" name="section_7_conteudo_53" value="{{ $item->section_7_conteudo_53 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_7_conteudo_54">
                                <input class="form-control" type="text" name="section_7_conteudo_54" value="{{ $item->section_7_conteudo_54 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Texto do Botão</label>
                                <input type="hidden" name="types[]" value="section_7_link_conteudo_55">
                                <input class="form-control" type="text" name="section_7_link_conteudo_55" value="{{ $item->section_7_link_conteudo_55 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Link do Botão</label>
                                <input type="hidden" name="types[]" value="section_7_link_55">
                                <input class="form-control" type="text" name="section_7_link_55" value="{{ $item->section_7_link_55 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Legenda SEO</label>
                                <input type="hidden" name="types[]" value="section_7_link_alt_55">
                                <input class="form-control" type="text" name="section_7_link_alt_55" value="{{ $item->section_7_link_alt_55 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_7_img_56">
                                        <input type="hidden" name="section_7_img_56" class="selected-files" value="{{ $item->section_7_img_56 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_7_image_alt_56">
                                <input class="form-control" type="text" name="section_7_image_alt_56" value="{{ $item->section_7_image_alt_56 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_7_conteudo_57">
                                <input class="form-control" type="text" name="section_7_conteudo_57" value="{{ $item->section_7_conteudo_57 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Texto corrido</label>
                                <input type="hidden" name="types[]" value="section_7_textarea_58">
                                <textarea name="section_7_textarea_58" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_7_textarea_58 ?? '' }}</textarea>
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Link do Botão</label>
                                <input type="hidden" name="types[]" value="section_7_link_59">
                                <input class="form-control" type="text" name="section_7_link_59" value="{{ $item->section_7_link_59 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Legenda SEO</label>
                                <input type="hidden" name="types[]" value="section_7_link_alt_59">
                                <input class="form-control" type="text" name="section_7_link_alt_59" value="{{ $item->section_7_link_alt_59 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_7_img_60">
                                        <input type="hidden" name="section_7_img_60" class="selected-files" value="{{ $item->section_7_img_60 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_7_image_alt_60">
                                <input class="form-control" type="text" name="section_7_image_alt_60" value="{{ $item->section_7_image_alt_60 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_7_conteudo_61">
                                <input class="form-control" type="text" name="section_7_conteudo_61" value="{{ $item->section_7_conteudo_61 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Texto corrido</label>
                                <input type="hidden" name="types[]" value="section_7_textarea_62">
                                <textarea name="section_7_textarea_62" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_7_textarea_62 ?? '' }}</textarea>
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Link do Botão</label>
                                <input type="hidden" name="types[]" value="section_7_link_63">
                                <input class="form-control" type="text" name="section_7_link_63" value="{{ $item->section_7_link_63 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Legenda SEO</label>
                                <input type="hidden" name="types[]" value="section_7_link_alt_63">
                                <input class="form-control" type="text" name="section_7_link_alt_63" value="{{ $item->section_7_link_alt_63 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_7_img_64">
                                        <input type="hidden" name="section_7_img_64" class="selected-files" value="{{ $item->section_7_img_64 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_7_image_alt_64">
                                <input class="form-control" type="text" name="section_7_image_alt_64" value="{{ $item->section_7_image_alt_64 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_7_conteudo_65">
                                <input class="form-control" type="text" name="section_7_conteudo_65" value="{{ $item->section_7_conteudo_65 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_7_conteudo_66">
                                <input class="form-control" type="text" name="section_7_conteudo_66" value="{{ $item->section_7_conteudo_66 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_7_conteudo_67">
                                <input class="form-control" type="text" name="section_7_conteudo_67" value="{{ $item->section_7_conteudo_67 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_7_conteudo_68">
                                <input class="form-control" type="text" name="section_7_conteudo_68" value="{{ $item->section_7_conteudo_68 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Link do Botão</label>
                                <input type="hidden" name="types[]" value="section_7_link_69">
                                <input class="form-control" type="text" name="section_7_link_69" value="{{ $item->section_7_link_69 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Legenda SEO</label>
                                <input type="hidden" name="types[]" value="section_7_link_alt_69">
                                <input class="form-control" type="text" name="section_7_link_alt_69" value="{{ $item->section_7_link_alt_69 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_7_img_70">
                                        <input type="hidden" name="section_7_img_70" class="selected-files" value="{{ $item->section_7_img_70 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_7_image_alt_70">
                                <input class="form-control" type="text" name="section_7_image_alt_70" value="{{ $item->section_7_image_alt_70 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_7_img_71">
                                        <input type="hidden" name="section_7_img_71" class="selected-files" value="{{ $item->section_7_img_71 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_7_image_alt_71">
                                <input class="form-control" type="text" name="section_7_image_alt_71" value="{{ $item->section_7_image_alt_71 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_7_conteudo_72">
                                <input class="form-control" type="text" name="section_7_conteudo_72" value="{{ $item->section_7_conteudo_72 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Link do Botão</label>
                                <input type="hidden" name="types[]" value="section_7_link_73">
                                <input class="form-control" type="text" name="section_7_link_73" value="{{ $item->section_7_link_73 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Legenda SEO</label>
                                <input type="hidden" name="types[]" value="section_7_link_alt_73">
                                <input class="form-control" type="text" name="section_7_link_alt_73" value="{{ $item->section_7_link_alt_73 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_7_img_74">
                                        <input type="hidden" name="section_7_img_74" class="selected-files" value="{{ $item->section_7_img_74 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_7_image_alt_74">
                                <input class="form-control" type="text" name="section_7_image_alt_74" value="{{ $item->section_7_image_alt_74 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_7_conteudo_75">
                                <input class="form-control" type="text" name="section_7_conteudo_75" value="{{ $item->section_7_conteudo_75 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Texto corrido</label>
                                <input type="hidden" name="types[]" value="section_7_textarea_76">
                                <textarea name="section_7_textarea_76" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_7_textarea_76 ?? '' }}</textarea>
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Link do Botão</label>
                                <input type="hidden" name="types[]" value="section_7_link_77">
                                <input class="form-control" type="text" name="section_7_link_77" value="{{ $item->section_7_link_77 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Legenda SEO</label>
                                <input type="hidden" name="types[]" value="section_7_link_alt_77">
                                <input class="form-control" type="text" name="section_7_link_alt_77" value="{{ $item->section_7_link_alt_77 ?? '' }}" />
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Seção 8</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_8">
                                <input type="checkbox" name="show_section_8" value="1" {{ isset ($item->show_section_8) && $item->show_section_8 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_8_conteudo_78">
                                <input class="form-control" type="text" name="section_8_conteudo_78" value="{{ $item->section_8_conteudo_78 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_8_conteudo_79">
                                <input class="form-control" type="text" name="section_8_conteudo_79" value="{{ $item->section_8_conteudo_79 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Texto do Botão</label>
                                <input type="hidden" name="types[]" value="section_8_link_conteudo_80">
                                <input class="form-control" type="text" name="section_8_link_conteudo_80" value="{{ $item->section_8_link_conteudo_80 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Link do Botão</label>
                                <input type="hidden" name="types[]" value="section_8_link_80">
                                <input class="form-control" type="text" name="section_8_link_80" value="{{ $item->section_8_link_80 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Legenda SEO</label>
                                <input type="hidden" name="types[]" value="section_8_link_alt_80">
                                <input class="form-control" type="text" name="section_8_link_alt_80" value="{{ $item->section_8_link_alt_80 ?? '' }}" />
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="col-form-label">Faq</label>
                                    @php
                                    $indice = 0;
                                    @endphp
                                    <input type="hidden" name="types[]" value="faq">
                                    <div class="faq-target">
                                        @if(isset($item->faq) && $item->faq != null && $item->faq != 'null')
                                        @foreach(json_decode($item->faq, true) as $key => $value)
                                        <div class="card shadow-lg">
                                            <div class="row card-body">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label class="col-form-label">Título</label>
                                                        <input type="text" class="form-control" name="faq[{{ $key }}][titulo]"
                                                            value="{{ $value['titulo'] }}">
                                                    </div>
                                                </div>
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label class="col-form-label">Texto corrido</label>
                                                        <textarea name="faq[{{ $key }}][corrido]" class="form-control" data-min-height="300" cols="30" rows="5">{{ $value['corrido'] }}</textarea>
                                                    </div>
                                                </div>
                                                <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                    <i class="las la-times"></i>
                                                </button>
                                            </div>
                                        </div>
                                        @php
                                        $indice++;
                                        @endphp
                                        @endforeach
                                        @endif
                                    </div>
                                    <button type="button" class="btn btn-soft-secondary btn-sm add-new-button add-new-button"
                                        data-toggle="add-more"
                                        data-content='
                                            <div class="card shadow-lg">
                                                <div class="row card-body">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label class="col-form-label">Título</label>
                                                            <input type="text" class="form-control" name="faq[][titulo]">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label class="col-form-label">Texto corrido</label>
                                                            <textarea name="faq[][corrido]" class="form-control" data-min-height="300" cols="30" rows="5"></textarea>
                                                        </div>
                                                    </div>
                                                    <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                            <i class="las la-times"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            '
                                        data-target=".faq-target" data-indice="{{ $indice }}">
                                        Adicionar
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Seção 9</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_9">
                                <input type="checkbox" name="show_section_9" value="1" {{ isset ($item->show_section_9) && $item->show_section_9 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_9_conteudo_81">
                                <input class="form-control" type="text" name="section_9_conteudo_81" value="{{ $item->section_9_conteudo_81 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_9_conteudo_82">
                                <input class="form-control" type="text" name="section_9_conteudo_82" value="{{ $item->section_9_conteudo_82 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Texto do Botão</label>
                                <input type="hidden" name="types[]" value="section_9_link_conteudo_83">
                                <input class="form-control" type="text" name="section_9_link_conteudo_83" value="{{ $item->section_9_link_conteudo_83 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Link do Botão</label>
                                <input type="hidden" name="types[]" value="section_9_link_83">
                                <input class="form-control" type="text" name="section_9_link_83" value="{{ $item->section_9_link_83 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Legenda SEO</label>
                                <input type="hidden" name="types[]" value="section_9_link_alt_83">
                                <input class="form-control" type="text" name="section_9_link_alt_83" value="{{ $item->section_9_link_alt_83 ?? '' }}" />
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Seção 10</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_10">
                                <input type="checkbox" name="show_section_10" value="1" {{ isset ($item->show_section_10) && $item->show_section_10 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_10_img_84">
                                        <input type="hidden" name="section_10_img_84" class="selected-files" value="{{ $item->section_10_img_84 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_10_image_alt_84">
                                <input class="form-control" type="text" name="section_10_image_alt_84" value="{{ $item->section_10_image_alt_84 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_10_conteudo_85">
                                <input class="form-control" type="text" name="section_10_conteudo_85" value="{{ $item->section_10_conteudo_85 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Texto do Botão</label>
                                <input type="hidden" name="types[]" value="section_10_link_conteudo_86">
                                <input class="form-control" type="text" name="section_10_link_conteudo_86" value="{{ $item->section_10_link_conteudo_86 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Link do Botão</label>
                                <input type="hidden" name="types[]" value="section_10_link_86">
                                <input class="form-control" type="text" name="section_10_link_86" value="{{ $item->section_10_link_86 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Legenda SEO</label>
                                <input type="hidden" name="types[]" value="section_10_link_alt_86">
                                <input class="form-control" type="text" name="section_10_link_alt_86" value="{{ $item->section_10_link_alt_86 ?? '' }}" />
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card shadow-lg">
                <div class="card-body">
                    <div class="form-group row">
                        <label class="col-md-3 col-form-label">{{ translate('Meta Title') }}</label>
                        <div class="col-md-9">
                            <input type="hidden" name="types[]" value="meta_title">
                            <input type="text" class="form-control" name="meta_title"
                                value="{{ $item->meta_title ?? '' }}"
                                placeholder="{{ translate('Meta Title') }}">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-md-3 col-form-label">{{ translate('Meta Description') }}</label>
                        <div class="col-md-9">
                            <input type="hidden" name="types[]" value="meta_description">
                            <textarea name="meta_description" rows="5" class="form-control">{{ $item->meta_description ?? '' }}</textarea>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-md-3 col-form-label">
                            {{ translate('Meta Keywords') }}
                        </label>
                        <div class="col-md-9">
                            <input type="hidden" name="types[]" value="meta_keywords">
                            <input type="text" class="form-control" id="meta_keywords"
                                name="meta_keywords" value="{{ $item->meta_keywords ?? '' }}"
                                placeholder="{{ translate('Meta Keywords') }}">
                        </div>
                    </div>
                    <div class="form-group mb-0 text-right">
                        <button type="submit" class="btn btn-primary">
                            {{ translate('Salvar') }}
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
@section('script')
<script>
    function makeSlug(val) {
        let output = val.replace(/\s+/g, "-").toLowerCase();
        $("#slug").val(output);
    }
    $(document).ready(function() {
        $(document).on("click", ".add-new-button", function() {
            $(".aiz-text-editor").each(function() {
                AIZ.plugins.textEditor($(this));
            });
        });
        AIZ.plugins.bootstrapSelect("refresh");
    });
</script>
@endsection

{{--<div class="col-md-12">
    <div class="form-group">
        <label>Comentários</label>
@php
            $indice = 0;
@endphp
        <div class="section_8_conteudo_61-target">
@if($item->section_8_conteudo_61 != null && $item->section_8_conteudo_61 != 'null')
@foreach(json_decode($item->section_8_conteudo_61, true) as $key => $value)
                    <div class="card shadow-lg">
                        <div class="row card-body">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate('Image') }}</label>
<div class="input-group" data-toggle="aizuploader" data-type="image">
    <div class="input-group-prepend">
        <div class="input-group-text bg-soft-secondary font-weight-medium">
            {{ translate('Browse') }}
        </div>
    </div>
    <div class="form-control file-amount">{{ translate('Choose File') }}</div>
    <input type="hidden" name="logos[{{ $key }}][imagem]" class="selected-files"
        value="{{ $value['imagem'] }}">
</div>
<div class="file-preview box"></div>
</div>
</div>
<div class="col-md-6">
    <div class="form-group">
        <label>Legenda</label>
        <input type="text" class="form-control" name="logos[{{ $key }}][legenda]"
            value="{{ $value['legenda'] }}">
    </div>
</div>
<div class="col-md-12">
    <div class="form-group">
        <label>Título</label>
        <input type="text" class="form-control" name="logos[{{ $key }}][titulo]"
            value="{{ $value['titulo'] }}">
    </div>
</div>
<div class="col-md-12">
    <div class="form-group">
        <label>Texto corrido</label>
        <textarea name="logos[{{ $key }}][corrido]" class="form-control" data-min-height="300" cols="30" rows="5">{{ $value['corrido'] }}</textarea>
    </div>
</div>
<button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
    <i class="las la-times"></i>
</button>
</div>
</div>
@php
$indice++;
@endphp
@endforeach
@endif
</div>
<button type="button" class="btn btn-soft-secondary btn-sm add-new-button add-new-button"
    data-toggle="add-more"
    data-content='
            <div class="card shadow-lg">
                <div class="row card-body">
                        <div class="col-md-6">
                <div class="form-group">
                    <label>{{ translate('Image') }}</label>
                    <div class="input-group" data-toggle="aizuploader" data-type="image">
                        <div class="input-group-prepend">
                            <div class="input-group-text bg-soft-secondary font-weight-medium">
                                {{ translate('Browse') }}</div>
                        </div>
                        <div class="form-control file-amount">{{ translate('Choose File') }}</div>
                        <input type="hidden" name="logos[][imagem]" class="selected-files">
                    </div>
                    <div class="file-preview box"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>Legenda</label>
                    <input type="text" class="form-control" name="logos[][legenda]">
                </div>
            </div>
            <div class="col-md-12">
                <div class="form-group">
                    <label>Título</label>
                    <input type="text" class="form-control" name="logos[][titulo]">
                </div>
            </div>
            <div class="col-md-12">
                <div class="form-group">
                    <label>Texto corrido</label>
                    <textarea name="logos[][corrido]" class="form-control" data-min-height="300" cols="30" rows="5"></textarea>
                </div>
            </div>
                    <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                            <i class="las la-times"></i>
                    </button>
                </div>
            </div>
            '
    data-target=".section_8_conteudo_61-target" data-indice="{{ $indice }}">
    {{ translate('Add New') }}
</button>
</div>
</div> --}}