@extends("backend.layouts.app")
@section("content")
<div class="row">
  <div class="col-lg-10 mx-auto">
    <form id="add_form" class="form-horizontal" action="{{ route('sobreall.update') }}" method="POST" enctype="multipart/form-data">
      @csrf
      <div class="form-body">
        <div class="card shadow-lg">
          <div class="card-header d-flex justify-content-between">
            <h4 class="card-title">Section Banner</h4>
            <div class="d-flex align-items-center">
              <label class="mr-2">Mostrar seção?</label>
              <label class="aiz-switch aiz-switch-success mb-0">
                <input type="hidden" name="types[]" value="show_section_banner">
                <input type="checkbox" name="show_section_banner" value="1" {{ isset ($item->show_section_banner) && $item->show_section_banner == '1' ? 'checked' : '' }}>
                <span></span>
              </label>
            </div>
          </div>
          <div class="card-body">
            <div class="form-group row">
              <div class="col-md-12">
                <div class="form-group">
                  <label>Banner </label>
                  <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                    <div class="input-group-prepend">
                      <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                    </div>
                    <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                    <input type="hidden" name="types[]" value="banner">
                    <input type="hidden" name="banner" class="selected-files" value="{{ $item->banner ?? '' }}">
                  </div>
                  <div class="file-preview box"></div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>{{ translate("Image") }} </label>
                  <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                    <div class="input-group-prepend">
                      <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                    </div>
                    <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                    <input type="hidden" name="types[]" value="icon">
                    <input type="hidden" name="icon" class="selected-files" value="{{ $item->icon ?? '' }}">
                  </div>
                  <div class="file-preview box"></div>
                </div>
              </div>
              <div class="col-md-6 col-sm-12">
                <label class="col-form-label">Legenda</label>
                <input type="hidden" name="types[]" value="legenda">
                <input class="form-control" type="text" name="legenda" value="{{ $item->legenda ?? '' }}" />
              </div>
              <div class="col-md-12 col-sm-12">
                <label class="col-form-label">Título</label>
                <input type="hidden" name="types[]" value="titulo2">
                <input class="form-control" type="text" name="titulo2" value="{{ $item->titulo2 ?? '' }}" />
              </div>
            </div>
            <div class="form-group mb-0 text-right">
              <button type="submit" class="btn btn-primary">
                {{ translate('Salvar') }}
              </button>
            </div>
          </div>
        </div>
        <div class="card shadow-lg">
          <div class="card-header d-flex justify-content-between">
            <h4 class="card-title">Section 1</h4>
            <div class="d-flex align-items-center">
              <label class="mr-2">Mostrar seção?</label>
              <label class="aiz-switch aiz-switch-success mb-0">
                <input type="hidden" name="types[]" value="show_section_1">
                <input type="checkbox" name="show_section_1" value="1" {{ isset ($item->show_section_1) && $item->show_section_1 == '1' ? 'checked' : '' }}>
                <span></span>
              </label>
            </div>
          </div>
          <div class="card-body">
            <div class="form-group row">
              <div class="col-md-6">
                <div class="form-group">
                  <label>{{ translate("Image") }} </label>
                  <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                    <div class="input-group-prepend">
                      <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                    </div>
                    <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                    <input type="hidden" name="types[]" value="section_1_img_1">
                    <input type="hidden" name="section_1_img_1" class="selected-files" value="{{ $item->section_1_img_1 ?? '' }}">
                  </div>
                  <div class="file-preview box"></div>
                </div>
              </div>
              <div class="col-md-6 col-sm-12">
                <label class="col-form-label">Legenda</label>
                <input type="hidden" name="types[]" value="section_1_image_alt_1">
                <input class="form-control" type="text" name="section_1_image_alt_1" value="{{ $item->section_1_image_alt_1 ?? '' }}" />
              </div>
              <div class="col-md-12 col-sm-12">
                <label class="col-form-label">Título</label>
                <input type="hidden" name="types[]" value="section_1_conteudo_2">
                <input class="form-control" type="text" name="section_1_conteudo_2" value="{{ $item->section_1_conteudo_2 ?? '' }}" />
              </div>
              <div class="col-md-12 col-sm-12">
                <label class="col-form-label">Texto corrido</label>
                <input type="hidden" name="types[]" value="section_1_textarea_3">
                <textarea name="section_1_textarea_3" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_1_textarea_3 ?? '' }}</textarea>
              </div>
              <div class="col-md-12 col-sm-12">
                <label class="col-form-label">Título</label>
                <input type="hidden" name="types[]" value="section_1_conteudo_4">
                <input class="form-control" type="text" name="section_1_conteudo_4" value="{{ $item->section_1_conteudo_4 ?? '' }}" />
              </div>
              <div class="col-md-12 col-sm-12">
                <label class="col-form-label">Título</label>
                <input type="hidden" name="types[]" value="section_1_conteudo_5">
                <input class="form-control" type="text" name="section_1_conteudo_5" value="{{ $item->section_1_conteudo_5 ?? '' }}" />
              </div>
              <div class="col-md-12 col-sm-12">
                <label class="col-form-label">Texto corrido</label>
                <input type="hidden" name="types[]" value="section_1_textarea_6">
                <textarea name="section_1_textarea_6" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_1_textarea_6 ?? '' }}</textarea>
              </div>
              <div class="col-md-12 col-sm-12">
                <label class="col-form-label">Título</label>
                <input type="hidden" name="types[]" value="section_1_conteudo_7">
                <input class="form-control" type="text" name="section_1_conteudo_7" value="{{ $item->section_1_conteudo_7 ?? '' }}" />
              </div>
            </div>
            <div class="form-group mb-0 text-right">
              <button type="submit" class="btn btn-primary">
                {{ translate('Salvar') }}
              </button>
            </div>
          </div>
        </div>
        <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Section 2</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_2">
                                <input type="checkbox" name="show_section_2" value="1" {{ isset ($item->show_section_2) && $item->show_section_2 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                         </div>
                     </div>
          <div class="card-body">
            <div class="form-group row">
                <div class="col-md-6">
                    <div class="form-group">
                      <label>{{ translate("Image") }} </label>
                      <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                        <div class="input-group-prepend">
                          <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                        </div>
                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                        <input type="hidden" name="types[]" value="section_2_img_10">
                        <input type="hidden" name="section_2_img_10" class="selected-files" value="{{ $item->section_2_img_10 ?? '' }}">
                      </div>
                      <div class="file-preview box"></div>
                    </div>
                  </div>
                  <div class="col-md-6 col-sm-12">
                    <label class="col-form-label">Legenda</label>
                    <input type="hidden" name="types[]" value="section_2_image_alt_10">
                    <input class="form-control" type="text" name="section_2_image_alt_10" value="{{ $item->section_2_image_alt_10 ?? '' }}" />
                  </div>
                <div class="col-md-12 col-sm-12">
                    <label class="col-form-label">Título</label>
                    <input type="hidden" name="types[]" value="section_2_conteudo_11">
                    <input class="form-control" type="text" name="section_2_conteudo_11" value="{{ $item->section_2_conteudo_11 ?? '' }}" />
                </div>
                <div class="col-md-12 col-sm-12">
                    <label class="col-form-label">Título</label>
                    <input type="hidden" name="types[]" value="section_2_conteudo_12">
                    <input class="form-control" type="text" name="section_2_conteudo_12" value="{{ $item->section_2_conteudo_12 ?? '' }}" />
                </div>
                
                <div class="col-md-6">
                    <div class="form-group">
                      <label>{{ translate("Image") }} </label>
                      <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                        <div class="input-group-prepend">
                          <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                        </div>
                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                        <input type="hidden" name="types[]" value="section_2_img_13">
                        <input type="hidden" name="section_2_img_13" class="selected-files" value="{{ $item->section_2_img_13 ?? '' }}">
                      </div>
                      <div class="file-preview box"></div>
                    </div>
                  </div>
                  <div class="col-md-6 col-sm-12">
                    <label class="col-form-label">Legenda</label>
                    <input type="hidden" name="types[]" value="section_2_image_alt_13">
                    <input class="form-control" type="text" name="section_2_image_alt_13" value="{{ $item->section_2_image_alt_13 ?? '' }}" />
                  </div>
                <div class="col-md-12 col-sm-12">
                    <label class="col-form-label">Título</label>
                    <input type="hidden" name="types[]" value="section_2_conteudo_14">
                    <input class="form-control" type="text" name="section_2_conteudo_14" value="{{ $item->section_2_conteudo_14 ?? '' }}" />
                </div>
                <div class="col-md-12 col-sm-12">
                    <label class="col-form-label">Título</label>
                    <input type="hidden" name="types[]" value="section_2_conteudo_15">
                    <input class="form-control" type="text" name="section_2_conteudo_15" value="{{ $item->section_2_conteudo_15 ?? '' }}" />
                </div>
                
                <div class="col-md-6">
                    <div class="form-group">
                      <label>{{ translate("Image") }} </label>
                      <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                        <div class="input-group-prepend">
                          <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                        </div>
                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                        <input type="hidden" name="types[]" value="section_2_img_17">
                        <input type="hidden" name="section_2_img_17" class="selected-files" value="{{ $item->section_2_img_17 ?? '' }}">
                      </div>
                      <div class="file-preview box"></div>
                    </div>
                  </div>
                  <div class="col-md-6 col-sm-12">
                    <label class="col-form-label">Legenda</label>
                    <input type="hidden" name="types[]" value="section_2_image_alt_17">
                    <input class="form-control" type="text" name="section_2_image_alt_17" value="{{ $item->section_2_image_alt_17 ?? '' }}" />
                  </div>
                <div class="col-md-12 col-sm-12">
                    <label class="col-form-label">Título</label>
                    <input type="hidden" name="types[]" value="section_2_conteudo_18">
                    <input class="form-control" type="text" name="section_2_conteudo_18" value="{{ $item->section_2_conteudo_18 ?? '' }}" />
                </div>
                <div class="col-md-12 col-sm-12">
                    <label class="col-form-label">Título</label>
                    <input type="hidden" name="types[]" value="section_2_conteudo_19">
                    <input class="form-control" type="text" name="section_2_conteudo_19" value="{{ $item->section_2_conteudo_19 ?? '' }}" />
                </div>
                
                <div class="col-md-6">
                    <div class="form-group">
                      <label>{{ translate("Image") }} </label>
                      <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                        <div class="input-group-prepend">
                          <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                        </div>
                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                        <input type="hidden" name="types[]" value="section_2_img_20">
                        <input type="hidden" name="section_2_img_20" class="selected-files" value="{{ $item->section_2_img_20 ?? '' }}">
                      </div>
                      <div class="file-preview box"></div>
                    </div>
                  </div>
                  <div class="col-md-6 col-sm-12">
                    <label class="col-form-label">Legenda</label>
                    <input type="hidden" name="types[]" value="section_2_image_alt_20">
                    <input class="form-control" type="text" name="section_2_image_alt_20" value="{{ $item->section_2_image_alt_20 ?? '' }}" />
                  </div>
                <div class="col-md-12 col-sm-12">
                    <label class="col-form-label">Título</label>
                    <input type="hidden" name="types[]" value="section_2_conteudo_21">
                    <input class="form-control" type="text" name="section_2_conteudo_21" value="{{ $item->section_2_conteudo_21 ?? '' }}" />
                </div>
                <div class="col-md-12 col-sm-12">
                    <label class="col-form-label">Título</label>
                    <input type="hidden" name="types[]" value="section_2_conteudo_22">
                    <input class="form-control" type="text" name="section_2_conteudo_22" value="{{ $item->section_2_conteudo_22 ?? '' }}" />
                </div>
            </div>
            <div class="form-group mb-0 text-right">
              <button type="submit" class="btn btn-primary">
                {{ translate('Salvar') }}
              </button>
            </div>
          </div>
        </div>
        <div class="card shadow-lg">
    <div class="card-header d-flex justify-content-between">
        <h4 class="card-title">Section 3</h4>
        <div class="d-flex align-items-center">
            <label class="mr-2">Mostrar seção?</label>
            <label class="aiz-switch aiz-switch-success mb-0">
                <input type="hidden" name="types[]" value="show_section_3">
                <input type="checkbox" name="show_section_3" value="1" {{ isset ($item->show_section_3) && $item->show_section_3 == '1' ? 'checked' : '' }}>
                <span></span>
            </label>
        </div>
    </div>
    <div class="card-body">
        <div class="form-group row">
            <div class="col-md-12">
                <div class="form-group">
                    <label class="col-form-label">Parques</label>
                    @php
                    $indice = 0;
                    @endphp
                    <input type="hidden" name="types[]" value="parques">
                    <div class="parques-target">
                        @if(isset($item->parques) && $item->parques != null && $item->parques != 'null')
                        @foreach(json_decode($item->parques, true) as $key => $value)
                        <div class="card shadow-lg">
                            <div class="row card-body">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="col-form-label">{{ translate("Image") }} </label>
                                        <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                            </div>
                                            <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                            <input type="hidden" name="parques[{{ $key }}][imagem]" class="selected-files" value="{{ $value['imagem'] }}">
                                        </div>
                                        <div class="file-preview box"></div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
                                    <label class="col-form-label">Legenda</label>
                                    <input class="form-control" type="text" name="parques[{{ $key }}][legenda]" value="{{ $value['legenda'] }}" />
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="col-form-label">Título</label>
                                        <input type="text" class="form-control" name="parques[{{ $key }}][titulo]"
                                            value="{{ $value['titulo'] }}">
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="col-form-label">Texto</label>
                                        <input type="text" class="form-control" name="parques[{{ $key }}][texto]"
                                            value="{{ $value['texto'] }}">
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12">
                                    <label class="col-form-label">Texto do Botão</label>
                                    <input class="form-control" type="text" name="parques[{{ $key }}][botao]" value="{{ $value['botao'] }}" />
                                </div>
                                <div class="col-md-4 col-sm-12">
                                    <label class="col-form-label">Link do Botão</label>
                                    <input class="form-control" type="text" name="parques[{{ $key }}][link]" value="{{ $value['link'] }}" />
                                </div>
                                <div class="col-md-4 col-sm-12">
                                    <label class="col-form-label">Legenda SEO</label>
                                    <input class="form-control" type="text" name="parques[{{ $key }}][seo]" value="{{ $value['seo'] }}" />
                                </div>
                                <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                    <i class="las la-times"></i>
                                </button>
                            </div>
                        </div>
                        @php
                        $indice++;
                        @endphp
                        @endforeach
                        @endif
                    </div>
                    <button type="button" class="btn btn-soft-secondary btn-sm add-new-button add-new-button"
                        data-toggle="add-more"
                        data-content='
                                                <div class="card shadow-lg">
                                                    <div class="row card-body">
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="col-form-label">{{ translate("Image") }} </label>
                                                                <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                                                    <div class="input-group-prepend">
                                                                        <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                                                    </div>
                                                                    <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                                                    <input type="hidden" name="parques[][imagem]" class="selected-files">
                                                                </div>
                                                                <div class="file-preview box"></div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6 col-sm-12">
                                                            <label class="col-form-label">Legenda</label>
                                                            <input class="form-control" type="text" name="parques[][legenda]"/>
                                                        </div>
                                                        <div class="col-md-12">
                                                            <div class="form-group">
                                                                <label class="col-form-label">Título</label>
                                                                <input type="text" class="form-control" name="parques[][titulo]">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-12">
                                                            <div class="form-group">
                                                                <label class="col-form-label">Texto</label>
                                                                <input type="text" class="form-control" name="parques[][texto]">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4 col-sm-12">
                                                            <label class="col-form-label">Texto do Botão</label>
                                                            <input class="form-control" type="text" name="parques[][botao]" />
                                                        </div>
                                                        <div class="col-md-4 col-sm-12">
                                                            <label class="col-form-label">Link do Botão</label>
                                                            <input class="form-control" type="text" name="parques[][link]" />
                                                        </div>
                                                        <div class="col-md-4 col-sm-12">
                                                            <label class="col-form-label">Legenda SEO</label>
                                                            <input class="form-control" type="text" name="parques[][seo]" />
                                                        </div>
                                                        <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                                <i class="las la-times"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                '
                        data-target=".parques-target" data-indice="{{ $indice }}">
                        {{ translate('Add New') }}
                    </button>
                </div>
            </div>
        </div>

        <div class="form-group mb-0 text-right">
            <button type="submit" class="btn btn-primary">
                {{ translate('Salvar') }}
            </button>
        </div>
    </div>
</div>

<div class="card shadow-lg">
  <div class="card-header d-flex justify-content-between">
    <h4 class="card-title">Seção Card</h4>
    <div class="d-flex align-items-center">
      <label class="mr-2">Mostrar seção?</label>
      <label class="aiz-switch aiz-switch-success mb-0">
        <input type="hidden" name="types[]" value="show_section_xd">
        <input type="checkbox" name="show_section_xd" value="1" {{ isset ($item->show_section_xd) && $item->show_section_xd == '1' ? 'checked' : '' }}>
        <span></span>
      </label>
    </div>
  </div>
  <div class="card-body">
    <div class="form-group row">
      <div class="col-md-6">
        <div class="form-group">
          <label>{{ translate("Image") }} </label>
          <div class="input-group" data-toggle="aizuploader" data-type="image,video">
            <div class="input-group-prepend">
              <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
            </div>
            <div class="form-control file-amount">{{ translate("Choose File") }}</div>
            <input type="hidden" name="types[]" value="section_xd_img_1">
            <input type="hidden" name="section_xd_img_1" class="selected-files" value="{{ $item->section_xd_img_1 ?? '' }}">
          </div>
          <div class="file-preview box"></div>
        </div>
      </div>
      <div class="col-md-6 col-sm-12">
        <label class="col-form-label">Legenda</label>
        <input type="hidden" name="types[]" value="section_xd_image_alt_1">
        <input class="form-control" type="text" name="section_xd_image_alt_1" value="{{ $item->section_xd_image_alt_1 ?? '' }}" />
      </div>
      <div class="col-md-6">
        <div class="form-group">
          <label>{{ translate("Image") }} </label>
          <div class="input-group" data-toggle="aizuploader" data-type="image,video">
            <div class="input-group-prepend">
              <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
            </div>
            <div class="form-control file-amount">{{ translate("Choose File") }}</div>
            <input type="hidden" name="types[]" value="section_xd_img_2">
            <input type="hidden" name="section_xd_img_2" class="selected-files" value="{{ $item->section_xd_img_2 ?? '' }}">
          </div>
          <div class="file-preview box"></div>
        </div>
      </div>
      <div class="col-md-6 col-sm-12">
        <label class="col-form-label">Legenda</label>
        <input type="hidden" name="types[]" value="section_xd_image_alt_2">
        <input class="form-control" type="text" name="section_xd_image_alt_2" value="{{ $item->section_xd_image_alt_2 ?? '' }}" />
      </div>
      <div class="col-md-6">
        <div class="form-group">
          <label>{{ translate("Image") }} </label>
          <div class="input-group" data-toggle="aizuploader" data-type="image,video">
            <div class="input-group-prepend">
              <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
            </div>
            <div class="form-control file-amount">{{ translate("Choose File") }}</div>
            <input type="hidden" name="types[]" value="section_xd_img_3">
            <input type="hidden" name="section_xd_img_3" class="selected-files" value="{{ $item->section_xd_img_3 ?? '' }}">
          </div>
          <div class="file-preview box"></div>
        </div>
      </div>
      <div class="col-md-6 col-sm-12">
        <label class="col-form-label">Legenda</label>
        <input type="hidden" name="types[]" value="section_xd_image_alt_3">
        <input class="form-control" type="text" name="section_xd_image_alt_3" value="{{ $item->section_xd_image_alt_3 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_xd_conteudo_4">
        <input class="form-control" type="text" name="section_xd_conteudo_4" value="{{ $item->section_xd_conteudo_4 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_xd_conteudo_5">
        <input class="form-control" type="text" name="section_xd_conteudo_5" value="{{ $item->section_xd_conteudo_5 ?? '' }}" />
      </div>
      <div class="col-lg-8">
        <label class="col-form-label">Número</label>
        <input type="hidden" name="types[]" value="section_xd_conteudo_6">
        <input class="form-control" type="text" name="section_xd_conteudo_6" value="{{ $item->section_xd_conteudo_6 ?? '' }}" />
      </div>
      <div class="col-lg-4">
        <label class="col-form-label">Simbolo</label>
        <input type="hidden" name="types[]" value="section_xd_conteudo_7">
        <input class="form-control" type="text" name="section_xd_conteudo_7" value="{{ $item->section_xd_conteudo_7 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_xd_conteudo_8">
        <input class="form-control" type="text" name="section_xd_conteudo_8" value="{{ $item->section_xd_conteudo_8 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Número</label>
        <input type="hidden" name="types[]" value="section_xd_conteudo_9">
        <input class="form-control" type="text" name="section_xd_conteudo_9" value="{{ $item->section_xd_conteudo_9 ?? '' }}" />
      </div>
      <div class="col-lg-8">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_xd_conteudo_10">
        <input class="form-control" type="text" name="section_xd_conteudo_10" value="{{ $item->section_xd_conteudo_10 ?? '' }}" />
      </div>
      <div class="col-lg-4">
        <label class="col-form-label">Subtítulo</label>
        <input type="hidden" name="types[]" value="section_xd_conteudo_11">
        <input class="form-control" type="text" name="section_xd_conteudo_11" value="{{ $item->section_xd_conteudo_11 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_xd_conteudo_12">
        <input class="form-control" type="text" name="section_xd_conteudo_12" value="{{ $item->section_xd_conteudo_12 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_xd_conteudo_13">
        <input class="form-control" type="text" name="section_xd_conteudo_13" value="{{ $item->section_xd_conteudo_13 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_xd_conteudo_14">
        <textarea name="section_xd_conteudo_14" rows="5" class="form-control">{{ $item->section_xd_conteudo_14 ?? '' }}</textarea>
      </div>
      <div class="col-md-4 col-sm-12">
        <label class="col-form-label">Texto do Botão</label>
        <input type="hidden" name="types[]" value="section_xd_link_conteudo_15">
        <input class="form-control" type="text" name="section_xd_link_conteudo_15" value="{{ $item->section_xd_link_conteudo_15 ?? '' }}" />
      </div>
      <div class="col-md-4 col-sm-12">
        <label class="col-form-label">Link do Botão</label>
        <input type="hidden" name="types[]" value="section_xd_link_15">
        <input class="form-control" type="text" name="section_xd_link_15" value="{{ $item->section_xd_link_15 ?? '' }}" />
      </div>
      <div class="col-md-4 col-sm-12">
        <label class="col-form-label">Legenda SEO</label>
        <input type="hidden" name="types[]" value="section_xd_link_alt_15">
        <input class="form-control" type="text" name="section_xd_link_alt_15" value="{{ $item->section_xd_link_alt_15 ?? '' }}" />
      </div>
    </div>
    <div class="form-group mb-0 text-right">
      <button type="submit" class="btn btn-primary">
        {{ translate('Salvar') }}
      </button>
    </div>
  </div>
</div>

<div class="card shadow-lg">
  <div class="card-header d-flex justify-content-between">
    <h4 class="card-title">Section 4</h4>
    <div class="d-flex align-items-center">
      <label class="mr-2">Mostrar seção?</label>
      <label class="aiz-switch aiz-switch-success mb-0">
        <input type="hidden" name="types[]" value="show_section_3d">
        <input type="checkbox" name="show_section_3d" value="1" {{ isset ($item->show_section_3d) && $item->show_section_3d == '1' ? 'checked' : '' }}>
        <span></span>
      </label>
    </div>
  </div>
  <div class="card-body">
    <div class="form-group row">
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_3d_conteudo_4">
        <input class="form-control" type="text" name="section_3d_conteudo_4" value="{{ $item->section_3d_conteudo_4 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_3d_conteudo_5">
        <input class="form-control" type="text" name="section_3d_conteudo_5" value="{{ $item->section_3d_conteudo_5 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Texto corrido</label>
        <input type="hidden" name="types[]" value="section_3d_textarea_6">
        <textarea name="section_3d_textarea_6" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_3d_textarea_6 ?? '' }}</textarea>
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_3d_conteudo_7">
        <input class="form-control" type="text" name="section_3d_conteudo_7" value="{{ $item->section_3d_conteudo_7 ?? '' }}" />
      </div>
      <div class="col-md-6">
        <div class="form-group">
          <label>{{ translate("Image") }} </label>
          <div class="input-group" data-toggle="aizuploader" data-type="image,video">
            <div class="input-group-prepend">
              <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
            </div>
            <div class="form-control file-amount">{{ translate("Choose File") }}</div>
            <input type="hidden" name="types[]" value="section_3d_img_8">
            <input type="hidden" name="section_3d_img_8" class="selected-files" value="{{ $item->section_3d_img_8 ?? '' }}">
          </div>
          <div class="file-preview box"></div>
        </div>
      </div>
      <div class="col-md-6 col-sm-12">
        <label class="col-form-label">Legenda</label>
        <input type="hidden" name="types[]" value="section_3d_image_alt_8">
        <input class="form-control" type="text" name="section_3d_image_alt_8" value="{{ $item->section_3d_image_alt_8 ?? '' }}" />
      </div>
    </div>
    <div class="form-group mb-0 text-right">
      <button type="submit" class="btn btn-primary">
        {{ translate('Salvar') }}
      </button>
    </div>
  </div>
</div>


<div class="card shadow-lg">
  <div class="card-header d-flex justify-content-between">
    <h4 class="card-title">Seção Card</h4>
    <div class="d-flex align-items-center">
      <label class="mr-2">Mostrar seção?</label>
      <label class="aiz-switch aiz-switch-success mb-0">
        <input type="hidden" name="types[]" value="show_section_xd2">
        <input type="checkbox" name="show_section_xd2" value="1" {{ isset ($item->show_section_xd2) && $item->show_section_xd2 == '1' ? 'checked' : '' }}>
        <span></span>
      </label>
    </div>
  </div>
  <div class="card-body">
    <div class="form-group row">
      <div class="col-md-6">
        <div class="form-group">
          <label>{{ translate("Image") }} </label>
          <div class="input-group" data-toggle="aizuploader" data-type="image,video">
            <div class="input-group-prepend">
              <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
            </div>
            <div class="form-control file-amount">{{ translate("Choose File") }}</div>
            <input type="hidden" name="types[]" value="section_xd2_img_37">
            <input type="hidden" name="section_xd2_img_37" class="selected-files" value="{{ $item->section_xd2_img_37 ?? '' }}">
          </div>
          <div class="file-preview box"></div>
        </div>
      </div>
      <div class="col-md-6 col-sm-12">
        <label class="col-form-label">Legenda</label>
        <input type="hidden" name="types[]" value="section_xd2_image_alt_37">
        <input class="form-control" type="text" name="section_xd2_image_alt_37" value="{{ $item->section_xd2_image_alt_37 ?? '' }}" />
      </div>
      <div class="col-md-4 col-sm-12">
        <label class="col-form-label">Texto do Botão</label>
        <input type="hidden" name="types[]" value="section_xd2_link_conteudo_38">
        <input class="form-control" type="text" name="section_xd2_link_conteudo_38" value="{{ $item->section_xd2_link_conteudo_38 ?? '' }}" />
      </div>
      <div class="col-md-4 col-sm-12">
        <label class="col-form-label">Link do Botão</label>
        <input type="hidden" name="types[]" value="section_xd2_link_38">
        <input class="form-control" type="text" name="section_xd2_link_38" value="{{ $item->section_xd2_link_38 ?? '' }}" />
      </div>
      <div class="col-md-4 col-sm-12">
        <label class="col-form-label">Legenda SEO</label>
        <input type="hidden" name="types[]" value="section_xd2_link_alt_38">
        <input class="form-control" type="text" name="section_xd2_link_alt_38" value="{{ $item->section_xd2_link_alt_38 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_xd2_conteudo_39">
        <input class="form-control" type="text" name="section_xd2_conteudo_39" value="{{ $item->section_xd2_conteudo_39 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_xd2_conteudo_40">
        <input class="form-control" type="text" name="section_xd2_conteudo_40" value="{{ $item->section_xd2_conteudo_40 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_xd2_conteudo_41">
        <input class="form-control" type="text" name="section_xd2_conteudo_41" value="{{ $item->section_xd2_conteudo_41 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Texto corrido</label>
        <input type="hidden" name="types[]" value="section_xd2_textarea_42">
        <textarea name="section_xd2_textarea_42" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_xd2_textarea_42 ?? '' }}</textarea>
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_xd2_conteudo_43">
        <input class="form-control" type="text" name="section_xd2_conteudo_43" value="{{ $item->section_xd2_conteudo_43 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Texto corrido</label>
        <input type="hidden" name="types[]" value="section_xd2_textarea_44">
        <textarea name="section_xd2_textarea_44" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_xd2_textarea_44 ?? '' }}</textarea>
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_xd2_conteudo_45">
        <input class="form-control" type="text" name="section_xd2_conteudo_45" value="{{ $item->section_xd2_conteudo_45 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Texto corrido</label>
        <input type="hidden" name="types[]" value="section_xd2_textarea_46">
        <textarea name="section_xd2_textarea_46" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_xd2_textarea_46 ?? '' }}</textarea>
      </div>
      <div class="col-md-4 col-sm-12">
        <label class="col-form-label">Texto do Botão</label>
        <input type="hidden" name="types[]" value="section_xd2_link_conteudo_47">
        <input class="form-control" type="text" name="section_xd2_link_conteudo_47" value="{{ $item->section_xd2_link_conteudo_47 ?? '' }}" />
      </div>
      <div class="col-md-4 col-sm-12">
        <label class="col-form-label">Link do Botão</label>
        <input type="hidden" name="types[]" value="section_xd2_link_47">
        <input class="form-control" type="text" name="section_xd2_link_47" value="{{ $item->section_xd2_link_47 ?? '' }}" />
      </div>
      <div class="col-md-4 col-sm-12">
        <label class="col-form-label">Legenda SEO</label>
        <input type="hidden" name="types[]" value="section_xd2_link_alt_47">
        <input class="form-control" type="text" name="section_xd2_link_alt_47" value="{{ $item->section_xd2_link_alt_47 ?? '' }}" />
      </div>
    </div>
    <div class="form-group mb-0 text-right">
      <button type="submit" class="btn btn-primary">
        {{ translate('Salvar') }}
      </button>
    </div>
  </div>
</div>

<div class="card shadow-lg">
  <div class="card-header d-flex justify-content-between">
    <h4 class="card-title">Seção Steps</h4>
    <div class="d-flex align-items-center">
      <label class="mr-2">Mostrar seção?</label>
      <label class="aiz-switch aiz-switch-success mb-0">
        <input type="hidden" name="types[]" value="show_section_6">
        <input type="checkbox" name="show_section_6" value="1" {{ isset ($item->show_section_6) && $item->show_section_6 == '1' ? 'checked' : '' }}>
        <span></span>
      </label>
    </div>
  </div>
  <div class="card-body">
    <div class="form-group row">
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_6_conteudo_48">
        <input class="form-control" type="text" name="section_6_conteudo_48" value="{{ $item->section_6_conteudo_48 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_6_conteudo_49">
        <input class="form-control" type="text" name="section_6_conteudo_49" value="{{ $item->section_6_conteudo_49 ?? '' }}" />
      </div>
      <div class="col-md-12">
        <div class="form-group">
          <label>Passos</label>
          @php
          $indice = 0;
          @endphp
          <input type="hidden" name="types[]" value="steps">
          <div class="steps-target">
            @if(isset($item->steps) && $item->steps != null && $item->steps != 'null')
            @foreach(json_decode($item->steps, true) as $key => $value)
            <div class="card shadow-lg">
              <div class="row card-body">
                <div class="col-md-12">
                  <div class="form-group">
                    <label>Título</label>
                    <input type="text" class="form-control" name="steps[{{ $key }}][titulo]" value="{{ $value['titulo'] }}">
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="form-group">
                    <label>Texto corrido</label>
                    <textarea name="steps[{{ $key }}][corrido]" class="form-control" data-min-height="300" cols="30" rows="5">{{ $value['corrido'] }}</textarea>
                  </div>
                </div>
                <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                  <i class="las la-times"></i>
                </button>
              </div>
            </div>
            @php
            $indice++;
            @endphp
            @endforeach
            @endif
          </div>
          <button type="button" class="btn btn-soft-secondary btn-sm add-new-button add-new-button" data-toggle="add-more" data-content='
                                            <div class="card shadow-lg">
                                                <div class="row card-body">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label>Título</label>
                                                            <input type="text" class="form-control" name="steps[][titulo]">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label>Texto corrido</label>
                                                            <textarea name="steps[][corrido]" class="form-control" data-min-height="300" cols="30" rows="5"></textarea>
                                                        </div>
                                                    </div>
                                                    <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                            <i class="las la-times"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            ' data-target=".steps-target" data-indice="{{ $indice }}">
            Adicionar
          </button>
        </div>
      </div>
    </div>
    <div class="form-group mb-0 text-right">
      <button type="submit" class="btn btn-primary">
        {{ translate('Salvar') }}
      </button>
    </div>
  </div>
</div>
<div class="card shadow-lg">
  <div class="card-header d-flex justify-content-between">
    <h4 class="card-title">Section 5</h4>
    <div class="d-flex align-items-center">
      <label class="mr-2">Mostrar seção?</label>
      <label class="aiz-switch aiz-switch-success mb-0">
        <input type="hidden" name="types[]" value="show_section_4">
        <input type="checkbox" name="show_section_4" value="1" {{ isset ($item->show_section_4) && $item->show_section_4 == '1' ? 'checked' : '' }}>
        <span></span>
      </label>
    </div>
  </div>
  <div class="card-body">
    <div class="form-group row">
        <div class="col-md-12">
          <div class="form-group">
            <label class="col-form-label">Cards</label>
            @php
            $indice = 0;
            @endphp
            <input type="hidden" name="types[]" value="cards">
            <div class="cards-target">
              @if(isset($item->cards) && $item->cards != null && $item->cards != 'null')
              @foreach(json_decode($item->cards, true) as $key => $value)
              <div class="card shadow-lg">
                <div class="row card-body">
                    <div class="col-md-6">
                        <div class="form-group">
                          <label>{{ translate("Image") }} </label>
                          <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                            <div class="input-group-prepend">
                              <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                            </div>
                            <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                            <input type="hidden" name="cards[{{ $key }}][image]" class="selected-files" value="{{ $value['image'] }}">
                          </div>
                          <div class="file-preview box"></div>
                        </div>
                  </div>
                  <div class="col-md-6 col-sm-12">
                    <label class="col-form-label">Legenda</label>
                    <input class="form-control" type="text" name="cards[{{ $key }}][image_legend]" value="{{ $value['image_legend'] }}" />
                  </div>
                  <div class="col-md-12">
                    <div class="form-group">
                      <label class="col-form-label">Título</label>
                      <input type="text" class="form-control" name="cards[{{ $key }}][titulo]" value="{{ $value['titulo'] }}">
                    </div>
                  </div>
                  <div class="col-md-12">
                    <div class="form-group">
                      <label class="col-form-label">Descrição</label>
                      <input type="text" class="form-control" name="cards[{{ $key }}][descricao]" value="{{ $value['descricao'] }}">
                    </div>
                  </div>
                  <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                    <i class="las la-times"></i>
                  </button>
                </div>
              </div>
              @php
              $indice++;
              @endphp
              @endforeach
              @endif
            </div>
            <button type="button" class="btn btn-soft-secondary btn-sm add-new-button add-new-button" data-toggle="add-more" data-content='
                                                        <div class="card shadow-lg">
                                                            <div class="row card-body">
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                      <label>{{ translate("Image") }} </label>
                                                                      <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                                                        <div class="input-group-prepend">
                                                                          <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                                                        </div>
                                                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                                                        <input type="hidden" name="cards[][image]" class="selected-files">
                                                                      </div>
                                                                      <div class="file-preview box"></div>
                                                                    </div>
                                                              </div>
                                                              <div class="col-md-6 col-sm-12">
                                                                <label class="col-form-label">Legenda</label>
                                                                <input class="form-control" type="text" name="cards[}][image_legend]"/>
                                                              </div>
                                                                <div class="col-md-12">
                                                                    <div class="form-group">
                                                                        <label class="col-form-label">Título</label>
                                                                        <input type="text" class="form-control" name="cards[][titulo]">
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-12">
                                                                    <div class="form-group">
                                                                        <label class="col-form-label">Descrição</label>
                                                                        <input type="text" class="form-control" name="cards[][descricao]">
                                                                    </div>
                                                                </div>
                                                                <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                                        <i class="las la-times"></i>
                                                                </button>
                                                            </div>
                                                        </div>
                                                        ' data-target=".cards-target" data-indice="{{ $indice }}">
              Adicionar
            </button>
          </div>
        </div>
      <div class="col-md-6">
        <div class="form-group">
          <label>{{ translate("Image") }} </label>
          <div class="input-group" data-toggle="aizuploader" data-type="image,video">
            <div class="input-group-prepend">
              <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
            </div>
            <div class="form-control file-amount">{{ translate("Choose File") }}</div>
            <input type="hidden" name="types[]" value="section_4_img_9">
            <input type="hidden" name="section_4_img_9" class="selected-files" value="{{ $item->section_4_img_9 ?? '' }}">
          </div>
          <div class="file-preview box"></div>
        </div>
      </div>
      <div class="col-md-6 col-sm-12">
        <label class="col-form-label">Legenda</label>
        <input type="hidden" name="types[]" value="section_4_image_alt_9">
        <input class="form-control" type="text" name="section_4_image_alt_9" value="{{ $item->section_4_image_alt_9 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="titulo">
        <input class="form-control" type="text" name="titulo" value="{{ $item->titulo ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Sub Título</label>
        <input type="hidden" name="types[]" value="section_4_conteudo_4">
        <input class="form-control" type="text" name="section_4_conteudo_4" value="{{ $item->section_4_conteudo_4 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_4_conteudo_5">
        <input class="form-control" type="text" name="section_4_conteudo_5" value="{{ $item->section_4_conteudo_5 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Texto corrido</label>
        <input type="hidden" name="types[]" value="section_4_textarea_6">
        <textarea name="section_4_textarea_6" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_4_textarea_6 ?? '' }}</textarea>
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_4_conteudo_7">
        <input class="form-control" type="text" name="section_4_conteudo_7" value="{{ $item->section_4_conteudo_7 ?? '' }}" />
      </div>
      
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Texto corrido</label>
        <input type="hidden" name="types[]" value="section_4_textarea_10">
        <textarea name="section_4_textarea_10" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_4_textarea_10 ?? '' }}</textarea>
      </div>
      <div class="col-md-4 col-sm-12">
        <label class="col-form-label">Texto do Botão</label>
        <input type="hidden" name="types[]" value="section_4_link_conteudo_11">
        <input class="form-control" type="text" name="section_4_link_conteudo_11" value="{{ $item->section_4_link_conteudo_11 ?? '' }}" />
      </div>
      <div class="col-md-4 col-sm-12">
        <label class="col-form-label">Link do Botão</label>
        <input type="hidden" name="types[]" value="section_4_link_11">
        <input class="form-control" type="text" name="section_4_link_11" value="{{ $item->section_4_link_11 ?? '' }}" />
      </div>
      <div class="col-md-4 col-sm-12">
        <label class="col-form-label">Legenda SEO</label>
        <input type="hidden" name="types[]" value="section_4_link_alt_11">
        <input class="form-control" type="text" name="section_4_link_alt_11" value="{{ $item->section_4_link_alt_11 ?? '' }}" />
      </div>
      <div class="col-md-6">
        <div class="form-group">
          <label>{{ translate("Image") }} </label>
          <div class="input-group" data-toggle="aizuploader" data-type="image,video">
            <div class="input-group-prepend">
              <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
            </div>
            <div class="form-control file-amount">{{ translate("Choose File") }}</div>
            <input type="hidden" name="types[]" value="section_4_img_12">
            <input type="hidden" name="section_4_img_12" class="selected-files" value="{{ $item->section_4_img_12 ?? '' }}">
          </div>
          <div class="file-preview box"></div>
        </div>
      </div>
      <div class="col-md-6 col-sm-12">
        <label class="col-form-label">Legenda</label>
        <input type="hidden" name="types[]" value="section_4_image_alt_12">
        <input class="form-control" type="text" name="section_4_image_alt_12" value="{{ $item->section_4_image_alt_12 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_4_conteudo_13">
        <input class="form-control" type="text" name="section_4_conteudo_13" value="{{ $item->section_4_conteudo_13 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_4_conteudo_14">
        <input class="form-control" type="text" name="section_4_conteudo_14" value="{{ $item->section_4_conteudo_14 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_4_conteudo_15">
        <input class="form-control" type="text" name="section_4_conteudo_15" value="{{ $item->section_4_conteudo_15 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_4_conteudo_16">
        <input class="form-control" type="text" name="section_4_conteudo_16" value="{{ $item->section_4_conteudo_16 ?? '' }}" />
      </div>
      <div class="col-md-4 col-sm-12">
        <label class="col-form-label">Link do Botão</label>
        <input type="hidden" name="types[]" value="section_4_link_17">
        <input class="form-control" type="text" name="section_4_link_17" value="{{ $item->section_4_link_17 ?? '' }}" />
      </div>
      <div class="col-md-4 col-sm-12">
        <label class="col-form-label">Legenda SEO</label>
        <input type="hidden" name="types[]" value="section_4_link_alt_17">
        <input class="form-control" type="text" name="section_4_link_alt_17" value="{{ $item->section_4_link_alt_17 ?? '' }}" />
      </div>
      <div class="col-md-6">
        <div class="form-group">
          <label>{{ translate("Image") }} background </label>
          <div class="input-group" data-toggle="aizuploader" data-type="image,video">
            <div class="input-group-prepend">
              <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
            </div>
            <div class="form-control file-amount">{{ translate("Choose File") }}</div>
            <input type="hidden" name="types[]" value="section_4_img_183">
            <input type="hidden" name="section_4_img_183" class="selected-files" value="{{ $item->section_4_img_183 ?? '' }}">
          </div>
          <div class="file-preview box"></div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="form-group">
          <label>{{ translate("Image") }} </label>
          <div class="input-group" data-toggle="aizuploader" data-type="image,video">
            <div class="input-group-prepend">
              <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
            </div>
            <div class="form-control file-amount">{{ translate("Choose File") }}</div>
            <input type="hidden" name="types[]" value="section_4_img_18">
            <input type="hidden" name="section_4_img_18" class="selected-files" value="{{ $item->section_4_img_18 ?? '' }}">
          </div>
          <div class="file-preview box"></div>
        </div>
      </div>
      <div class="col-md-6 col-sm-12">
        <label class="col-form-label">Legenda</label>
        <input type="hidden" name="types[]" value="section_4_image_alt_18">
        <input class="form-control" type="text" name="section_4_image_alt_18" value="{{ $item->section_4_image_alt_18 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_4_conteudo_19">
        <input class="form-control" type="text" name="section_4_conteudo_19" value="{{ $item->section_4_conteudo_19 ?? '' }}" />
      </div>
      <div class="col-md-4 col-sm-12">
        <label class="col-form-label">Link do Botão</label>
        <input type="hidden" name="types[]" value="section_4_link_20">
        <input class="form-control" type="text" name="section_4_link_20" value="{{ $item->section_4_link_20 ?? '' }}" />
      </div>
      <div class="col-md-4 col-sm-12">
        <label class="col-form-label">Legenda SEO</label>
        <input type="hidden" name="types[]" value="section_4_link_alt_20">
        <input class="form-control" type="text" name="section_4_link_alt_20" value="{{ $item->section_4_link_alt_20 ?? '' }}" />
      </div>
    </div>
    <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_5_img_88">
                                        <input type="hidden" name="section_5_img_88" class="selected-files" value="{{ $item->section_5_img_88 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_5_image_alt_88">
                                <input class="form-control" type="text" name="section_5_image_alt_88" value="{{ $item->section_5_image_alt_88 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_5_conteudo_89">
                                <input class="form-control" type="text" name="section_5_conteudo_89" value="{{ $item->section_5_conteudo_89 ?? '' }}" />
                            </div>
    <div class="form-group mb-0 text-right">
      <button type="submit" class="btn btn-primary">
        {{ translate('Salvar') }}
      </button>
    </div>
  </div>
</div>
<div class="card shadow-lg">
  <div class="card-header d-flex justify-content-between">
    <h4 class="card-title">Section 6</h4>
    <div class="d-flex align-items-center">
      <label class="mr-2">Mostrar seção?</label>
      <label class="aiz-switch aiz-switch-success mb-0">
        <input type="hidden" name="types[]" value="show_section_5">
        <input type="checkbox" name="show_section_5" value="1" {{ isset ($item->show_section_5) && $item->show_section_5 == '1' ? 'checked' : '' }}>
        <span></span>
      </label>
    </div>
  </div>
  <div class="card-body">
    <div class="form-group row">
      <div class="col-md-12">
        <div class="form-group">
          <label>{{ translate("Image") }} </label>
          <div class="input-group" data-toggle="aizuploader" data-type="image,video">
            <div class="input-group-prepend">
              <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
            </div>
            <div class="form-control file-amount">{{ translate("Choose File") }}</div>
            <input type="hidden" name="types[]" value="img_18">
            <input type="hidden" name="img_18" class="selected-files" value="{{ $item->img_18 ?? '' }}">
          </div>
          <div class="file-preview box"></div>
        </div>
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_5_conteudo_21">
        <input class="form-control" type="text" name="section_5_conteudo_21" value="{{ $item->section_5_conteudo_21 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_5_conteudo_22">
        <input class="form-control" type="text" name="section_5_conteudo_22" value="{{ $item->section_5_conteudo_22 ?? '' }}" />
      </div>
      <div class="col-md-12">
        <div class="form-group">
          <label class="col-form-label">Ano</label>
          @php
          $indice = 0;
          @endphp
          <input type="hidden" name="types[]" value="award">
          <div class="award-target">
            @if(isset($item->award) && $item->award != null && $item->award != 'null')
            @foreach(json_decode($item->award, true) as $key => $value)
            <div class="card shadow-lg">
              <div class="row card-body">
                <div class="col-md-12">
                  <div class="form-group">
                    <label class="col-form-label">Título</label>
                    <input type="text" class="form-control" name="award[{{ $key }}][ano]" value="{{ $value['ano'] }}">
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="form-group">
                    <label class="col-form-label">Título</label>
                    <input type="text" class="form-control" name="award[{{ $key }}][titulo]" value="{{ $value['titulo'] }}">
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="form-group">
                    <label class="col-form-label">Texto corrido</label>
                    <textarea name="award[{{ $key }}][corrido]" class="form-control" data-min-height="300" cols="30" rows="5">{{ $value['corrido'] }}</textarea>
                  </div>
                </div>
                <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                  <i class="las la-times"></i>
                </button>
              </div>
            </div>
            @php
            $indice++;
            @endphp
            @endforeach
            @endif
          </div>
          <button type="button" class="btn btn-soft-secondary btn-sm add-new-button add-new-button" data-toggle="add-more" data-content='
                                            <div class="card shadow-lg">
                                                <div class="row card-body">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label class="col-form-label">Título</label>
                                                            <input type="text" class="form-control" name="award[][ano]">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label class="col-form-label">Título</label>
                                                            <input type="text" class="form-control" name="award[][titulo]">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label class="col-form-label">Texto corrido</label>
                                                            <textarea name="award[][corrido]" class="form-control" data-min-height="300" cols="30" rows="5"></textarea>
                                                        </div>
                                                    </div>
                                                    <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                            <i class="las la-times"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            ' data-target=".award-target" data-indice="{{ $indice }}">
            Adicionar
          </button>
        </div>
      </div>
    </div>
    <div class="form-group mb-0 text-right">
      <button type="submit" class="btn btn-primary">
        {{ translate('Salvar') }}
      </button>
    </div>
  </div>
</div>
<div class="card shadow-lg">
  <div class="card-header d-flex justify-content-between">
    <h4 class="card-title">Section 7</h4>
    <div class="d-flex align-items-center">
      <label class="mr-2">Mostrar seção?</label>
      <label class="aiz-switch aiz-switch-success mb-0">
        <input type="hidden" name="types[]" value="show_section_6">
        <input type="checkbox" name="show_section_6" value="1" {{ isset ($item->show_section_6) && $item->show_section_6 == '1' ? 'checked' : '' }}>
        <span></span>
      </label>
    </div>
  </div>
  <div class="card-body">
    <div class="form-group row">
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_6_conteudo_23">
        <input class="form-control" type="text" name="section_6_conteudo_23" value="{{ $item->section_6_conteudo_23 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Título</label>
        <input type="hidden" name="types[]" value="section_6_conteudo_24">
        <input class="form-control" type="text" name="section_6_conteudo_24" value="{{ $item->section_6_conteudo_24 ?? '' }}" />
      </div>
      <div class="col-md-12 col-sm-12">
        <label class="col-form-label">Texto corrido</label>
        <input type="hidden" name="types[]" value="section_6_textarea_25">
        <textarea name="section_6_textarea_25" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_6_textarea_25 ?? '' }}</textarea>
      </div>
    </div>
    <div class="form-group mb-0 text-right">
      <button type="submit" class="btn btn-primary">
        {{ translate('Salvar') }}
      </button>
    </div>
  </div>
</div>
<div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Section 8</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_8">
                                <input type="checkbox" name="show_section_8" value="1" {{ isset ($item->show_section_8) && $item->show_section_8 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_8_conteudo_89">
                                <input class="form-control" type="text" name="section_8_conteudo_89" value="{{ $item->section_8_conteudo_89 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_8_img_88">
                                        <input type="hidden" name="section_8_img_88" class="selected-files" value="{{ $item->section_8_img_88 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_8_image_alt_88">
                                <input class="form-control" type="text" name="section_8_image_alt_88" value="{{ $item->section_8_image_alt_88 ?? '' }}" />
                            </div>
                            
                            
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
</div>
<div class="card shadow-lg">
    <div class="card-header d-flex justify-content-between">
        <h4 class="card-title">Section Galeria</h4>
        <div class="d-flex align-items-center">
            <label class="mr-2">Mostrar seção?</label>
            <label class="aiz-switch aiz-switch-success mb-0">
                <input type="hidden" name="types[]" value="show_section_images">
                <input type="checkbox" name="show_section_images" value="1" {{ isset ($item->show_section_images) && $item->show_section_images == '1' ? 'checked' : '' }}>
                <span></span>
            </label>
        </div>
    </div>
    <div class="card-body">
        <div class="form-group row">
            <div class="col-md-12">
                <div class="form-group">
                    <label class="col-form-label">Imagens</label>
                    @php
                    $indice = 0;
                    @endphp
                    <input type="hidden" name="types[]" value="images">
                    <div class="images-target">
                        @if(isset($item->images) && $item->images != null && $item->images != 'null')
                        @foreach(json_decode($item->images, true) as $key => $value)
                        <div class="card shadow-lg">
                            <div class="row card-body">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="col-form-label">{{ translate("Image") }} </label>
                                        <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                            </div>
                                            <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                            <input type="hidden" name="images[{{ $key }}][imagem]" class="selected-files" value="{{ $value['imagem'] }}">
                                        </div>
                                        <div class="file-preview box"></div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
                                    <label class="col-form-label">Legenda</label>
                                    <input class="form-control" type="text" name="images[{{ $key }}][legenda]" value="{{ $value['legenda'] }}" />
                                </div>
                                <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                    <i class="las la-times"></i>
                                </button>
                            </div>
                        </div>
                        @php
                        $indice++;
                        @endphp
                        @endforeach
                        @endif
                    </div>
                    <button type="button" class="btn btn-soft-secondary btn-sm add-new-button add-new-button"
                        data-toggle="add-more"
                        data-content='
                                                <div class="card shadow-lg">
                                                    <div class="row card-body">
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="col-form-label">{{ translate("Image") }} </label>
                                                                <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                                                    <div class="input-group-prepend">
                                                                        <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                                                    </div>
                                                                    <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                                                    <input type="hidden" name="images[][imagem]" class="selected-files">
                                                                </div>
                                                                <div class="file-preview box"></div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6 col-sm-12">
                                                            <label class="col-form-label">Legenda</label>
                                                            <input class="form-control" type="text" name="images[][legenda]"/>
                                                        </div>
                                                        <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                                <i class="las la-times"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                '
                        data-target=".images-target" data-indice="{{ $indice }}">
                        {{ translate('Add New') }}
                    </button>
                </div>
            </div>
        </div>

        <div class="form-group mb-0 text-right">
            <button type="submit" class="btn btn-primary">
                {{ translate('Salvar') }}
            </button>
        </div>
    </div>
</div>
<div class="card shadow-lg">
  <div class="card-body">
    <div class="form-group row">
      <label class="col-md-3 col-form-label">{{ translate('Meta Title') }}</label>
      <div class="col-md-9">
        <input type="hidden" name="types[]" value="meta_title">
        <input type="text" class="form-control" name="meta_title" value="{{ $item->meta_title ?? '' }}" placeholder="{{ translate('Meta Title') }}">
      </div>
    </div>
    <div class="form-group row">
      <label class="col-md-3 col-form-label">{{ translate('Meta Description') }}</label>
      <div class="col-md-9">
        <input type="hidden" name="types[]" value="meta_description">
        <textarea name="meta_description" rows="5" class="form-control">{{ $item->meta_description ?? '' }}</textarea>
      </div>
    </div>
    <div class="form-group row">
      <label class="col-md-3 col-form-label">
        {{ translate('Meta Keywords') }}
      </label>
      <div class="col-md-9">
        <input type="hidden" name="types[]" value="meta_keywords">
        <input type="text" class="form-control" id="meta_keywords" name="meta_keywords" value="{{ $item->meta_keywords ?? '' }}" placeholder="{{ translate('Meta Keywords') }}">
      </div>
    </div>
    <div class="form-group mb-0 text-right">
      <button type="submit" class="btn btn-primary">
        {{ translate('Salvar') }}
      </button>
    </div>
  </div>
</div>
</form>
</div>
</div>
@endsection
@section('script')
<script>
  function makeSlug(val) {
    let output = val.replace(/\s+/g, "-").toLowerCase();
    $("#slug").val(output);
  }
  $(document).ready(function() {
    $(document).on("click", ".add-new-button", function() {
      $(".aiz-text-editor").each(function() {
        AIZ.plugins.textEditor($(this));
      });
    });
    AIZ.plugins.bootstrapSelect("refresh");
  });

</script>
@endsection

{{--<div class="col-md-12">
    <div class="form-group">
        <label>Comentários</label>
@php
            $indice = 0;
@endphp
        <div class="section_8_conteudo_61-target">
@if($item->section_8_conteudo_61 != null && $item->section_8_conteudo_61 != 'null')
@foreach(json_decode($item->section_8_conteudo_61, true) as $key => $value)
                    <div class="card shadow-lg">
                        <div class="row card-body">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate('Image') }}</label>
<div class="input-group" data-toggle="aizuploader" data-type="image">
  <div class="input-group-prepend">
    <div class="input-group-text bg-soft-secondary font-weight-medium">
      {{ translate('Browse') }}
    </div>
  </div>
  <div class="form-control file-amount">{{ translate('Choose File') }}</div>
  <input type="hidden" name="coment[{{ $key }}][imagem]" class="selected-files" value="{{ $value['imagem'] }}">
</div>
<div class="file-preview box"></div>
</div>
</div>
<div class="col-md-6">
  <div class="form-group">
    <label>Legenda</label>
    <input type="text" class="form-control" name="coment[{{ $key }}][legenda]" value="{{ $value['legenda'] }}">
  </div>
</div>
<div class="col-md-12">
  <div class="form-group">
    <label>Título</label>
    <input type="text" class="form-control" name="coment[{{ $key }}][titulo]" value="{{ $value['titulo'] }}">
  </div>
</div>
<div class="col-md-12">
  <div class="form-group">
    <label>Texto corrido</label>
    <textarea name="coment[{{ $key }}][corrido]" class="form-control" data-min-height="300" cols="30" rows="5">{{ $value['corrido'] }}</textarea>
  </div>
</div>
<button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
  <i class="las la-times"></i>
</button>
</div>
</div>
@php
$indice++;
@endphp
@endforeach
@endif
</div>
<button type="button" class="btn btn-soft-secondary btn-sm add-new-button add-new-button" data-toggle="add-more" data-content='
            <div class="card shadow-lg">
                <div class="row card-body">
                        <div class="col-md-6">
                <div class="form-group">
                    <label>{{ translate('Image') }}</label>
                    <div class="input-group" data-toggle="aizuploader" data-type="image">
                        <div class="input-group-prepend">
                            <div class="input-group-text bg-soft-secondary font-weight-medium">
                                {{ translate('Browse') }}</div>
                        </div>
                        <div class="form-control file-amount">{{ translate('Choose File') }}</div>
                        <input type="hidden" name="coment[][imagem]" class="selected-files">
                    </div>
                    <div class="file-preview box"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>Legenda</label>
                    <input type="text" class="form-control" name="coment[][legenda]">
                </div>
            </div>
            <div class="col-md-12">
                <div class="form-group">
                    <label>Título</label>
                    <input type="text" class="form-control" name="coment[][titulo]">
                </div>
            </div>
            <div class="col-md-12">
                <div class="form-group">
                    <label>Texto corrido</label>
                    <textarea name="coment[][corrido]" class="form-control" data-min-height="300" cols="30" rows="5"></textarea>
                </div>
            </div>
                    <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                            <i class="las la-times"></i>
                    </button>
                </div>
            </div>
            ' data-target=".section_8_conteudo_61-target" data-indice="{{ $indice }}">
  {{ translate('Add New') }}
</button>
</div>
</div> --}}
