@extends('backend.layouts.app')

@section('content')
@if (auth()->user()->can('smtp_settings') &&
        env('MAIL_USERNAME') == null &&
        env('MAIL_PASSWORD') == null)
    <div class="">
        <div class="alert alert-info d-flex align-items-center">
            {{ translate('Por favor, configure a configuração SMTP para funcionar com todas as funcionalidades de envio de e-mail') }},
            <a class="alert-link ml-2" href="{{ route('smtp_settings.index') }}">{{ translate('Configurar agora') }}</a>
        </div>
    </div>
@endif
<div class="aiz-titlebar text-left mt-2 mb-3">
	<div class="row align-items-center">
		<div class="col">
			<h1 class="h3">{{ translate('Contate-nos Informações da página') }}</h1>
		</div>
	</div>
</div>
<div class="card">
	<ul class="nav nav-tabs nav-fill language-bar">
		@foreach (get_all_active_language() as $key => $language)
			<li class="nav-item">
				<a class="nav-link text-reset @if ($language->code == $lang) active @endif py-3" href="{{ route('custom-pages.edit', ['id'=>$page->slug, 'lang'=> $language->code] ) }}">
					<img src="{{ static_asset('assets/img/flags/'.$language->code.'.png') }}" height="11" class="mr-1">
					<span>{{$language->name}}</span>
				</a>
			</li>
		@endforeach
	</ul>

	<form class="p-4" action="{{ route('custom-pages.update', $page->id) }}" method="POST" enctype="multipart/form-data">
		@csrf
		<input type="hidden" name="_method" value="PATCH">
		<input type="hidden" name="lang" value="{{ $lang }}">

		<div class="card-header px-0">
			<h6 class="fw-600 mb-0">{{ translate('Conteúdo da página') }}</h6>
		</div>
		<div class="card-body px-0">
			<div class="form-group row">
				<label class="col-sm-2 col-from-label" for="name">{{translate('Título')}} <span class="text-danger">*</span> <i class="las la-language text-danger" title="{{translate('Traduzível')}}"></i></label>
				<div class="col-sm-10">
					<input type="text" class="form-control" placeholder="{{translate('Título')}}" name="title" value="{{ $page->getTranslation('title',$lang) }}" required>
				</div>
			</div>
            <div class="form-group row">
                <label class="col-sm-2 col-from-label" for="slug">{{translate('Link')}} <span class="text-danger">*</span></label>
                <div class="col-sm-10">
                    <div class="input-group d-block d-md-flex">
                        @if($page->type == 'custom_page')
                            <div class="input-group-prepend"><span class="input-group-text flex-grow-1">{{ route('home') }}/</span></div>
                            <input type="text" class="form-control w-100 w-md-auto" placeholder="{{ translate('Slug') }}" name="slug" value="{{ $page->slug }}">
                        @else
                            <input class="form-control w-100 w-md-auto" value="{{ route('home') }}/{{ $page->slug }}" disabled>
                        @endif
                    </div>
                    <small class="form-text text-muted">{{ translate('Use apenas caractere, número e hífen') }}</small>
                </div>
            </div>
            <div class="form-group row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label class="col-form-label">Faq</label>
                        @php
                        $indice = 0;
                        @endphp
                        <input type="hidden" name="types[]" value="content">
                        <div class="content-target">
                            @if(isset($page->content) && $page->content != null && $page->content != 'null')
                            @foreach(json_decode($page->content, true) as $key => $value)
                            <div class="card shadow-lg" style="border: 1px dashed #e4e5eb;">
                                <div class="row card-body">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="col-form-label">Título</label>
                                            <input type="text" class="form-control" name="content[{{ $key }}][titulo]"
                                                value="{{ $value['titulo'] }}">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="col-form-label">Texto corrido</label>
                                            <textarea name="content[{{ $key }}][corrido]" class="form-control" data-min-height="300" cols="30" rows="5">{{ $value['corrido'] }}</textarea>
                                        </div>
                                    </div>
                                    <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                        <i class="las la-times"></i>
                                    </button>
                                </div>
                            </div>
                            @php
                            $indice++;
                            @endphp
                            @endforeach
                            @endif
                        </div>
                        <button type="button" class="btn btn-soft-secondary btn-sm add-new-button add-new-button"
                            data-toggle="add-more"
                            data-content='
                                <div class="card shadow-lg" style="border: 1px dashed #e4e5eb;">
                                    <div class="row card-body">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="col-form-label">Título</label>
                                                <input type="text" class="form-control" name="content[][titulo]">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="col-form-label">Texto corrido</label>
                                                <textarea name="content[][corrido]" class="form-control" data-min-height="300" cols="30" rows="5"></textarea>
                                            </div>
                                        </div>
                                        <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                <i class="las la-times"></i>
                                        </button>
                                    </div>
                                </div>
                                '
                            data-target=".content-target" data-indice="{{ $indice }}">
                            {{ translate('Add New') }}
                        </button>
                    </div>
                </div>
            </div>

		</div>

		<div class="card-header px-0">
			<h6 class="fw-600 mb-0">{{ translate('Campos de SEO') }}</h6>
		</div>
		<div class="card-body px-0">

			<div class="form-group row">
				<label class="col-sm-2 col-from-label" for="meta_title">{{translate('Metatítulo')}}</label>
				<div class="col-sm-10">
					<input type="text" class="form-control" placeholder="{{translate('Título')}}" name="meta_title" value="{{ $page->meta_title }}">
				</div>
			</div>

			<div class="form-group row">
				<label class="col-sm-2 col-from-label" for="meta_description">{{translate('Meta descrição')}}</label>
				<div class="col-sm-10">
					<textarea class="resize-off form-control" placeholder="{{translate('Descrição')}}" name="meta_description">{!! $page->meta_description !!}</textarea>
				</div>
			</div>

			<div class="form-group row">
				<label class="col-sm-2 col-from-label" for="keywords">{{translate('Palavras-chave')}}</label>
				<div class="col-sm-10">
					<textarea class="resize-off form-control" placeholder="{{translate('Palavra-chave, palavra-chave')}}" name="keywords">{!! $page->keywords !!}</textarea>
					<small class="text-muted">{{ translate('Separar com vírgula') }}</small>
				</div>
			</div>

			<div class="form-group row">
				<label class="col-sm-2 col-from-label" for="meta_image">{{translate('Metaimagem')}}</label>
				<div class="col-sm-10">
					<div class="input-group " data-toggle="aizuploader" data-type="image">
							<div class="input-group-prepend">
								<div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate('Navegar') }}</div>
						</div>
						<div class="form-control file-amount">{{ translate('Escolha arquivo') }}</div>
						<input type="hidden" name="meta_image" class="selected-files" value="{{ $page->meta_image }}">
					</div>
					<div class="file-preview">
					</div>
				</div>
			</div>

			<div class="text-right">
				<button type="submit" class="btn btn-primary">{{ translate('Atualizar página') }}</button>
			</div>
		</div>
	</form>
</div>
@endsection
