<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{translate('Integração de gateway de pagamento Instamojo')}}</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.0.0-alpha/css/bootstrap.css" rel="stylesheet">
    <style>
        .mt40{
            margin-top: 40px;
        }
    </style>
</head>
<body>

<div class="container">

<div class="row">
    <div class="col-lg-12 mt40">
        <div class="card-header" style="background: #0275D8;">
            <h2>{{translate('Confirme suas informações por motivos de segurança')}}</h2>
        </div>
    </div>
</div>

@if ($errors->any())
    <div class="alert alert-danger">
        <strong>{{translate('Ops!')}}'</strong> {{translate('Algo deu errado')}}<br>
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<form action="{{ url('pay') }}" method="POST" name="laravel_instamojo">
    {{ csrf_field() }}

     <div class="row">
        <div class="col-md-12">
            <div class="form-group">
                <strong>{{translate('Nome')}}</strong>
                <input type="text" name="name" class="form-control" placeholder="{{ translate('Digite o nome') }}" value="{{$order->user->name}}" required>
            </div>
        </div>
        <div class="col-md-12">
            <div class="form-group">
                <strong>{{translate('Número de telemóvel')}}</strong>
                <input type="text" name="mobile_number" class="form-control" placeholder="{{ translate('Digite o número do celular') }}" value="{{$order->user->phone}}" required>
            </div>
        </div>
        <div class="col-md-12">
            <div class="form-group">
                <strong>{{translate('ID de e-mail')}}</strong>
                <input type="text" name="email" class="form-control" placeholder="{{ translate('Insira o ID do e-mail') }}" value="{{$order->user->email}}" required>
            </div>
        </div>
        <div class="col-md-12">
            <div class="form-group">
                <strong>{{translate('Quantia')}}</strong>
                <input type="text" name="amount" class="form-control" placeholder="{{ translate('Insira o valor') }}" value="{{round($order->grand_total)}}" readonly="">
            </div>
        </div>
        <div class="col-md-12">
                <button type="submit" class="btn btn-primary">{{ translate('Enviar') }}</button>
        </div>
    </div>

</form>
</div>

</body>
</html>
