@extends('frontend.layouts.app')

@section('meta_title'){{ $detailedProduct->meta_title }}@stop

@section('meta_description'){{ $detailedProduct->meta_description }}@stop

@section('meta_keywords'){{ $detailedProduct->tags }}@stop

@section('meta')
    @php
        $availability = "out of stock";
        $qty = 0;
        if($detailedProduct->variant_product) {
            foreach ($detailedProduct->stocks as $key => $stock) {
                $qty += $stock->qty;
            }
        }
        else {
            $qty = optional($detailedProduct->stocks->first())->qty;
        }
        if($qty > 0){
            $availability = "in stock";
        }
    @endphp
    <!-- Schema.org markup for Google+ -->
    <meta itemprop="name" content="{{ $detailedProduct->meta_title }}">
    <meta itemprop="description" content="{{ $detailedProduct->meta_description }}">
    <meta itemprop="image" content="{{ uploaded_asset($detailedProduct->meta_img) }}">

    <!-- Twitter Card data -->
    <meta name="twitter:card" content="product">
    <meta name="twitter:site" content="@publisher_handle">
    <meta name="twitter:title" content="{{ $detailedProduct->meta_title }}">
    <meta name="twitter:description" content="{{ $detailedProduct->meta_description }}">
    <meta name="twitter:creator" content="@author_handle">
    <meta name="twitter:image" content="{{ uploaded_asset($detailedProduct->meta_img) }}">
    <meta name="twitter:data1" content="{{ single_price($detailedProduct->unit_price) }}">
    <meta name="twitter:label1" content="Price">

    <!-- Open Graph data -->
    <meta property="og:title" content="{{ $detailedProduct->meta_title }}" />
    <meta property="og:type" content="og:product" />
    <meta property="og:url" content="{{ route('product', $detailedProduct->slug) }}" />
    <meta property="og:image" content="{{ uploaded_asset($detailedProduct->meta_img) }}" />
    <meta property="og:description" content="{{ $detailedProduct->meta_description }}" />
    <meta property="og:site_name" content="{{ get_setting('meta_title') }}" />
    <meta property="og:price:amount" content="{{ single_price($detailedProduct->unit_price) }}" />
    <meta property="product:brand" content="{{ $detailedProduct->brand ? $detailedProduct->brand->name : env('APP_NAME') }}">
    <meta property="product:availability" content="{{ $availability }}">
    <meta property="product:condition" content="new">
    <meta property="product:price:amount" content="{{ number_format($detailedProduct->unit_price, 2) }}">
    <meta property="product:retailer_item_id" content="{{ $detailedProduct->slug }}">
    <meta property="product:price:currency"
        content="{{ get_system_default_currency()->code }}" />
    <meta property="fb:app_id" content="{{ env('FACEBOOK_PIXEL_ID') }}">
@endsection
@section('style_new')
    <link rel="stylesheet preload" as="style" href="{{ static_asset('garden/css/product2.min.css') }}" />
    <link rel="stylesheet preload" as="style" href="{{ static_asset('garden/css/index2.min.css') }}" />
@endsection

@section('content')
<main>
    <section class="hero section sec">
      <div class="container">
        <div class="hero_content col-xl-6">
          <div class="hero_content-header">
            <h1 class="hero_content-header_title">
              {!! $servico->section_1_conteudo_1 !!}
            </h1>
            <p class="hero_content-header_text">{!! $servico->section_1_conteudo_2 !!}</p>
          </div> <a class="hero_content-btn btn" href="{{ $servico->section_1_link_3 }}" aria-label="{{ $servico->section_1_link_alt_3}}">{{ $servico->section_1_link_conteudo_3}}</a>
          <div class="features-list d-sm-flex flex-wrap">
            <div class="features-list_row d-sm-flex">
              <div class="features-list_item" data-order="1" data-aos="fade-up">
                <div class="wrapper d-flex flex-column flex-sm-row align-items-center"> <span class="icon d-flex align-items-center justify-content-center"> <img src="{{ uploaded_asset($servico->section_1_img_4) }}" class="lazy" alt="{{ $servico->section_1_image_alt_4}}" loading="lazy"> </span>
                  <h5 class="title">{!! $servico->section_1_conteudo_5 !!}</h5>
                </div>
              </div>
              <div class="features-list_item" data-order="2" data-aos="fade-up">
                <div class="wrapper d-flex flex-column flex-sm-row align-items-center"> <span class="icon d-flex align-items-center justify-content-center"> <img src="{{ uploaded_asset($servico->section_1_img_6) }}" class="lazy" alt="{{ $servico->section_1_image_alt_6}}" loading="lazy"> </span>
                  <h5 class="title">{!! $servico->section_1_conteudo_7 !!}</h5>
                </div>
              </div>
            </div>
            <div class="features-list_row d-sm-flex">
              <div class="features-list_item" data-order="3" data-aos="fade-up">
                <div class="wrapper d-flex flex-column flex-sm-row align-items-center"> <span class="icon d-flex align-items-center justify-content-center"> <img src="{{ uploaded_asset($servico->section_1_img_8) }}" class="lazy" alt="{{ $servico->section_1_image_alt_8}}" loading="lazy"> </span>
                  <h5 class="title">{!! $servico->section_1_conteudo_9 !!}</h5>
                </div>
              </div>
              <div class="features-list_item" data-order="4" data-aos="fade-up">
                <div class="wrapper d-flex flex-column flex-sm-row align-items-center"> <span class="icon d-flex align-items-center justify-content-center"><img src="{{ uploaded_asset($servico->section_1_img_11) }}" class="lazy" alt="{{ $servico->section_1_image_alt_11 }}" loading="lazy"></span>
                  <h5 class="title">{!! $servico->section_1_conteudo_12 !!}</h5>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="hero_media">
        <picture>
          <source data-srcset="{{ $servico->section_1_image_alt_13}}" srcset="{{ $servico->section_1_image_alt_13}}" type="image/webp" /> <img class="lazy hero_media-leaf  lazy" data-src="{{ uploaded_asset($servico->section_1_img_13) }}" src="{{ uploaded_asset($servico->section_1_img_13) }}" alt="{{ $servico->section_1_image_alt_13}}" loading="lazy" />
        </picture>
      </div>
    </section>
    <div class="categories section--nopb sec">
      <div class="container">
        <ul class="categories_list d-flex flex-wrap">
          <li class="categories_list-item col-6 col-md-4 col-xl-2" data-order="1"> <a class="categories_list-item_wrapper" href="#">
              <div class="media"> <span class="overlay d-flex flex-column justify-content-end"> <span class="overlay_content">{!! $servico->section_2_conteudo_14 !!}</span> </span>
                <picture>
                  <source data-srcset="{{ uploaded_asset($servico->section_2_img_15) }}" srcset="{{ uploaded_asset($servico->section_2_img_15) }}" type="image/webp" /> <img class="lazy  lazy" data-src="{{ uploaded_asset($servico->section_2_img_15) }}" src="{{ uploaded_asset($servico->section_2_img_15) }}" alt="{{ $servico->section_2_image_alt_15}}" loading="lazy" />
                </picture>
              </div>
              <h4 class="title">{!! $servico->section_2_conteudo_16 !!}</h4>
            </a> </li>
          <li class="categories_list-item col-6 col-md-4 col-xl-2" data-order="2"> <a class="categories_list-item_wrapper" href="#">
              <div class="media"> <span class="overlay d-flex flex-column justify-content-end"> <span class="overlay_content">{!! $servico->section_2_conteudo_17 !!}</span> </span>
                <picture>
                  <source data-srcset="{{ uploaded_asset($servico->section_2_img_18) }}" srcset="{{ uploaded_asset($servico->section_2_img_18) }}" type="image/webp" /> <img class="lazy  lazy" data-src="{{ uploaded_asset($servico->section_2_img_18) }}" src="{{ uploaded_asset($servico->section_2_img_18) }}" alt="{{ $servico->section_2_image_alt_18}}" loading="lazy" />
                </picture>
              </div>
              <h4 class="title">{!! $servico->section_2_conteudo_19 !!}</h4>
            </a> </li>
          <li class="categories_list-item col-6 col-md-4 col-xl-2" data-order="3"> <a class="categories_list-item_wrapper" href="#">
              <div class="media"> <span class="overlay d-flex flex-column justify-content-end"> <span class="overlay_content">{!! $servico->section_2_conteudo_20 !!}</span> </span>
                <picture>
                  <source data-srcset="{{ uploaded_asset($servico->section_2_img_21) }}" srcset="{{ uploaded_asset($servico->section_2_img_21) }}" type="image/webp" /> <img class="lazy  lazy" data-src="{{ uploaded_asset($servico->section_2_img_21) }}" src="{{ uploaded_asset($servico->section_2_img_21) }}" alt="{{ $servico->section_2_image_alt_21}}" loading="lazy" />
                </picture>
              </div>
              <h4 class="title">{!! $servico->section_2_conteudo_22 !!}</h4>
            </a> </li>
          <li class="categories_list-item col-6 col-md-4 col-xl-2" data-order="4"> <a class="categories_list-item_wrapper" href="#">
              <div class="media"> <span class="overlay d-flex flex-column justify-content-end"> <span class="overlay_content">{!! $servico->section_2_conteudo_23 !!}</span> </span>
                <picture>
                  <source data-srcset="{{ uploaded_asset($servico->section_2_img_24) }}" srcset="{{ uploaded_asset($servico->section_2_img_24) }}" type="image/webp" /> <img class="lazy  lazy" data-src="{{ uploaded_asset($servico->section_2_img_24) }}" src="{{ uploaded_asset($servico->section_2_img_24) }}" alt="{{ $servico->section_2_image_alt_24}}" loading="lazy" />
                </picture>
              </div>
              <h4 class="title">{!! $servico->section_2_conteudo_25 !!}</h4>
            </a> </li>
          <li class="categories_list-item col-6 col-md-4 col-xl-2" data-order="5"> <a class="categories_list-item_wrapper" href="#">
              <div class="media"> <span class="overlay d-flex flex-column justify-content-end"> <span class="overlay_content">{!! $servico->section_2_conteudo_26 !!}</span> </span>
                <picture>
                  <source data-srcset="{{ uploaded_asset($servico->section_2_img_27) }}" srcset="{{ uploaded_asset($servico->section_2_img_27) }}" type="image/webp" /> <img class="lazy  lazy" data-src="{{ uploaded_asset($servico->section_2_img_27) }}" src="{{ uploaded_asset($servico->section_2_img_27) }}" alt="{{ $servico->section_2_image_alt_27}}" loading="lazy" />
                </picture>
              </div>
              <h4 class="title">{!! $servico->section_2_conteudo_28 !!}</h4>
            </a> </li>
          <li class="categories_list-item col-6 col-md-4 col-xl-2" data-order="6"> <a class="categories_list-item_wrapper" href="#">
              <div class="media"> <span class="overlay d-flex flex-column justify-content-end"> <span class="overlay_content">{!! $servico->section_2_conteudo_29 !!}</span> </span>
                <picture>
                  <source data-srcset="{{ uploaded_asset($servico->section_2_img_30) }}" srcset="{{ uploaded_asset($servico->section_2_img_30) }}" type="image/webp" /> <img class="lazy  lazy" data-src="{{ uploaded_asset($servico->section_2_img_30) }}" src="{{ uploaded_asset($servico->section_2_img_30) }}" alt="{{ $servico->section_2_image_alt_30}}" loading="lazy" />
                </picture>
              </div>
              <h4 class="title">{!! $servico->section_2_conteudo_31 !!}</h4>
            </a> </li>
        </ul>
      </div>
    </div>
    <div class="promo">
            <div class="promo_fluid d-lg-flex align-items-center align-items-xxl-end">
                <div class="wrapper section--nopb col-lg-6 col-xxl-auto">
                    <div class="promo_header">
                        <a class="promo_header-title" rel="noopener norefferer">{!! $servico->section_3_conteudo_32 !!}</a>
                        {!! $servico->section_3_textarea_33 !!}
                    </div>
                    <a class="promo_btn btn" href="{{ $servico->section_3_link_34 }}" aria-label="{{ $servico->section_3_link_alt_34}}">{{ $servico->section_3_link_conteudo_34}}</a>
                </div>
                <div class="media">
                    <picture>
                        <source data-srcset="{{ uploaded_asset($servico->section_3_img_35) }}" srcset="{{ uploaded_asset($servico->section_3_img_35) }}" type="image/webp" /> 
                        <img class="lazy  lazy" data-src="{{ uploaded_asset($servico->section_3_img_35) }}" src="{{ uploaded_asset($servico->section_3_img_35) }}" alt="{{ $servico->section_3_image_alt_35}}" loading="lazy" />
                    </picture>
                </div>
            </div>
        </div>
    <section class="reviews section--nopb sec" style="overflow:hidden">
  <div class="container">
    <div class="reviews_header">
      <h2 class="reviews_header-title">{!! $servico->section_4_conteudo_36 !!}</h2>
      <p class="reviews_header-text">{!! $servico->section_4_conteudo_37 !!}</p>
    </div>
    <div class="reviews_slider swiper">
      <div class="swiper-wrapper">
        @if (isset($servico->section_4_conteudo_38))
            @foreach (json_decode($servico->section_4_conteudo_38, true) as $key => $value)
                <div class="reviews_slider-slide swiper-slide">
                  <div class="reviews_slider-slide_wrapper d-flex flex-column align-items-center">
                    <picture>
                      <source data-srcset="{{ uploaded_asset($value['imagem']) }}"
                        srcset="{{ uploaded_asset($value['imagem']) }}" type="image/webp" />
                      <img class="lazy avatar" data-src="{{ uploaded_asset($value['imagem']) }}"
                        src="{{ uploaded_asset($value['imagem']) }}" alt="avatar" />
                    </picture>
                    <ul class="rating d-flex align-items-center accent">
                      <li class="rating_star"> <i class="icon-star_fill" style="color: #efc368;"></i> </li>
                      <li class="rating_star"> <i class="icon-star_fill" style="color: #efc368;"></i> </li>
                      <li class="rating_star"> <i class="icon-star_fill" style="color: #efc368;"></i> </li>
                      <li class="rating_star"> <i class="icon-star_fill" style="color: #efc368;"></i> </li>
                      <li class="rating_star"> <i class="icon-star_fill" style="color: #efc368;"></i> </li>
                    </ul>
                    <p class="text">{{ $value['corrido'] }}</p>
                    <h5 class="name">{{ $value['autor'] }}</h5>
                  </div>
                </div>
            @endforeach
        @endif
      </div>
      <div class="swiper-pagination swiper-pagination--dots"></div>
    </div>
  </div>
  <div class="reviews_underlay"> <span class="reviews_underlay-circle reviews_underlay-circle--green"></span> <span
      class="reviews_underlay-circle reviews_underlay-circle--yellow"></span> </div>
</section>
    <section class="faq section--nopb sec">
      <div class="container d-flex flex-column-reverse flex-xl-row">
        <div class="faq_main col-xl-6">
          <div class="faq_main-header">
            <h2 class="faq_main-header_title">{!! $servico->section_5_conteudo_39 !!}</h2>
            <p class="faq_main-header_text">{!! $servico->section_5_conteudo_40 !!}</p>
          </div>
          <div class="accordion">
            <div class="accordion_component" id="accordionComponent">
              <div class="accordion_component" id="accordionComponent">
  <div class="accordion_component-item">
    <h4 class="accordion_component-item_header d-flex justify-content-between align-items-center collapsed" data-bs-toggle="collapse" data-bs-target="#item-1"> Reduz Inflamação e Alivia a Dor <span class="wrapper"> <i class="icon-caret_down icon"></i> </span> </h4>
    <div id="item-1" class="accordion-collapse collapse" data-bs-parent="#accordionComponent">
      <div class="accordion_component-item_body"> A própolis vermelha possui propriedades anti-inflamatórias que ajudam a reduzir inflamações no corpo, aliviando dores e desconfortos associados. Isso a torna uma opção valiosa para pessoas com condições inflamatórias crônicas. </div>
    </div>
  </div>
  <div class="accordion_component-item">
    <h4 class="accordion_component-item_header d-flex justify-content-between align-items-center" data-bs-toggle="collapse" data-bs-target="#item-2"> Combate Células Cancerígenas e Retarda o Crescimento de Tumores <span class="wrapper"> <i class="icon-caret_down transform icon"></i> </span> </h4>
    <div id="item-2" class="accordion-collapse collapse show" data-bs-parent="#accordionComponent">
      <div class="accordion_component-item_body"> Estudos mostram que a própolis vermelha pode ajudar a inibir o crescimento de células cancerígenas e retardar a progressão de tumores, devido às suas propriedades antioxidantes e imunomoduladoras. </div>
    </div>
  </div>
  <div class="accordion_component-item">
    <h4 class="accordion_component-item_header d-flex justify-content-between align-items-center collapsed" data-bs-toggle="collapse" data-bs-target="#item-3"> Relaxa Músculos Tensionados em Pessoas com Esclerose Múltipla <span class="wrapper"> <i class="icon-caret_down icon"></i> </span> </h4>
    <div id="item-3" class="accordion-collapse collapse" data-bs-parent="#accordionComponent">
      <div class="accordion_component-item_body"> A própolis vermelha pode ajudar a relaxar músculos tensionados, proporcionando alívio para pessoas que sofrem de esclerose múltipla, melhorando a qualidade de vida e o bem-estar geral. </div>
    </div>
  </div>
  <div class="accordion_component-item">
    <h4 class="accordion_component-item_header d-flex justify-content-between align-items-center collapsed" data-bs-toggle="collapse" data-bs-target="#item-4"> Estimula o Apetite e Melhora o Peso <span class="wrapper"> <i class="icon-caret_down icon"></i> </span> </h4>
    <div id="item-4" class="accordion-collapse collapse" data-bs-parent="#accordionComponent">
      <div class="accordion_component-item_body"> A própolis vermelha pode ajudar a estimular o apetite, sendo benéfica para pessoas que estão em recuperação de doenças ou que precisam ganhar peso, contribuindo para uma alimentação mais equilibrada e saudável. </div>
    </div>
  </div>
</div>

            </div>
          </div>
        </div>
        <div class="faq_media">
          <picture>
            <source data-srcset="{{ uploaded_asset($servico->section_5_img_38) }}" srcset="{{ uploaded_asset($servico->section_5_img_38) }}" type="image/webp" /> <img class="lazy  lazy" data-src="{{ uploaded_asset($servico->section_5_img_38) }}" src="{{ uploaded_asset($servico->section_5_img_38) }}" alt="{{ $servico->section_5_image_alt_38}}" loading="lazy" />
          </picture>
        </div>
      </div>
    </section>
    <section class="about section--nopb">
        <div class="container">
            <!-- Product main -->
            <div class="about_main d-md-flex flex-nowrap justify-content-between align-items-start">
                <div class="about_main-slider about_main-slider--destroy">
                    <div class="swiper-wrapper">
                        @php
                            $photos = [];
                        @endphp
                        @if ($detailedProduct->photos != null)
                            @php
                                $photos = explode(',', $detailedProduct->photos);
                            @endphp
                        @endif
                        @foreach ($photos as $key => $photo)
                            <div class="swiper-slide">
                                <a href="{{ uploaded_asset($photo) }}" data-role="gallery">
                                    <picture>
                                        <source data-srcset="{{ uploaded_asset($photo) }}" srcset="{{ uploaded_asset($photo) }}" type="image/webp"/>
                                        <img class="lazy" data-src="{{ uploaded_asset($photo) }}" src="{{ uploaded_asset($photo) }}" alt="media"/>
                                    </picture>
                                </a>
                            </div>
                        @endforeach
                    </div>
                    <div class="swiper-controls d-flex d-md-none align-items-center justify-content-between">
                        <a class="swiper-button-prev d-inline-flex align-items-center justify-content-center" href="#">
                            <i class="icon-caret_left icon"></i>
                        </a>
                        <a class="swiper-button-next d-inline-flex align-items-center justify-content-center" href="#">
                            <i class="icon-caret_right icon"></i>
                        </a>
                    </div>
                </div>
                    
                    <div class="about_wrapper" style="position: sticky;top: 100px;">
                        <div class="about_main-info">
                            <div class="about_main-info_product d-sm-flex flex-md-column flex-xl-row align-items-center align-items-md-start align-items-xl-center justify-content-between">
                                <h2 class="title">{{ $detailedProduct->getTranslation('name') }}</h2>
                                <div class="action d-flex">
                                    <a class="action_link d-flex align-items-center justify-content-center" href="javascript:void(0)" onclick="addToWishList({{ $detailedProduct->id }})" data-role="wishlist">
                                        <i class="icon-heart"></i>
                                    </a>
                                    <a class="action_link d-flex align-items-center justify-content-center" href="javascript:void(0)" onclick="addToCompare({{ $detailedProduct->id }})" data-trigger="compare">
                                        <i class="icon-compare"></i>
                                    </a>
                                </div>
                            </div>
                            <div class="about_main-info_rating d-flex align-items-center">
                                <ul class="stars d-flex align-items-center accent">
                                    <li class="stars_star">
                                        <i class="icon-star_fill"></i>
                                    </li>
                                    <li class="stars_star">
                                        <i class="icon-star_fill"></i>
                                    </li>
                                    <li class="stars_star">
                                        <i class="icon-star_fill"></i>
                                    </li>
                                    <li class="stars_star">
                                        <i class="icon-star_fill"></i>
                                    </li>
                                    <li class="stars_star">
                                        <i class="icon-star_fill"></i>
                                    </li>
                                </ul>
                                @php
                                    $total = 0;
                                    $total += $detailedProduct->reviews->count();
                                @endphp
                                <a class="reviews-amount" href="#reviews">({{ $total }} {{ translate('comentários') }})</a>
                            </div>
                            <form id="option-choice-form">
                            @csrf
                            <input type="hidden" name="id" value="{{ $detailedProduct->id }}">
                            @if ($detailedProduct->choice_options != null)
                                @foreach (json_decode($detailedProduct->choice_options) as $key => $choice)
                                    <div class="about_main-info_block d-flex flex-column flex-sm-row flex-md-column flex-xl-row align-items-sm-center align-items-md-start align-items-xl-center">
                                        <h5 class="title">{{ get_single_attribute_name($choice->attribute_id) }}</h5>
                                        <ul class="weight-list list d-flex flex-wrap">
                                            @foreach ($choice->values as $key => $value)
                                            <li class="list-item">
                                                <input type="radio" id="weight1" name="attribute_id_{{ $choice->attribute_id }}" value="{{ $value }}" @if ($key == 0) checked @endif/>
                                                <label for="weight1">{{ $value }}</label>
                                            </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endforeach
                            @endif
                            <div class="about_main-info_block d-flex flex-column flex-sm-row flex-md-column flex-xl-row align-items-sm-center align-items-md-start align-items-xl-center">
                                <h5 class="title">Quantidade</h5>
                                <div class="qty d-flex align-items-center justify-content-between">
                                    <span class="qty_minus control disabled d-flex align-items-center">
                                        <i class="icon-minus"></i>
                                    </span>
                                    <input type="number" name="quantity" class="qty_amount input-number" placeholder="1" value="{{ $detailedProduct->min_qty }}" min="{{ $detailedProduct->min_qty }}" max="10" lang="en">
                                    <span class="qty_plus control d-flex align-items-center">
                                        <i class="icon-plus"></i>
                                    </span>
                                </div>
                            </div>
                            </form>
                            <div class="d-flex align-items-center">
                                <span class="about_main-info_price">{{ single_price($detailedProduct->unit_price) }}</span>
                                <button class="btn" onclick="addToCart()">Comprar</button>
                            </div>
                            <div class="about_main-info_list d-sm-flex flex-md-column flex-xl-row justify-content-between">
                            </div>
                        </div>
                        <div class="about_secondary ">
                            <div class="about_secondary-content">
                                <div class="about_secondary-content_tabs tab-content" id="productTabs" data-scroll="true">
                                    <div class="wrapper">
                                        <h4 class="accordion_component-item_header d-flex justify-content-between align-items-center" data-bs-toggle="collapse" data-bs-target="#description" aria-expanded="true" id="description-tab">
                                            Descrição
                                            <i class="icon-caret_down transform icon"></i>
                                        </h4>
                                        <div class="tab-pane collapse show active" id="description" role="tabpanel" aria-labelledby="description-tab" data-bs-parent="#productTabs">
                                            {!! $detailedProduct->description !!}
                                        </div>
                                    </div>
                                    <div class="wrapper d-none">
                                        <h4
                                            class="accordion_component-item_header d-flex justify-content-between align-items-center"
                                            data-bs-toggle="collapse"
                                            data-bs-target="#additionalInfo"
                                            id="additional-tab"
                                        >
                                            Informações Adicionais
                                            <i class="icon-caret_down icon"></i>
                                        </h4>
                                        <div
                                            class="tab-pane collapse"
                                            id="additionalInfo"
                                            role="tabpanel"
                                            aria-labelledby="additional-tab"
                                            data-bs-parent="#productTabs"
                                        >
                                            <table class="table d-flex flex-column">
                                                <tbody>
                                                    <tr class="table_row d-flex flex-column flex-lg-row">
                                                        <th class="table_row-header">Ingredients:</th>
                                                        <td class="table_row-cell">Organic MCT Oil, CBD Isolate</td>
                                                    </tr>
                                                    <tr class="table_row d-flex flex-column flex-lg-row">
                                                        <th class="table_row-header">Flavors:</th>
                                                        <td class="table_row-cell">
                                                            Natural 1500mg, Calm 750mg, Focus 750mg, Energize 750mg, Sleep 750mg,
                                                            Recover 750mg
                                                        </td>
                                                    </tr>
                                                    <tr class="table_row d-flex flex-column flex-lg-row">
                                                        <th class="table_row-header">Recommended Usage:</th>
                                                        <td class="table_row-cell">
                                                            Once a day, place a full dropper under your tongue and hold for a minute.
                                                            Repeat as necessary
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                
            </div>
        </div>
    </section>
</main>

@endsection

@section('modal')
    <!-- Image Modal -->
    <div class="modal fade" id="image_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-zoom product-modal" id="modal-size" role="document">
            <div class="modal-content position-relative">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="p-4">
                    <div class="size-300px size-lg-450px">
                        <img class="img-fit h-100 lazyload"
                            src="{{ static_asset('assets/img/placeholder.jpg') }}"
                            data-src=""
                            onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Chat Modal -->
    <div class="modal fade" id="chat_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-zoom product-modal" id="modal-size" role="document">
            <div class="modal-content position-relative">
                <div class="modal-header">
                    <h5 class="modal-title fw-600 h5">{{ translate('Qualquer dúvida sobre este produto') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form class="" action="{{ route('conversations.store') }}" method="POST"
                    enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="product_id" value="{{ $detailedProduct->id }}">
                    <div class="modal-body gry-bg px-3 pt-3">
                        <div class="form-group">
                            <input type="text" class="form-control mb-3 rounded-0" name="title"
                                value="{{ $detailedProduct->name }}" placeholder="{{ translate('Nome do produto') }}"
                                required>
                        </div>
                        <div class="form-group">
                            <textarea class="form-control rounded-0" rows="8" name="message" required
                                placeholder="{{ translate('Sua pergunta') }}">{{ route('product', $detailedProduct->slug) }}</textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary fw-600 rounded-0"
                            data-dismiss="modal">{{ translate('Cancelar') }}</button>
                        <button type="submit" class="btn btn-primary fw-600 rounded-0 w-100px">{{ translate('Enviar') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Bid Modal -->
    @if($detailedProduct->auction_product == 1)
        @php 
            $highest_bid = $detailedProduct->bids->max('amount');
            $min_bid_amount = $highest_bid != null ? $highest_bid+1 : $detailedProduct->starting_bid; 
        @endphp
        <div class="modal fade" id="bid_for_detail_product" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">{{ translate('Lance para produto') }} <small>({{ translate('Valor mínimo do lance:').$min_bid_amount }})</small> </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        </button>
                    </div>
                    <div class="modal-body">
                        <form class="form-horizontal" action="{{ route('auction_product_bids.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="product_id" value="{{ $detailedProduct->id }}">
                            <div class="form-group">
                                <label class="form-label">
                                    {{translate('Colocar preço do lance')}}
                                    <span class="text-danger">*</span>
                                </label>
                                <div class="form-group">
                                    <input type="number" step="0.01" class="form-control form-control-sm" name="amount" min="{{ $min_bid_amount }}" placeholder="{{ translate('Insira o valor') }}" required>
                                </div>
                            </div>
                            <div class="form-group text-right">
                                <button type="submit" class="btn btn-sm btn-primary transition-3d-hover mr-1">{{ translate('Enviar') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif
    
    <div class="modal fade" id="product-review-modal">
        <div class="modal-dialog">
            <div class="modal-content" id="product-review-modal-content">

            </div>
        </div>
    </div>
    @include('modals.size_chart_show_modal')
@endsection
@section('script_new')
    <script src="{{ static_asset('garden/js/shop.min.js') }}"></script>
@endsection
@section('script')
    <script type="text/javascript">
        $(document).ready(function() {
            getVariantPrice();
        });

        function CopyToClipboard(e) {
            var url = $(e).data('url');
            var $temp = $("<input>");
            $("body").append($temp);
            $temp.val(url).select();
            try {
                document.execCommand("copy");
                AIZ.plugins.notify('success', '{{ translate('Link copiado para a área de transferência') }}');
            } catch (err) {
                AIZ.plugins.notify('danger', '{{ translate('Ops, não é possível copiar') }}');
            }
            $temp.remove();
            // if (document.selection) {
            //     var range = document.body.createTextRange();
            //     range.moveToElementText(document.getElementById(containerid));
            //     range.select().createTextRange();
            //     document.execCommand("Copy");

            // } else if (window.getSelection) {
            //     var range = document.createRange();
            //     document.getElementById(containerid).style.display = "block";
            //     range.selectNode(document.getElementById(containerid));
            //     window.getSelection().addRange(range);
            //     document.execCommand("Copy");
            //     document.getElementById(containerid).style.display = "none";

            // }
            // AIZ.plugins.notify('success', 'Copied');
        }

        function show_chat_modal() {
            @if (Auth::check())
                $('#chat_modal').modal('show');
            @else
                $('#login_modal').modal('show');
            @endif
        }

        // Pagination using ajax
        $(window).on('hashchange', function() {
            if(window.history.pushState) {
                window.history.pushState('', '/', window.location.pathname);
            } else {
                window.location.hash = '';
            }
        });

        $(document).ready(function() {
            $(document).on('click', '.product-queries-pagination .pagination a', function(e) {
                getPaginateData($(this).attr('href').split('page=')[1], 'query', 'queries-area');
                e.preventDefault();
            });
        });

        $(document).ready(function() {
            $(document).on('click', '.product-reviews-pagination .pagination a', function(e) {
                getPaginateData($(this).attr('href').split('page=')[1], 'review', 'reviews-area');
                e.preventDefault();
            });
        });

        function getPaginateData(page, type, section) {
            $.ajax({
                url: '?page=' + page,
                dataType: 'json',
                data: {type: type},
            }).done(function(data) {
                $('.'+section).html(data);
                location.hash = page;
            }).fail(function() {
                alert('Something went worng! Data could not be loaded.');
            });
        }
        // Pagination end

        function showImage(photo) {
            $('#image_modal img').attr('src', photo);
            $('#image_modal img').attr('data-src', photo);
            $('#image_modal').modal('show');
        }

        function bid_modal(){
            @if (isCustomer() || isSeller())
                $('#bid_for_detail_product').modal('show');
          	@elseif (isAdmin())
                AIZ.plugins.notify('warning', '{{ translate("Sorry, Only customers & Sellers can Bid.") }}');
            @else
                $('#login_modal').modal('show');
            @endif
        }

        function product_review(product_id) {
            @if (isCustomer())
                @if ($review_status == 1)
                    $.post('{{ route('product_review_modal') }}', {
                        _token: '{{ @csrf_token() }}',
                        product_id: product_id
                    }, function(data) {
                        $('#product-review-modal-content').html(data);
                        $('#product-review-modal').modal('show', {
                            backdrop: 'static'
                        });
                        AIZ.extra.inputRating();
                    });
                @else
                    AIZ.plugins.notify('warning', '{{ translate("Sorry, You need to buy this product to give review.") }}');
                @endif
            @elseif (Auth::check() && !isCustomer())
                AIZ.plugins.notify('warning', '{{ translate("Sorry, Only customers can give review.") }}');
            @else
                $('#login_modal').modal('show');
            @endif
        }

        function showSizeChartDetail(id, name){
            $('#size-chart-show-modal .modal-title').html('');
            $('#size-chart-show-modal .modal-body').html('');
            if (id == 0) {
                AIZ.plugins.notify('warning', '{{ translate("Sorry, There is no size guide found for this product.") }}');
                return false;
            }
            $.ajax({
                type: "GET",
                url: "{{ route('size-charts-show', '') }}/"+id,
                data: {},
                success: function(data) {
                    $('#size-chart-show-modal .modal-title').html(name);
                    $('#size-chart-show-modal .modal-body').html(data);
                    $('#size-chart-show-modal').modal('show');
                }
            });
        }
    </script>
@endsection
