@extends('frontend.layouts.app')

@section('meta_title'){{ $home->meta_title ?? '' }}@stop

@section('meta_description'){{ $home->meta_description ?? '' }}@stop

@section('meta_keywords'){{ $home->meta_keywords ?? '' }}@stop

@section('style')
@endsection
@section('content')
<style>
    #map {
        height: 70vh;
        border-radius: 25px;
    }

    .map-container {
        margin: 45px;
    }

    .popup {
        position: absolute;
        top: 44%;
        left: 20%;
        width: 450px;
        min-height: 500px;
        transform: translate(-50%, -50%);
        background: white;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        z-index: 3;
        overflow: hidden;
        border-radius: 20px;
        display: flex;
        flex-direction: column;
    }

    .popup-content {
        position: relative;
        text-align: center;
        padding: 1rem;
        text-align: start;
    }

    .popup-content img {
        max-width: 100%;
        height: auto;
        margin: 10px 0;
    }

    #popup-title {
        font-size: 30px;
    }

    #popup-image {
        height: 170px;
        width: 100%;
        object-fit: cover;
    }

    .close-popup {
        position: absolute !important;
        top: 0;
        right: 0;
        background: none;
        border: none;
        font-size: 20px;
        cursor: pointer;
    }

    #custom-popup {
        display: none;
    }

    .box-resultado_btns {
        display: flex;
        align-items: center;
        column-gap: 8px;
        margin-bottom: 1rem;
    }

    .btn.azul {
        border: 2px solid #0045b5;
        color: #ffffff;
    }

    .mapa-container .box-resultado_btns .btn {
        width: 100%;
        flex: 1;
    }

    .btn.azul:hover,
    .btn.azul:focus {
        background-color: #003282;
        color: #ffffff;
    }

    .btn {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        column-gap: 10px;
        padding: 0 20px;
        height: 40px;
        text-align: center;
        font-size: 14px;
        font-weight: 500;
        border-radius: 5px;
        transition: all ease .4s;
        background-color: #004c9e;
        width: 100%;
    }

    .btn.outline {
        background-color: rgba(0, 0, 0, 0);
        color: #1d1e1e;
        border: 2px solid #1d1e1e;
    }

    .box-resultado_combustiveis_item {
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 0;
        width: 110px;
        height: 64px;
        text-align: center;
        font-size: 14px;
        line-height: 16.41px;
        font-weight: 700;
        border: 1px solid #F4F4F5;
        border-radius: 8px;
        margin: 5px !important;
    }

    .d-flex {
        display: flex;
    }

    .name_line {
        display: flex;
        margin-bottom: 1rem;
        border-bottom: 1px solid #f4f4f4;
        width: 100%;
        position: relative;
    }

    .name_line::before {
        content: '';
        width: 18%;
        height: 1px;
        background-color: #004c9e;
        position: absolute;
        bottom: -1px;
    }

    @media only screen and (max-width: 992px) {
        .footer-wrapper {
            margin: 0;
        }

        .map-container {
            margin: 5px;
        }

        #map {
            border-radius: 0;
        }
    }
</style>
<div class="content-wrapper content-wrapper-remove-top-margin content-wrapper-remove-bottom-margin content-wrapper-sidebar-position-none">
    <div class="row mb-3 custom-padding custom-margin">
        <div class="col-lg-12">
            <h3>
                Encontre o posto de gasolina mais próximo
            </h3>
            <p>Procurando pelo posto de gasolina mais perto de você? Navegue pelo mapa e descubra como chegar no Posto Ipiranga! Abasteça com qualidade e encontre tudo o que você precisa em um só lugar.</p>
        </div>
    </div>
</div>
<div class="col-lg-12 map-container">
    <input id="searchInput" class="controls" type="text" placeholder="Preencha com endereço CEP ou cidade.">
    <div id="map" class="card shadow mt-1 mb-3"></div>
    <div id="custom-popup" class="popup" style="display: none;">
        <button class="close-popup">&times;</button>
        <img id="popup-image" src="" alt="Imagem">
        <div class="popup-content">
            <h3 id="popup-title"></h3>
            <p id="popup-description" style="margin-bottom: 1rem;"></p>
            <div class="list-unstyled box-resultado_combustiveis" style="margin-bottom: 1rem;">
                <div class="name_line">Produtos</div>
                <div class="d-flex">
                    <p class="box-resultado_combustiveis_item">Diesel</p>
                    <p class="box-resultado_combustiveis_item">Gasolina<br>Original</p>
                    <p class="box-resultado_combustiveis_item">Ipimax<br>Gasolina</p>
                    <p class="box-resultado_combustiveis_item">Etanol</p>
                </div>
            </div>
            <div class="box-resultado_btns">
                <a target="_blank" href="tel:+5561999999999" class="btn outline azul d-lg-none"><i class="fas fa-phone-alt"></i>(61) 99999-9999</a>
                <a href="#" id="popup-link" class="btn azul"> <i class="fas fa-compass"></i>Navegar</a>
            </div>
        </div>
    </div>
    @endsection
    @section('script')
    <script>
        const unidades = @json($unidades ?? []);
        console.log(unidades);
        let map;
        let animationInterval;

        function getCookie(name) {
            const value = `; ${document.cookie}`;
            const parts = value.split(`; ${name}=`);
            if (parts.length === 2) return parts.pop().split(';').shift();
        }

        function initialize(id_format = '') {
            let default_longitude = '';
            let default_latitude = '';
            var lat = -15.7920;
            var long = -47.8903;
            map = new google.maps.Map(document.getElementById('map'), {
                center: {
                    lat: lat,
                    lng: long
                },
                zoom: 13,
                styles: [{
                    featureType: 'poi',
                    stylers: [{
                        visibility: 'off'
                    }]
                }]
            });

            let markers = [];
            let activeMarker = null;
            unidades.forEach(function(unidade) {
                var marker = new google.maps.Marker({
                    position: {
                        lat: parseFloat(unidade.delivery_pickup_latitude),
                        lng: parseFloat(unidade.delivery_pickup_longitude)
                    },
                    map: map,
                    title: unidade.map_title,
                    icon: '{{static_asset("assets/img/pin.png")}}'
                });
                markers.push(marker);
                marker.addListener("click", function() {
                    if (activeMarker && activeMarker !== marker) {
                        activeMarker.setIcon('{{static_asset("assets/img/pin.png")}}');
                    }
                    marker.setIcon('{{static_asset("assets/img/pin2.png")}}');
                    activeMarker = marker;
                    document.getElementById("popup-title").textContent = unidade.map_title;
                    document.getElementById("popup-description").textContent = unidade.address || "Sem descrição disponível.";
                    document.getElementById("popup-link").href = unidade.link || "#";
                    fetch('{{route("jaxmim")}}', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                            },
                            body: JSON.stringify({
                                imagem: unidade.imagem
                            })
                        })
                        .then(response => response.json())
                        .then(data => {
                            var imageUrl = data.imageUrl || "default-image.jpg";
                            document.getElementById("popup-image").src = imageUrl;
                            var popup = document.getElementById("custom-popup");
                            popup.style.display = "flex";
                        })
                        .catch(error => {
                            console.error(error);
                        });
                });
            });

            document.querySelector(".close-popup").addEventListener("click", function() {
                document.getElementById("custom-popup").style.display = "none";
                markers.forEach(function(marker) {
                    marker.setIcon('{{static_asset("assets/img/pin.png")}}');
                });
                activeMarker = null;
            });

            var input = document.getElementById(id_format + 'searchInput');
            map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);
            var autocomplete = new google.maps.places.Autocomplete(input);
            autocomplete.bindTo('bounds', map);
            var infowindow = new google.maps.InfoWindow();
            var marker = new google.maps.Marker({
                map: map,
                anchorPoint: new google.maps.Point(0, -29),
                draggable: true,
            });
            google.maps.event.addListener(marker, 'dragend', function(event) {
                infowindow.setContent('Latitude: ' + event.latLng.lat() + '<br>Longitude: ' + event.latLng.lng());
                infowindow.open(map, marker);
            });
            document.querySelectorAll('section[data-lat]').forEach(function(section) {
                section.addEventListener('click', function() {
                    const targetLat = parseFloat(section.getAttribute('data-lat'));
                    const targetLng = parseFloat(section.getAttribute('data-lng'));
                    animateMapTransition({
                        lat: targetLat,
                        lng: targetLng
                    });
                });
            });
        }

        function animateMapTransition(targetPosition) {
            const currentPosition = map.getCenter();
            const steps = 30;
            const interval = 10;
            const stepLat = (targetPosition.lat - currentPosition.lat()) / steps;
            const stepLng = (targetPosition.lng - currentPosition.lng()) / steps;
            let step = 0;
            if (animationInterval) {
                clearInterval(animationInterval);
            }

            animationInterval = setInterval(() => {
                if (step >= steps) {
                    clearInterval(animationInterval);
                    return;
                }

                const newLat = currentPosition.lat() + stepLat * step;
                const newLng = currentPosition.lng() + stepLng * step;

                map.setCenter({
                    lat: newLat,
                    lng: newLng
                });
                step++;
            }, interval);
        }
    </script>

    <script src="https://maps.googleapis.com/maps/api/js?key={{ env('MAP_API_KEY') }}&libraries=places&language=pt-br&callback=initialize" async defer></script>
    @endsection