@extends('frontend.layouts.app-checkout')
@section('style_new')
    <link rel="stylesheet" href="{{ static_asset('steps/assets/libs/twitter-bootstrap-wizard/prettify.css') }}">
    <link href="{{ static_asset('steps/assets/css/bootstrap.css') }}" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <link href="{{ static_asset('steps/assets/css/icons.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ static_asset('steps/assets/css/app.css') }}" id="app-style" rel="stylesheet" type="text/css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
    <script src="https://sdk.mercadopago.com/js/v2"></script>
@endsection
@section('content')
<div id="layout-wrapper">
  <header id="page-topbar">
    <div class="navbar-header">
      <div class="d-flex">
        <div class="navbar-brand-box">
          <a href="{{ route('home') }}" class="logo logo-light">
            <span class="logo">
              <img src="{{ uploaded_asset(get_setting('header_logo')) }}" alt="logo da empresa {{ env('APP_NAME') }}" height="50">
            </span>
          </a>
        </div>
      </div>
    </div>
  </header>
  <div class="main-content">
    <div class="page-content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-lg-8">
            <div class="card">
              <div class="card-body">
                <div id="checkout-nav-pills-wizard" class="twitter-bs-wizard">
                  <ul class="twitter-bs-wizard-nav nav nav-pills nav-justified p-0">
                    <li class="nav-item">
                      <a href="#billing-info" class="nav-link" data-toggle="tab">
                        <span class="step-number">01</span>
                        <span class="step-title">Informações de Faturamento</span>
                      </a>
                    </li>
                    <li class="nav-item">
                      <a href="#billing-info2" class="nav-link" data-toggle="tab">
                        <span class="step-number">02</span>
                        <span class="step-title">Informações de Envio</span>
                      </a>
                    </li>
                    <li class="nav-item">
                      <a href="#payment-info" class="nav-link active" data-toggle="tab">
                        <span class="step-number">03</span>
                        <span class="step-title">Informações de Pagamento</span>
                      </a>
                    </li>
                  </ul>
                  <div class="tab-content twitter-bs-wizard-tab-content">
                    <div class="tab-pane" id="billing-info">
                      <div>
                        <div>
                          <div class="row">
                            <div class="col-lg-12">
                              <div class="mb-4">
                                <label class="form-label" for="billing-name">Nome</label>
                                <input type="text" class="form-control" id="billing-name" placeholder="Insira o nome">
                              </div>
                            </div>
                            <div class="col-lg-12">
                              <div class="mb-4">
                                <label class="form-label" for="billing-email-address">Endereço de
                                  Email</label>
                                <input type="email" class="form-control" id="billing-email-address"
                                  placeholder="Insira o email">
                              </div>
                            </div>
                            <div class="col-lg-12">
                              <div class="mb-4">
                                <label class="form-label" for="billing-phone">Telefone</label>
                                <input type="text" class="form-control" id="billing-phone"
                                  placeholder="Insira o número de telefone">
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="tab-pane" id="billing-info2">
                      <div>
                        <div>
                          <div class="row">
                            <div class="col-lg-12 mb-3">
                              <div class="mb-0">
                                <label class="form-label" for="zip-code">CEP</label>
                                <input type="text" class="form-control" id="zip-code" placeholder="Insira o CEP">
                              </div>
                            </div>
                            <div class="col-lg-4 mb-3">
                              <div class="mb-4 mb-lg-0">
                                <label class="form-label" for="billing-state">Estado</label>
                                <input type="text" class="form-control" id="billing-state"
                                  placeholder="Insira o estado">
                              </div>
                            </div>
                            <div class="col-lg-4 mb-3">
                              <div class="mb-4 mb-lg-0">
                                <label class="form-label" for="billing-city">Cidade</label>
                                <input type="text" class="form-control" id="billing-city" placeholder="Insira a cidade">
                              </div>
                            </div>
                            <div class="col-lg-4 mb-3">
                              <div class="mb-4 mb-lg-0">
                                <label class="form-label" for="billing-complement">Complemento</label>
                                <input type="text" class="form-control" id="billing-complement"
                                  placeholder="Insira o complemento">
                              </div>
                            </div>
                          </div>
                          <div class="mb-4">
                            <label class="form-label" for="billing-address">Endereço</label>
                            <textarea class="form-control" id="billing-address" rows="3"
                              placeholder="Insira o endereço completo"></textarea>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="tab-pane active" id="payment-info">
                      <h5 class="card-title">Informações de Pagamento</h5>
                      <div>
                        <div class="row">
                            <div class="col-lg-4 col-sm-6">
                                <div>
                                    <label class="form-label card-radio-label mb-3">
                                        <input type="radio" name="pay-method" id="pay-methodoption1" class="card-radio-input" checked onchange="togglePaymentFields()">
                                        <span class="card-radio">
                                            <i class="fab fa-cc-mastercard font-size-24 align-middle me-2"></i>
                                            <span>Cartão de Crédito</span>
                                        </span>
                                    </label>
                                </div>
                            </div>
                            <div class="col-lg-4 col-sm-6">
                                <div>
                                    <label class="form-label card-radio-label mb-3">
                                        <input type="radio" name="pay-method" id="pay-methodoption2" class="card-radio-input" onchange="togglePaymentFields()">
                                        <span class="card-radio">
                                            <i class="fab fa-cc-mastercard font-size-24 align-middle me-2"></i>
                                            <span>Cartão de Débito</span>
                                        </span>
                                    </label>
                                </div>
                            </div>
                            <div class="col-lg-4 col-sm-6">
                                <div>
                                    <label class="form-label card-radio-label mb-3">
                                        <input type="radio" name="pay-method" id="pay-methodoption3" class="card-radio-input" onchange="togglePaymentFields()">
                                        <span class="card-radio">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24px" viewBox="0 0 512 512"><path d="M242.4 292.5C247.8 287.1 257.1 287.1 262.5 292.5L339.5 369.5C353.7 383.7 372.6 391.5 392.6 391.5H407.7L310.6 488.6C280.3 518.1 231.1 518.1 200.8 488.6L103.3 391.2H112.6C132.6 391.2 151.5 383.4 165.7 369.2L242.4 292.5zM262.5 218.9C256.1 224.4 247.9 224.5 242.4 218.9L165.7 142.2C151.5 127.1 132.6 120.2 112.6 120.2H103.3L200.7 22.8C231.1-7.6 280.3-7.6 310.6 22.8L407.8 119.9H392.6C372.6 119.9 353.7 127.7 339.5 141.9L262.5 218.9zM112.6 142.7C126.4 142.7 139.1 148.3 149.7 158.1L226.4 234.8C233.6 241.1 243 245.6 252.5 245.6C261.9 245.6 271.3 241.1 278.5 234.8L355.5 157.8C365.3 148.1 378.8 142.5 392.6 142.5H430.3L488.6 200.8C518.9 231.1 518.9 280.3 488.6 310.6L430.3 368.9H392.6C378.8 368.9 365.3 363.3 355.5 353.5L278.5 276.5C264.6 262.6 240.3 262.6 226.4 276.6L149.7 353.2C139.1 363 126.4 368.6 112.6 368.6H80.8L22.8 310.6C-7.6 280.3-7.6 231.1 22.8 200.8L80.8 142.7H112.6z"/></svg>
                                            <span>PIX</span>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div id="cardFields" class="p-4 border">
                            <div class="mb-3">
                                <label class="form-label" for="cardnameInput">Nome no Cartão</label>
                                <input type="text" class="form-control" id="cardnameInput" placeholder="Nome no Cartão" requied>
                            </div>
                        
                            <div class="row">
                                <div class="col-lg-12 col-sm-6 mb-3">
                                    <div class="mb-3 mb-lg-0">
                                        <label class="form-label" for="cardnumberInput">Número do Cartão</label>
                                        <input type="text" class="form-control" id="cardnumberInput" placeholder="0000 0000 0000 0000" requied>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-sm-6">
                                    <div class="mb-3 mb-lg-0">
                                        <label class="form-label" for="expirydateInput">Data de Validade</label>
                                        <input type="text" class="form-control" id="expirydateInput" placeholder="MM/AA" requied>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-sm-6">
                                    <div class="mb-3 mb-lg-0">
                                        <label class="form-label" for="cvvcodeInput">Código CVV</label>
                                        <input type="text" class="form-control" id="cvvcodeInput" placeholder="Digite o Código CVV" requied>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-sm-6">
                                    <label class="form-label" for="installmentsSelect">Quantidade de Parcelas</label>
                                    <select class="form-control" id="installmentsSelect">
                                        <option value="1">1 parcela</option>
                                        <option value="2">2 parcelas</option>
                                        <option value="3">3 parcelas</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div id="pixFields" class="p-4 border" style="display: none;">
                            <div class="method-pix container">
                                <div class="method-notes alert alert-info mb-3">
                                    <p class="important-info font-weight-bold m-0">Informações importantes</p>
                                </div>
                                <div class="method-notes row align-items-center mb-3">
                                    <div class="method-icon col-auto">
                                        <i class="fas fa-qrcode font-size-24 align-middle me-2" style="color:#d1a80c"></i>
                                    </div>
                                    <div class="col">
                                        <p class="info-text m-0">
                                            <b>Finalize sua compra</b> para gerar o código de pagamento. Ele só pode ser usado uma vez.
                                        </p>
                                    </div>
                                </div>
                                <div class="method-notes row align-items-center mb-3">
                                    <div class="method-icon col-auto">
                                        <i class="fas fa-clock font-size-24 align-middle me-2" style="color:#d1a80c"></i>
                                    </div>
                                    <div class="col">
                                        <p class="info-text m-0">
                                            Siga as instruções e pague em até <b>30 minutos</b> para garantir sua compra.
                                        </p>
                                    </div>
                                </div>
                                <div class="method-notes row align-items-center mb-3">
                                    <div class="method-icon col-auto">
                                        <i class="fas fa-shield-alt font-size-24 align-middle me-2" style="color:#d1a80c"></i>
                                    </div>
                                    <div class="col">
                                        <p class="info-text m-0">
                                            O Pix é seguro e rápido. Seu pedido é confirmado poucos minutos depois do pagamento.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <ul class="pager wizard twitter-bs-wizard-pager-link">
                    <li class="previous"><a href="#">Anterior</a></li>
                    <li class="next disabled"><a href="#">Próximo</a></li>
                    <li class="d-none"><a href="#" class="btn btn-success">Complete order</a>
                    </li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
            @php
                $cart_count = count($carts);
                $active_carts = $cart_count > 0 ? $carts->toQuery()->active()->get() : [];
            @endphp
          <div class="col-lg-4">
            <div class="card checkout-order-summary">
              <div class="card-body">
                <div class="p-3 bg-light mb-4">
                  <h5 class="font-size-14 mb-0">Detalhes da compra</h5>
                </div>
                <div class="table-responsive">
                  <table class="table table-centered mb-0 table-nowrap">
                    <thead>
                      <tr>
                        <th class="border-top-0" style="width: 110px;" scope="col">Produto
                        </th>
                        <th class="border-top-0" scope="col">Descrição do Produto</th>
                        <th class="border-top-0" scope="col">Preço</th>
                      </tr>
                    </thead>
                    <tbody>
                        @php
                            $total = 0;
                            $admin_products = array();
                            $seller_products = array();
                            $admin_product_variation = array();
                            $seller_product_variation = array();
                            foreach ($carts as $key => $cartItem){
                                $product = get_single_product($cartItem['product_id']);

                                if($product->added_by == 'admin'){
                                    array_push($admin_products, $cartItem['product_id']);
                                    $admin_product_variation[] = $cartItem['variation'];
                                }
                                else{
                                    $product_ids = array();
                                    if(isset($seller_products[$product->user_id])){
                                        $product_ids = $seller_products[$product->user_id];
                                    }
                                    array_push($product_ids, $cartItem['product_id']);
                                    $seller_products[$product->user_id] = $product_ids;
                                    $seller_product_variation[] = $cartItem['variation'];
                                }
                            }
                        @endphp
                        @if (!empty($admin_products))
                            @foreach ($admin_products as $key => $product_id)
                                @php
                                    $product = get_single_product($product_id);
                                    $cartItem = $carts->toQuery()->where('product_id', $product_id)->first();
                                    $product_stock = $product->stocks->where('variant', $cartItem->variation)->first();
                                    $total = $total + cart_product_price($cartItem, $product, false) * $cartItem->quantity;
                                @endphp
                              <tr>
                                <th scope="row">
                                    <img src="{{ uploaded_asset($product->thumbnail_img) }}" alt="imagem do {{ $product->getTranslation('name')  }}" title="imagem do produto" class="avatar-md"></th>
                                <td>
                                  <h5 class="font-size-14 text-truncate"><a href="#"
                                      class="text-reset">{{ $product->getTranslation('name') }}</a></h5>
                                  <p class="text-muted mb-0">{{ cart_product_price($cartItem, $product, true, false) }} x {{ $cartItem['quantity'] }}</p>
                                </td>
                                <td>{{ single_price(cart_product_price($cartItem, $product, false) * $cartItem->quantity) }}</td>
                              </tr>
                            @endforeach
                        @endif
                      <tr>
                        <td colspan="3">
                          <div class="p-3 rounded" style="background-color:#f4f4f4">
                            <h5 class="font-size-14 mb-0 d-flex" style="justify-content: space-between;color:#d1a80c">
                              <span><i class="fas fa-shipping-fast me-2"></i>
                                Frete</span>
                              <span class="float-end">Grátis</span>

                            </h5>
                          </div>
                        </td>
                      </tr>
                      <tr>
                        <td colspan="2">
                          <h6 class="m-0 text-end">Total:</h6>
                        </td>
                        @php
                            $subtotal = 0;
                            $tax = 0;
                            $shipping = 0;
                            $total = 0;
                        
                            foreach ($carts as $cartItem) {
                                $product = get_single_product($cartItem['product_id']);
                                $quantity = $cartItem['quantity'];
                                $productPrice = cart_product_price($cartItem, $product, false, false);
                                $productTax = cart_product_tax($cartItem, $product, false);
                                $subtotal += $productPrice * $quantity;
                                $tax += $productTax * $quantity;
                                $shipping += $cartItem['shipping_cost'];
                                $product_name_with_choice = $product->getTranslation('name');
                                if ($cartItem['variant'] !== null) {
                                    $product_name_with_choice .= ' - ' . $cartItem['variant'];
                                }
                            }
                            $total = $subtotal + $tax + $shipping;
                            if (Session::has('club_point')) {
                                $total -= Session::get('club_point');
                            }
                            if (!empty($coupon_discount) && $coupon_discount > 0) {
                                $total -= $coupon_discount;
                            }
                        @endphp

                        <td>{{ single_price($total) }}</td>
                      </tr>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
     <style>
        #copyright-hoogli img {
            width: 55px;
            position: absolute;
            margin-left: -4px;
            margin-top: 5px;
        }
    
        @media(max-width:500px) {
            #copyright-hoogli img {
                margin-top: 7px;
            }
        }
    
        #copyright-hoogli a {
            margin-right: 53px;
            margin-left: 4px;
        }
    
        #copyright-hoogli i {
            font-size: 12px;
            color: red;
        }
    
        #copyright-hoogli.container {
            text-align: right;
            font-size: 14px;
            line-height: normal;
        }
    
        #copyright-hoogli .pulse {
            animation: pulse 1s infinite;
        }
    
        #copyright-hoogli .dark {
            color: white;
            line-height: 26px;
        }
    
    
        #copyright-hoogli small {
            font-weight: 400;
            font-family: 'Open Sans';
        }
    
        #copyright-hoogli p {
            margin-bottom: 0px !important;
            text-align: center;
        }
    
        @keyframes pulse {
            0% {
                transform: scale(1);
            }
    
            5% {
                transform: scale(1.25);
            }
    
            20% {
                transform: scale(1);
            }
    
            30% {
                transform: scale(1);
            }
    
            35% {
                transform: scale(1.25);
            }
    
            50% {
                transform: scale(1);
            }
    
            55% {
                transform: scale(1.25);
            }
    
            70% {
                transform: scale(1);
            }
        }
    
        @media only screen and (max-width: 767px) {
            #copyright-hoogli.container {
                text-align: center;
            }
    
            .text-copy {
                text-align: center;
            }
        }
    
        .text-right1 {
            text-align: right;
        }
    
        .text-copy {
            text-align: right;
        }
    </style>
    <footer class="footer" id='copyright-hoogli'>
      <div class="row justify-content-center">
          <div class="col-lg-6">
            <div class="text-sm-end d-none d-sm-block"><p>© 2009 - <?php echo date('Y'); ?> Feito com <i class="fa fa-heart pulse"></i> por<a href="https://www.hoogli.com.br/" arial-label="Link de encaminhamento para o site do desenvolvedor"> <img src="{{ static_asset('assets/img/hoogli_logo.svg') }}" alt="Hoogli" title="Hoogli" style="object-fit: contain;" loading="lazy" class="lazy"></a> Todos os direitos reservados.</p>
            </div>
          </div>
        </div>
    </footer>
  </div>
</div>
@endsection
@section('script_new')
    <script src="{{ static_asset('steps/assets/libs/jquery/jquery.min.js') }}"></script>
    <script src="{{ static_asset('steps/assets/libs/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ static_asset('steps/assets/libs/metismenu/metisMenu.min.js') }}"></script>
    <script src="{{ static_asset('steps/assets/libs/simplebar/simplebar.min.js') }}"></script>
    <script src="{{ static_asset('steps/assets/libs/node-waves/waves.min.js') }}"></script>
    <script src="{{ static_asset('steps/assets/libs/twitter-bootstrap-wizard/jquery.bootstrap.wizard.min.js') }}"></script>
    <script src="{{ static_asset('steps/assets/libs/twitter-bootstrap-wizard/prettify.js') }}"></script>
    <script src="{{ static_asset('steps/assets/js/pages/ecommerce-checkout.init.js') }}"></script>
    <script src="{{ static_asset('steps/assets/js/app.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.qrcode/1.0/jquery.qrcode.min.js"></script>
    <script>
        function togglePaymentFields() {
            const cardFields = document.getElementById('cardFields');
            const pixFields = document.getElementById('pixFields');
            const installmentsSelect = document.getElementById('installmentsSelect').parentElement;
    
            const payMethodOption1 = document.getElementById('pay-methodoption1').checked;
            const payMethodOption2 = document.getElementById('pay-methodoption2').checked;
            const payMethodOption3 = document.getElementById('pay-methodoption3').checked;
    
            if (payMethodOption1) {
                cardFields.style.display = 'block';
                installmentsSelect.style.display = 'block';
                pixFields.style.display = 'none';
            } else if (payMethodOption2) {
                cardFields.style.display = 'block';
                installmentsSelect.style.display = 'none';
                pixFields.style.display = 'none';
            } else if (payMethodOption3) {
                cardFields.style.display = 'none';
                pixFields.style.display = 'block';
            }
        }
    
        togglePaymentFields();
    </script>
@endsection
@section('script')
    <script type="text/javascript">
        function removeFromCartView(e, key) {
            e.preventDefault();
            removeFromCart(key);
        }

        function updateQuantity(key, element) {
            $.post('{{ route('cart.updateQuantity') }}', {
                _token: AIZ.data.csrf,
                id: key,
                quantity: element.value
            }, function(data) {
                updateNavCart(data.nav_cart_view, data.cart_count);
                $('#cart-details').html(data.cart_view);
                AIZ.extra.plusMinus();
            });
        }

        // Cart item selection
        $(document).on("change", ".check-all", function() {
            $('.check-one:checkbox').prop('checked', this.checked);
            updateCartStatus();
        });
        $(document).on("change", ".check-seller", function() {
            var value = this.value;
            $('.check-one-'+value+':checkbox').prop('checked', this.checked);
            updateCartStatus();
        });
        $(document).on("change", ".check-one[name='id[]']", function(e) {
            e.preventDefault();
            updateCartStatus();
        });
        function updateCartStatus() {
            $('.aiz-refresh').addClass('active');
            let product_id = [];
            $(".check-one[name='id[]']:checked").each(function() {
                product_id.push($(this).val());
            });

            $.post('{{ route('cart.updateCartStatus') }}', {
                _token: AIZ.data.csrf,
                product_id: product_id
            }, function(data) {
                $('#cart-details').html(data);
                AIZ.extra.plusMinus();
                $('.aiz-refresh').removeClass('active');
            });
        }

        // coupon apply
        $(document).on("click", "#coupon-apply", function() {
            @if (Auth::check())
                @if(Auth::user()->user_type != 'customer')
                    AIZ.plugins.notify('warning', "{{ translate('Faça login como cliente para aplicar o código do cupom.') }}");
                    return false;
                @endif

                var data = new FormData($('#apply-coupon-form')[0]);
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    method: "POST",
                    url: "{{ route('checkout.apply_coupon_code') }}",
                    data: data,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(data, textStatus, jqXHR) {
                        AIZ.plugins.notify(data.response_message.response, data.response_message.message);
                        $("#cart_summary").html(data.html);
                    }
                });
            @else
                $('#login_modal').modal('show');
            @endif
        });

        // coupon remove
        $(document).on("click", "#coupon-remove", function() {
            @if (Auth::check() && Auth::user()->user_type == 'customer')
                var data = new FormData($('#remove-coupon-form')[0]);
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    method: "POST",
                    url: "{{ route('checkout.remove_coupon_code') }}",
                    data: data,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(data, textStatus, jqXHR) {
                        $("#cart_summary").html(data);
                    }
                });
            @endif
        });

    </script>
@endsection
