<?php

use App\Http\Controllers\AddressController;
use App\Http\Controllers\AizUploadController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\VerificationController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\CartController;
use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\CompareController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\ConversationController;
use App\Http\Controllers\CurrencyController;
use App\Http\Controllers\CustomerPackageController;
use App\Http\Controllers\CustomerProductController;
use App\Http\Controllers\DemoController;
use App\Http\Controllers\FollowSellerController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\MessageController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\Payment\AamarpayController;
use App\Http\Controllers\Payment\AuthorizenetController;
use App\Http\Controllers\Payment\BkashController;
use App\Http\Controllers\Payment\InstamojoController;
use App\Http\Controllers\Payment\IyzicoController;
use App\Http\Controllers\Payment\MercadopagoController;
use App\Http\Controllers\Payment\NagadController;
use App\Http\Controllers\Payment\NgeniusController;
use App\Http\Controllers\Payment\PayhereController;
use App\Http\Controllers\Payment\PaykuController;
use App\Http\Controllers\Payment\PaymobController;
use App\Http\Controllers\Payment\PaypalController;
use App\Http\Controllers\Payment\PaystackController;
use App\Http\Controllers\Payment\RazorpayController;
use App\Http\Controllers\Payment\SslcommerzController;
use App\Http\Controllers\Payment\StripeController;
use App\Http\Controllers\Payment\TapController;
use App\Http\Controllers\Payment\VoguepayController;
use App\Http\Controllers\ProductQueryController;
use App\Http\Controllers\PurchaseHistoryController;
use App\Http\Controllers\ReviewController;
use App\Http\Controllers\SearchController;
use App\Http\Controllers\ShopController;
use App\Http\Controllers\SubscriberController;
use App\Http\Controllers\SupportTicketController;
use App\Http\Controllers\WalletController;
use App\Http\Controllers\WishlistController;
use App\Http\Controllers\SizeChartController;


Route::get('/refresh-csrf', function () {
    return csrf_token();
});

Route::controller(AizUploadController::class)->group(function () {
    Route::post('/aiz-uploader', 'show_uploader');
    Route::post('/aiz-uploader/upload', 'upload');
    Route::get('/aiz-uploader/get-uploaded-files', 'get_uploaded_files');
    Route::post('/aiz-uploader/get_file_by_ids', 'get_preview_files');
    Route::get('/aiz-uploader/download/{id}', 'attachment_download')->name('download_attachment');
});

Route::group(['middleware' => ['prevent-back-history','handle-demo-login']], function () {
    Auth::routes(['verify' => true]);
});

// Login
Route::controller(LoginController::class)->group(function () {
    Route::get('/logout', 'logout');
    Route::get('/social-login/redirect/{provider}', 'redirectToProvider')->name('social.login');
    Route::get('/social-login/{provider}/callback', 'handleProviderCallback')->name('social.callback');
    //Apple Callback
    Route::post('/apple-callback', 'handleAppleCallback');
    Route::get('/account-deletion', 'account_deletion')->name('account_delete');
    Route::get('/handle-demo-login', 'handle_demo_login')->name('handleDemoLogin');
});

Route::controller(VerificationController::class)->group(function () {
    Route::get('/email/resend', 'resend')->name('verification.resend');
    Route::get('/verification-confirmation/{code}', 'verification_confirmation')->name('email.verification.confirmation');
});

Route::controller(HomeController::class)->group(function () {
    Route::get('/email-change/callback', 'email_change_callback')->name('email_change.callback');
    Route::post('/password/reset/email/submit', 'reset_password_with_code')->name('password.update');

    Route::get('/users/login', 'login')->name('user.login')->middleware('handle-demo-login');
    Route::get('/seller/login', 'login')->name('seller.login')->middleware('handle-demo-login');
    Route::get('/deliveryboy/login', 'login')->name('deliveryboy.login')->middleware('handle-demo-login');
    Route::get('/users/registration', 'registration')->name('user.registration')->middleware('handle-demo-login');
    Route::post('/users/login/cart', 'cart_login')->name('cart.login.submit')->middleware('handle-demo-login');

    Route::post('/import-data', 'import_data');

    //Home Page
    Route::get('/', 'index')->name('home');
    Route::get('/sobre', 'sobre')->name('sobre');
    Route::get('/contato', 'contato')->name('contato');
    Route::get('/unidades', 'unidades')->name('unidades');
    Route::get('/servicos', 'servico')->name('servico');
    Route::get('/servico/{slug}', 'servico_details')->name('servico.details');
    //category dropdown menu ajax call
    Route::post('/category/nav-element-list', 'get_category_items')->name('category.elements');
    Route::post('/jaxima', 'jaxima')->name('jaxmim');
    //Flash Deal Details Page
    Route::get('/flash-deals', 'all_flash_deals')->name('flash-deals');
    Route::get('/flash-deal/{slug}', 'flash_deal_details')->name('flash-deal-details');

    //Todays Deal Details Page
    Route::get('/todays-deal', 'todays_deal')->name('todays-deal');

    Route::get('/product/{slug}', 'product')->name('product');
    Route::post('/product/variant-price', 'variant_price')->name('products.variant_price');
    Route::get('/shop/{slug}', 'shop')->name('shop.visit');
    Route::get('/shop/{slug}/{type}', 'filter_shop')->name('shop.visit.type');

    Route::get('/customer-packages', 'premium_package_index')->name('customer_packages_list_show');

    Route::get('/brands', 'all_brands')->name('brands.all');
    Route::get('/categories', 'all_categories')->name('categories.all');
    Route::get('/sellers', 'all_seller')->name('sellers');
    Route::get('/coupons', 'all_coupons')->name('coupons.all');
    Route::get('/inhouse', 'inhouse_products')->name('inhouse.all');


    // Policies
    Route::get('/seller-policy', 'sellerpolicy')->name('sellerpolicy');
    Route::get('/return-policy', 'returnpolicy')->name('returnpolicy');
    Route::get('/support-policy', 'supportpolicy')->name('supportpolicy');
    Route::get('/terms', 'terms')->name('terms');
    Route::get('/privacy-policy', 'privacypolicy')->name('privacypolicy');

    Route::get('/track-your-order', 'trackOrder')->name('orders.track');
});

// Language Switch
Route::post('/language', [LanguageController::class, 'changeLanguage'])->name('language.change');

// Currency Switch
Route::post('/currency', [CurrencyController::class, 'changeCurrency'])->name('currency.change');

// Size Chart Show
Route::get('/size-charts-show/{id}', [SizeChartController::class, 'show'])->name('size-charts-show');

Route::get('/sitemap.xml', function () {
    return base_path('sitemap.xml');
});

// Classified Product
Route::controller(CustomerProductController::class)->group(function () {
    Route::get('/customer-products', 'customer_products_listing')->name('customer.products');
    Route::get('/customer-products?category={category_slug}', 'search')->name('customer_products.category');
    Route::get('/customer-products?city={city_id}', 'search')->name('customer_products.city');
    Route::get('/customer-products?q={search}', 'search')->name('customer_products.search');
    Route::get('/customer-product/{slug}', 'customer_product')->name('customer.product');
});

// Search
Route::controller(SearchController::class)->group(function () {
    Route::get('/search', 'index')->name('search');
    Route::get('/search?keyword={search}', 'index')->name('suggestion.search');
    Route::post('/ajax-search', 'ajax_search')->name('search.ajax');
    Route::get('/category/{category_slug}', 'listingByCategory')->name('products.category');
    Route::get('/brand/{brand_slug}', 'listingByBrand')->name('products.brand');
});

// Cart
Route::controller(CartController::class)->group(function () {
    Route::get('/cart', 'index')->name('cart');
    Route::post('/cart/show-cart-modal', 'showCartModal')->name('cart.showCartModal');
    Route::post('/cart/addtocart', 'addToCart')->name('cart.addToCart');
    Route::post('/cart/removeFromCart', 'removeFromCart')->name('cart.removeFromCart');
    Route::post('/cart/updateQuantity', 'updateQuantity')->name('cart.updateQuantity');
    Route::post('/cart/updateCartStatus', 'updateCartStatus')->name('cart.updateCartStatus');
});

//Paypal START
Route::controller(PaypalController::class)->group(function () {
    Route::get('/paypal/payment/done', 'getDone')->name('payment.done');
    Route::get('/paypal/payment/cancel', 'getCancel')->name('payment.cancel');
});
//Mercadopago START
Route::controller(MercadopagoController::class)->group(function () {
    Route::any('/mercadopago/payment/done', 'paymentstatus')->name('mercadopago.done');
    Route::any('/mercadopago/payment/cancel', 'callback')->name('mercadopago.cancel');
});
//Mercadopago

// SSLCOMMERZ Start
Route::controller(SslcommerzController::class)->group(function () {
    Route::get('/sslcommerz/pay', 'index');
    Route::POST('/sslcommerz/success', 'success');
    Route::POST('/sslcommerz/fail', 'fail');
    Route::POST('/sslcommerz/cancel', 'cancel');
    Route::POST('/sslcommerz/ipn', 'ipn');
});
//SSLCOMMERZ END

//Stipe Start
Route::controller(StripeController::class)->group(function () {
    Route::get('stripe', 'stripe');
    Route::post('/stripe/create-payment-intent', 'createPaymentIntent')->name('stripe.createPaymentIntent');
    Route::post('/stripe/create-checkout-session', 'create_checkout_session')->name('stripe.get_token');
    Route::any('/stripe/payment/callback', 'callback')->name('stripe.callback');
    Route::get('/stripe/success', 'success')->name('stripe.success');
    Route::get('/stripe/cancel', 'cancel')->name('stripe.cancel');
});
Route::controller(CompareController::class)->group(function () {
    Route::get('/compare', 'index')->name('compare');
    Route::get('/compare/reset', 'reset')->name('compare.reset');
    Route::post('/compare/addToCompare', 'addToCompare')->name('compare.addToCompare');
    Route::get('/compare/details/{id}', 'details')->name('compare.details');
});
Route::controller(SubscriberController::class)->group(function () {
    Route::get('/subscribers', 'index')->name('subscribers.index'); // Listar assinantes
    Route::get('/subscribers/create', 'create')->name('subscribers.create'); // Formulário de criação
    Route::post('/subscribers', 'store')->name('subscribers.store'); // Salvar novo assinante
    Route::get('/subscribers/{id}', 'show')->name('subscribers.show'); // Exibir um assinante
    Route::get('/subscribers/{id}/edit', 'edit')->name('subscribers.edit'); // Formulário de edição
    Route::post('/subscribers/{id}', 'update')->name('subscribers.update'); // Atualizar assinante
});

Route::group(['middleware' => ['user', 'verified', 'unbanned']], function () {

    Route::controller(HomeController::class)->group(function () {
        Route::get('/dashboard', 'dashboard')->name('dashboard')->middleware(['prevent-back-history']);
        Route::get('/profile', 'profile')->name('profile');
        Route::post('/new-user-verification', 'new_verify')->name('user.new.verify');
        Route::post('/new-user-email', 'update_email')->name('user.change.email');
        Route::post('/user/update-profile', 'userProfileUpdate')->name('user.profile.update');
    });

    Route::controller(NotificationController::class)->group(function () {
        Route::get('/all-notifications', 'customerIndex')->name('customer.all-notifications');
        Route::post('/notifications/bulk-delete', 'bulkDeleteCustomer')->name('notifications.bulk_delete');
        Route::get('/notification/read-and-redirect/{id}', 'readAndRedirect')->name('notification.read-and-redirect');
        Route::get('/non-linkable-notification-read', 'nonLinkableNotificationRead')->name('non-linkable-notification-read');
    });
});

// Checkout Routs
Route::group(['prefix' => 'checkout'], function () {
    Route::controller(CheckoutController::class)->group(function () {
        // Route::get('/', 'get_shipping_info')->name('checkout.shipping_info');
        Route::post('/', 'checkout')->name('checkout');
        Route::any('/delivery-info', 'store_shipping_info')->name('checkout.store_shipping_infostore');
        Route::post('/payment-select', 'store_delivery_info')->name('checkout.store_delivery_info');
        Route::post('/payment', 'checkout')->name('payment.checkout');
        Route::get('/order-confirmed', 'order_confirmed')->name('order_confirmed');
        Route::post('/apply-coupon-code', 'apply_coupon_code')->name('checkout.apply_coupon_code');
        Route::post('/remove-coupon-code', 'remove_coupon_code')->name('checkout.remove_coupon_code');
        Route::post('/guest-customer-info-check', 'guestCustomerInfoCheck')->name('guest_customer_info_check');
        Route::post('/updateDeliveryAddress', 'updateDeliveryAddress')->name('checkout.updateDeliveryAddress');
        Route::post('/updateDeliveryInfo', 'updateDeliveryInfo')->name('checkout.updateDeliveryInfo');
        Route::post('/checkEmail','checkEmail')->name('checkout.financial.checkEmail');

    });
});

Route::group(['middleware' => ['customer', 'verified', 'unbanned']], function () {
    Route::controller(PurchaseHistoryController::class)->group(function () {
        Route::get('/purchase_history', 'index')->name('purchase_history.index'); // Listar histórico de compras
        Route::get('/purchase_history/create', 'create')->name('purchase_history.create'); // Formulário de criação
        Route::post('/purchase_history', 'store')->name('purchase_history.store'); // Salvar nova entrada no histórico
        Route::get('/purchase_history/{id}', 'show')->name('purchase_history.show'); // Exibir uma entrada do histórico
        Route::get('/purchase_history/{id}/edit', 'edit')->name('purchase_history.edit'); // Formulário de edição
        Route::put('/purchase_history/{id}', 'update')->name('purchase_history.update'); // Atualizar entrada no histórico
        Route::delete('/purchase_history/{id}', 'destroy')->name('purchase_history.destroy'); // Deletar entrada do histórico
    });
    Route::controller(PurchaseHistoryController::class)->group(function () {
        Route::get('/purchase_history/details/{id}', 'purchase_history_details')->name('purchase_history.details');
        Route::get('/purchase_history/destroy/{id}', 'order_cancel')->name('purchase_history.destroy');
        Route::get('digital-purchase-history', 'digital_index')->name('digital_purchase_history.index');
        Route::get('/digital-products/download/{id}', 'download')->name('digital-products.download');

        Route::get('/re-order/{id}', 're_order')->name('re_order');
    });
    Route::controller(WishlistController::class)->group(function () {
        Route::get('/wishlists', 'index')->name('wishlists.index'); // Listar todos os itens da lista de desejos
        Route::get('/wishlists/create', 'create')->name('wishlists.create'); // Formulário para criar um novo item
        Route::post('/wishlists', 'store')->name('wishlists.store'); // Salvar novo item na lista de desejos
        Route::get('/wishlists/{id}', 'show')->name('wishlists.show'); // Exibir um item específico da lista de desejos
        Route::get('/wishlists/{id}/edit', 'edit')->name('wishlists.edit'); // Formulário para editar um item existente
        Route::put('/wishlists/{id}', 'update')->name('wishlists.update'); // Atualizar um item da lista de desejos
        Route::delete('/wishlists/{id}', 'destroy')->name('wishlists.destroy'); // Remover um item da lista de desejos
    });
    Route::post('/wishlists/remove', [WishlistController::class, 'remove'])->name('wishlists.remove');

    Route::controller(FollowSellerController::class)->group(function () {
        Route::get('/followed-seller', 'index')->name('followed_seller');
        Route::get('/followed-seller/store', 'store')->name('followed_seller.store');
        Route::get('/followed-seller/remove', 'remove')->name('followed_seller.remove');
    });

    // Wallet
    Route::controller(WalletController::class)->group(function () {
        Route::get('/wallet', 'index')->name('wallet.index');
        Route::post('/recharge', 'recharge')->name('wallet.recharge');
    });

    // Support Ticket
    Route::controller(SupportTicketController::class)->group(function () {
        Route::get('/support_ticket', 'index')->name('support_ticket.index'); // Listar todos os tickets de suporte
        Route::get('/support_ticket/create', 'create')->name('support_ticket.create'); // Formulário para criar um novo ticket
        Route::post('/support_ticket', 'store')->name('support_ticket.store'); // Salvar um novo ticket de suporte
        Route::get('/support_ticket/{id}', 'show')->name('support_ticket.show'); // Exibir detalhes de um ticket específico
        Route::get('/support_ticket/{id}/edit', 'edit')->name('support_ticket.edit'); // Formulário para editar um ticket existente
        Route::put('/support_ticket/{id}', 'update')->name('support_ticket.update'); // Atualizar um ticket de suporte
        Route::delete('/support_ticket/{id}', 'destroy')->name('support_ticket.destroy'); // Remover um ticket de suporte
    });
    Route::post('support_ticket/reply', [SupportTicketController::class, 'seller_store'])->name('support_ticket.seller_store');
    Route::post('/customer-packages/purchase', [CustomerPackageController::class, 'purchase_package'])->name('customer_packages.purchase');
    Route::controller(CustomerProductController::class)->group(function () {
        Route::get('/customer_products', 'index')->name('customer_products.index'); // Listar todos os produtos do cliente
        Route::get('/customer_products/create', 'create')->name('customer_products.create'); // Formulário para criar um novo produto
        Route::post('/customer_products', 'store')->name('customer_products.store'); // Salvar um novo produto do cliente
        Route::get('/customer_products/{id}', 'show')->name('customer_products.show'); // Exibir detalhes de um produto específico
        Route::get('/customer_products/{id}/edit', 'edit')->name('customer_products.edit'); // Formulário para editar um produto existente
        Route::put('/customer_products/{id}', 'update')->name('customer_products.update'); // Atualizar um produto do cliente
        Route::delete('/customer_products/{id}', 'destroy')->name('customer_products.destroy'); // Remover um produto do cliente
    });
    Route::controller(CustomerProductController::class)->group(function () {
        Route::get('/customer_products/{id}/edit', 'edit')->name('customer_products.edit');
        Route::post('/customer_products/published', 'updatePublished')->name('customer_products.published');
        Route::post('/customer_products/status', 'updateStatus')->name('customer_products.update.status');
        Route::get('/customer_products/destroy/{id}', 'destroy')->name('customer_products.destroy');
    });

    // Product Review
    Route::post('/product-review-modal', [ReviewController::class, 'product_review_modal'])->name('product_review_modal');

    Route::post('/order/re-payment', [CheckoutController::class, 'orderRePayment'])->name('order.re_payment');
});


Route::get('translation-check/{check}', [LanguageController::class, 'get_translation']);

Route::controller(AddressController::class)->group(function () {
    Route::post('/get-states', 'getStates')->name('get-state');
    Route::post('/get-cities', 'getCities')->name('get-city');
});

Route::group(['middleware' => ['auth']], function () {

    Route::get('invoice/{order_id}', [InvoiceController::class, 'invoice_download'])->name('invoice.download');
    Route::controller(ReviewController::class)->group(function () {
        Route::get('/reviews', 'index')->name('reviews.index'); // Listar todas as avaliações
        Route::get('/reviews/create', 'create')->name('reviews.create'); // Formulário para criar uma nova avaliação
        Route::post('/reviews', 'store')->name('reviews.store'); // Salvar uma nova avaliação
        Route::get('/reviews/{id}', 'show')->name('reviews.show'); // Exibir detalhes de uma avaliação específica
        Route::get('/reviews/{id}/edit', 'edit')->name('reviews.edit'); // Formulário para editar uma avaliação existente
        Route::put('/reviews/{id}', 'update')->name('reviews.update'); // Atualizar uma avaliação
        Route::delete('/reviews/{id}', 'destroy')->name('reviews.destroy'); // Remover uma avaliação
    });

    // Product Conversation
    Route::controller(ConversationController::class)->group(function () {
        Route::get('/conversations', 'index')->name('conversations.index'); // Listar todas as conversas
        Route::get('/conversations/create', 'create')->name('conversations.create'); // Formulário para criar uma nova conversa
        Route::post('/conversations', 'store')->name('conversations.store'); // Salvar uma nova conversa
        Route::get('/conversations/{id}', 'show')->name('conversations.show'); // Exibir detalhes de uma conversa específica
        Route::get('/conversations/{id}/edit', 'edit')->name('conversations.edit'); // Formulário para editar uma conversa existente
        Route::put('/conversations/{id}', 'update')->name('conversations.update'); // Atualizar uma conversa
        Route::delete('/conversations/{id}', 'destroy')->name('conversations.destroy'); // Remover uma conversa
    });
    Route::controller(ConversationController::class)->group(function () {
        Route::get('/conversations/destroy/{id}', 'destroy')->name('conversations.destroy');
        Route::post('conversations/refresh', 'refresh')->name('conversations.refresh');
    });
    Route::controller(ProductQueryController::class)->group(function () {
        Route::get('/product-queries', 'index')->name('product-queries.index'); // Listar todas as consultas de produtos
        Route::get('/product-queries/create', 'create')->name('product-queries.create'); // Formulário para criar uma nova consulta
        Route::post('/product-queries', 'store')->name('product-queries.store'); // Salvar uma nova consulta de produto
        Route::get('/product-queries/{id}', 'show')->name('product-queries.show'); // Exibir detalhes de uma consulta específica
        Route::get('/product-queries/{id}/edit', 'edit')->name('product-queries.edit'); // Formulário para editar uma consulta existente
        Route::put('/product-queries/{id}', 'update')->name('product-queries.update'); // Atualizar uma consulta de produto
        Route::delete('/product-queries/{id}', 'destroy')->name('product-queries.destroy'); // Remover uma consulta de produto
    });

    Route::controller(MessageController::class)->group(function () {
        Route::get('/messages', 'index')->name('messages.index'); // Listar todas as mensagens
        Route::get('/messages/create', 'create')->name('messages.create'); // Formulário para criar uma nova mensagem
        Route::post('/messages', 'store')->name('messages.store'); // Salvar uma nova mensagem
        Route::get('/messages/{id}', 'show')->name('messages.show'); // Exibir detalhes de uma mensagem específica
        Route::get('/messages/{id}/edit', 'edit')->name('messages.edit'); // Formulário para editar uma mensagem existente
        Route::put('/messages/{id}', 'update')->name('messages.update'); // Atualizar uma mensagem
        Route::delete('/messages/{id}', 'destroy')->name('messages.destroy'); // Remover uma mensagem
    });

    Route::controller(AddressController::class)->group(function () {
        Route::get('/addresses', 'index')->name('addresses.index'); // Listar todos os endereços
        Route::get('/addresses/create', 'create')->name('addresses.create'); // Formulário para criar um novo endereço
        Route::post('/addresses', 'store')->name('addresses.store'); // Salvar um novo endereço
        Route::get('/addresses/{id}', 'show')->name('addresses.show'); // Exibir detalhes de um endereço específico
        Route::get('/addresses/{id}/edit', 'edit')->name('addresses.edit'); // Formulário para editar um endereço existente
        Route::put('/addresses/{id}', 'update')->name('addresses.update'); // Atualizar um endereço
        Route::delete('/addresses/{id}', 'destroy')->name('addresses.destroy'); // Remover um endereço
    });
    Route::controller(AddressController::class)->group(function () {
        Route::post('/addresses/update/{id}', 'update')->name('addresses.update');
        Route::get('/addresses/destroy/{id}', 'destroy')->name('addresses.destroy');
        Route::get('/addresses/set-default/{id}', 'set_default')->name('addresses.set_default');
    });
});

Route::controller(ShopController::class)->middleware('handle-demo-login')->group(function () {
    Route::get('/shops', 'index')->name('shops.index'); // Listar todas as lojas
    Route::get('/shops/create', 'create')->name('shops.create'); // Formulário para criar uma nova loja
    Route::post('/shops', 'store')->name('shops.store'); // Salvar uma nova loja
    Route::get('/shops/{id}', 'show')->name('shops.show'); // Exibir detalhes de uma loja específica
    Route::get('/shops/{id}/edit', 'edit')->name('shops.edit'); // Formulário para editar uma loja existente
    Route::put('/shops/{id}', 'update')->name('shops.update'); // Atualizar uma loja
    Route::delete('/shops/{id}', 'destroy')->name('shops.destroy'); // Remover uma loja
});

Route::get('/instamojo/payment/pay-success', [InstamojoController::class, 'success'])->name('instamojo.success');

Route::post('rozer/payment/pay-success', [RazorpayController::class, 'payment'])->name('payment.rozer');

Route::get('/paystack/payment/callback', [PaystackController::class, 'handleGatewayCallback']);
Route::get('/paystack/new-callback', [PaystackController::class, 'paystackNewCallback']);

Route::controller(VoguepayController::class)->group(function () {
    Route::get('/vogue-pay', 'showForm');
    Route::get('/vogue-pay/success/{id}', 'paymentSuccess');
    Route::get('/vogue-pay/callback', 'handleCallback');
    Route::get('/vogue-pay/failure/{id}', 'paymentFailure');
});


//Iyzico
Route::any('/iyzico/payment/callback/{payment_type}/{amount?}/{payment_method?}/{combined_order_id?}/{customer_package_id?}/{seller_package_id?}', [IyzicoController::class, 'callback'])->name('iyzico.callback');

Route::get('/customer-products/admin', [IyzicoController::class, 'initPayment'])->name('profile.edit');

//payhere below
Route::controller(PayhereController::class)->group(function () {
    Route::get('/payhere/checkout/testing', 'checkout_testing')->name('payhere.checkout.testing');
    Route::get('/payhere/wallet/testing', 'wallet_testing')->name('payhere.checkout.testing');
    Route::get('/payhere/customer_package/testing', 'customer_package_testing')->name('payhere.customer_package.testing');

    Route::any('/payhere/checkout/notify', 'checkout_notify')->name('payhere.checkout.notify');
    Route::any('/payhere/checkout/return', 'checkout_return')->name('payhere.checkout.return');
    Route::any('/payhere/checkout/cancel', 'chekout_cancel')->name('payhere.checkout.cancel');

    Route::any('/payhere/order-re-payment/notify', 'orderRepaymentNotify')->name('payhere.order_re_payment.notify');
    Route::any('/payhere/order-re-payment/return', 'orderRepaymentReturn')->name('payhere.order_re_payment.return');
    Route::any('/payhere/order-re-payment/cancel', 'orderRepaymentCancel')->name('payhere.order_re_payment.cancel');

    Route::any('/payhere/wallet/notify', 'wallet_notify')->name('payhere.wallet.notify');
    Route::any('/payhere/wallet/return', 'wallet_return')->name('payhere.wallet.return');
    Route::any('/payhere/wallet/cancel', 'wallet_cancel')->name('payhere.wallet.cancel');

    Route::any('/payhere/seller_package_payment/notify', 'sellerPackageNotify')->name('payhere.seller_package_payment.notify');
    Route::any('/payhere/seller_package_payment/return', 'sellerPackageReturn')->name('payhere.seller_package_payment.return');
    Route::any('/payhere/seller_package_payment/cancel', 'sellerPackageCancel')->name('payhere.seller_package_payment.cancel');

    Route::any('/payhere/customer_package_payment/notify', 'customer_package_notify')->name('payhere.customer_package_payment.notify');
    Route::any('/payhere/customer_package_payment/return', 'customer_package_return')->name('payhere.customer_package_payment.return');
    Route::any('/payhere/customer_package_payment/cancel', 'customer_package_cancel')->name('payhere.customer_package_payment.cancel');
});

//N-genius
Route::controller(NgeniusController::class)->group(function () {
    Route::any('ngenius/cart_payment_callback', 'cart_payment_callback')->name('ngenius.cart_payment_callback');
    Route::any('ngenius/order_re_payment_callback', 'order_re_payment_callback')->name('ngenius.order_re_payment_callback');
    Route::any('ngenius/wallet_payment_callback', 'wallet_payment_callback')->name('ngenius.wallet_payment_callback');
    Route::any('ngenius/customer_package_payment_callback', 'customer_package_payment_callback')->name('ngenius.customer_package_payment_callback');
    Route::any('ngenius/seller_package_payment_callback', 'seller_package_payment_callback')->name('ngenius.seller_package_payment_callback');
});

Route::controller(BkashController::class)->group(function () {
    Route::get('/bkash/create-payment', 'create_payment')->name('bkash.create_payment');
    Route::get('/bkash/callback', 'callback')->name('bkash.callback');
    Route::get('/bkash/success', 'success')->name('bkash.success');
});

Route::get('/checkout-payment-detail', [StripeController::class, 'checkout_payment_detail']);

//Nagad
Route::get('/nagad/callback', [NagadController::class, 'verify'])->name('nagad.callback');

//aamarpay
Route::controller(AamarpayController::class)->group(function () {
    Route::post('/aamarpay/success', 'success')->name('aamarpay.success');
    Route::post('/aamarpay/fail', 'fail')->name('aamarpay.fail');
});

//Authorize-Net-Payment
Route::post('/dopay/online', [AuthorizenetController::class, 'handleonlinepay'])->name('dopay.online');
Route::get('/authorizenet/cardtype', [AuthorizenetController::class, 'cardType'])->name('authorizenet.cardtype');

//payku
Route::get('/payku/callback/{id}', [PaykuController::class, 'callback'])->name('payku.result');

// Paymob
Route::any('/paymob/callback', [PaymobController::class, 'callback']);

// tap
Route::any('/tap/callback', [TapController::class, 'callback'])->name('tap.callback');

//Blog Section
Route::controller(BlogController::class)->group(function () {
    Route::get('/blog', 'all_blog')->name('blog');
    Route::get('/blog/{slug}', 'blog_details')->name('blog.details');
});

Route::controller(PageController::class)->group(function () {
    //mobile app balnk page for webview
    Route::get('/mobile-page/{slug}', 'mobile_custom_page')->name('mobile.custom-pages');

    //Custom page
    Route::get('/{slug}', 'show_custom_page')->name('custom-pages.show_custom_page');
});
Route::controller(ContactController::class)->group(function () {
    Route::post('/contact', 'contact')->name('contact');
});
