<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(static_asset('assets/ckeditor/ckeditor.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="row">
    <div class="col-lg-8 mx-auto">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0 h6"><?php echo e(translate('Blog Information')); ?></h5>
            </div>
            <div class="card-body">
                <form id="add_form" class="form-horizontal" action="<?php echo e(route('blog.update',$blog->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PATCH'); ?>
                    <div class="form-group row">
                        <label class="col-md-12 col-form-label">
                            <?php echo e(translate('Blog Title')); ?>

                            <span class="text-danger">*</span>
                        </label>
                        <div class="col-md-12">
                            <input type="text" placeholder="<?php echo e(translate('Blog Title')); ?>" onkeyup="makeSlug(this.value)" id="title" name="title" value="<?php echo e($blog->title); ?>" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group row" id="category">
                        <label class="col-md-12 col-from-label">
                            <?php echo e(translate('Category')); ?>

                            <span class="text-danger">*</span>
                        </label>
                        <div class="col-md-12">
                            <select
                                class="form-control aiz-selectpicker"
                                name="category_id"
                                id="category_id"
                                data-live-search="true"
                                required
                                <?php if($blog->category != null): ?>
                                data-selected="<?php echo e($blog->category->id); ?>"
                                <?php endif; ?>
                            >
                                <option>--</option>
                                <?php $__currentLoopData = $blog_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>">
                                    <?php echo e($category->category_name); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>


                    <div class="form-group row">
                        <label class="col-md-12 col-form-label"><?php echo e(translate('Slug')); ?></label>
                        <div class="col-md-12">
                            <input type="text" placeholder="<?php echo e(translate('Slug')); ?>" name="slug" id="slug" value="<?php echo e($blog->slug); ?>" class="form-control" required>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-md-12 col-form-label" for="signinSrEmail">
                            <?php echo e(translate('Banner')); ?>

                            <small>(1300x650)</small>
                        </label>
                        <div class="col-md-12">
                            <div class="input-group" data-toggle="aizuploader" data-type="image">
                                <div class="input-group-prepend">
                                    <div class="input-group-text bg-soft-secondary font-weight-medium">
                                        <?php echo e(translate('Browse')); ?>

                                    </div>
                                </div>
                                <div class="form-control file-amount"><?php echo e(translate('Choose File')); ?></div>
                                <input type="hidden" name="banner" class="selected-files" value="<?php echo e($blog->banner); ?>">
                            </div>
                            <div class="file-preview box sm">
                            </div>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-md-12 col-form-label">
                            <?php echo e(translate('Short Description')); ?>

                            <span class="text-danger">*</span>
                        </label>
                        <div class="col-md-12">
                            <textarea name="short_description" rows="5" class="form-control"><?php echo e($blog->short_description); ?></textarea>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-md-12 col-from-label">
                            <?php echo e(translate('Description')); ?>

                        </label>
                        <div class="col-md-12">
                            <textarea class="form-control ckeditor" name="description"><?php echo e($blog->description); ?></textarea>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-md-12 col-form-label"><?php echo e(translate('Meta Title')); ?></label>
                        <div class="col-md-12">
                            <input type="text" class="form-control" name="meta_title" value="<?php echo e($blog->meta_title); ?>" placeholder="<?php echo e(translate('Meta Title')); ?>">
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-md-12 col-form-label" for="signinSrEmail">
                            <?php echo e(translate('Meta Image')); ?>

                            <small>(200x200)+</small>
                        </label>
                        <div class="col-md-12">
                            <div class="input-group" data-toggle="aizuploader" data-type="image">
                                <div class="input-group-prepend">
                                    <div class="input-group-text bg-soft-secondary font-weight-medium">
                                        <?php echo e(translate('Browse')); ?>

                                    </div>
                                </div>
                                <div class="form-control file-amount"><?php echo e(translate('Choose File')); ?></div>
                                <input type="hidden" name="meta_img" class="selected-files" value="<?php echo e($blog->meta_img); ?>">
                            </div>
                            <div class="file-preview box sm">
                            </div>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-md-12 col-form-label"><?php echo e(translate('Meta Description')); ?></label>
                        <div class="col-md-12">
                            <textarea name="meta_description" rows="5" class="form-control"><?php echo e($blog->meta_description); ?></textarea>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-md-12 col-form-label">
                            <?php echo e(translate('Meta Keywords')); ?>

                        </label>
                        <div class="col-md-12">
                            <input type="text" class="form-control" id="meta_keywords" name="meta_keywords" value="<?php echo e($blog->meta_keywords); ?>" placeholder="<?php echo e(translate('Meta Keywords')); ?>">
                        </div>
                    </div>

                    <div class="form-group mb-0 text-right">
                        <button type="submit" class="btn btn-primary">
                            <?php echo e(translate('Save')); ?>

                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    function makeSlug(val) {
        let str = val;
        let output = str.replace(/\s+/g, '-').toLowerCase();
        $('#slug').val(output);
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hooglicl/acquacerrado.hoogli.cloud/resources/views/backend/blog_system/blog/edit.blade.php ENDPATH**/ ?>