<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.5.0
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

namespace Modules\Board\Concerns;

use Illuminate\Database\Eloquent\Relations\MorphToMany;

/** @mixin \Modules\Core\Models\Model */
trait HasBoard
{
    /**
     * Get all of the board that are associated with the model.
     */
    public function board(): MorphToMany
    {
        return $this->morphToMany(\Modules\Board\Models\Board::class, 'boardable');
    }

    /**
     * Get all of the open board associated with the model.
     */
    public function openBoard(): MorphToMany
    {
        return $this->board()->open();
    }

    /**
     * Get all of the won board associated with the model.
     */
    public function wonBoard(): MorphToMany
    {
        return $this->board()->won();
    }

    /**
     * Get all of the lost board associated with the model.
     */
    public function lostBoard(): MorphToMany
    {
        return $this->board()->lost();
    }

    /**
     * Get all of the closed board associated with the model.
     */
    public function closedBoard(): MorphToMany
    {
        return $this->board()->closed();
    }
}
