<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.5.0
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

namespace Modules\Board\Enums;

use Modules\Core\Support\InteractsWithEnums;

enum BoardStatus: int
{
    use InteractsWithEnums;

    case open = 1;
    case won = 2;
    case lost = 3;

    /**
     * Get the status label.
     */
    public function label(): string
    {
        return __('board::board.status.'.$this->name);
    }

    /**
     * Get the board status badge variant.
     */
    public function badgeVariant(): string
    {
        return self::badgeVariants()[$this->name];
    }

    /**
     * Get the available badge variants.
     */
    public static function badgeVariants(): array
    {
        return [
            BoardStatus::open->name => 'neutral',
            BoardStatus::won->name => 'success',
            BoardStatus::lost->name => 'danger',
        ];
    }
}
