<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.5.0
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

namespace Modules\Board\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Modules\Board\Models\Board;
use Modules\Board\Models\Stage;

class BoardMovedToStage
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * Create new BoardMovedToStage instance.
     */
    public function __construct(public Board $board, public Stage $previousStage) {}
}
