<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.5.0
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

namespace Modules\Board\Fields;

use Modules\Core\Fields\BelongsTo;
use Modules\Board\Http\Resources\BoardResource;
use Modules\Board\Models\Board as BoardModel;

/**
 * @codeCoverageIgnore
 */
class Board extends BelongsTo
{
    /**
     * Create new instance of Board field
     *
     * @param  string  $relationName  The relation name, snake case format
     * @param  string  $label  Custom label
     * @param  string  $foreignKey  Custom foreign key
     */
    public function __construct($relationName = 'board', $label = null, $foreignKey = null)
    {
        parent::__construct($relationName, BoardModel::class, $label ?? __('board::board.board'), $foreignKey);

        $this->setJsonResource(BoardResource::class)
            ->async('/board/search');
    }
}
