<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.5.0
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

namespace Modules\Board\Filters;

use Modules\Core\Filters\Select;
use Modules\Board\Enums\BoardStatus as StatusEnum;

class BoardStatusFilter extends Select
{
    /**
     * Initialize Source class
     */
    public function __construct()
    {
        parent::__construct('status', __('board::board.status.status'));

        $this->options(collect(StatusEnum::cases())->mapWithKeys(function (StatusEnum $status) {
            return [$status->name => $status->label()];
        })->all());
    }

    /**
     * Prepare the query value.
     */
    public function prepareValue(string $value): ?StatusEnum
    {
        return StatusEnum::find($value);
    }
}
