<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.5.0
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

namespace Modules\Board\Filters;

use Modules\Core\Filters\Date;
use Modules\Core\Filters\HasFilter;
use Modules\Core\Filters\Number;
use Modules\Core\Filters\Numeric;
use Modules\Core\Filters\Operand;

class ResourceBoardFilter extends HasFilter
{
    /**
     * Initialize new ResourceBoardFilter instance.
     */
    public function __construct(string $singularLabel)
    {
        parent::__construct('board', __('board::board.board'));

        $this->setOperands([
            Operand::from(Numeric::make('amount', __('board::board.board_amount'))),
            Operand::from(Date::make('expected_close_date', __('board::board.board_expected_close_date'))),
            Operand::from(
                Number::make('open_count', __('board::board.count.open', ['resource' => $singularLabel]))->countFromRelation('openBoard')
            ),
            Operand::from(
                Number::make('won_count', __('board::board.count.won', ['resource' => $singularLabel]))->countFromRelation('wonBoard')
            ),
            Operand::from(
                Number::make('lost_count', __('board::board.count.lost', ['resource' => $singularLabel]))->countFromRelation('lostBoard')
            ),
            Operand::from(
                Number::make('closed_count', __('board::board.count.closed', ['resource' => $singularLabel]))->countFromRelation('closedBoard')
            ),
        ]);
    }
}
