<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.5.0
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

namespace Modules\Board\Http\Controllers\Api;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Modules\Core\Http\Controllers\ApiController;
use Modules\Core\Rules\StringRule;
use Modules\Board\Enums\BoardStatus;
use Modules\Board\Http\Resources\BoardResource;
use Modules\Board\Models\Board;

class BoardStatusController extends ApiController
{
    /**
     * Change the board status.
     *
     * @deprecated Use regular board update with "status" attribute.
     */
    public function handle(Board $board, $status, Request $request): JsonResponse
    {
        $this->authorize('update', $board);

        $status = BoardStatus::find($status);

        // User must unmark the board as open when the board status is won or lost in order to change any further statuses
        abort_if(
            $board->isStatusLocked($status),
            JsonResponse::HTTP_CONFLICT,
            'The board first must be marked as open in order to apply the '.$status->name.' status.'
        );

        $request->validate([
            'lost_reason' => [
                settings('lost_reason_is_required') ? 'required' : 'nullable',
                StringRule::make(),
            ],
        ]);

        $board->fillStatus($status, $request->lost_reason)->save();

        return $this->response(
            new BoardResource(
                $board->resource()->displayQuery()->find($board->id)
            )
        );
    }
}
