<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.5.0
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

namespace Modules\Board\Listeners;

use Modules\Core\Facades\ChangeLogger;
use Modules\Board\Events\BoardMovedToStage;

class LogBoardMovedToStageActivity
{
    /**
     * Log board stage activity when a stage is changed.
     */
    public function handle(BoardMovedToStage $event): void
    {
        ChangeLogger::generic()->on($event->board)->withProperties(
            $this->logProperties($event)
        )->log();
    }

    /**
     * Get the log properties.
     */
    protected function logProperties(BoardMovedToStage $event): array
    {
        return [
            'icon' => 'Plus',
            'lang' => [
                'key' => 'board::board.timeline.stage.moved',
                'attrs' => [
                    // Name will be replace in the front end from causer_name
                    // saves some database entries duplication
                    'user' => null,
                    'previous' => $event->previousStage->name,
                    'stage' => $event->board->stage->name,
                ],
            ],
        ];
    }
}
