<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.5.0
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

namespace Modules\Board\Menu;

use Modules\Core\Menu\Metric;
use Modules\Core\Models\DataView;
use Modules\Board\Criteria\ViewAuthorizedBoardCriteria;
use Modules\Board\Models\Board;

class OpenBoardMetric extends Metric
{
    /**
     * Get the metric name
     */
    public function name(): string
    {
        return __('board::board.metrics.open');
    }

    /**
     * Get the metric count
     */
    public function count(): int
    {
        return Board::criteria(ViewAuthorizedBoardCriteria::class)->open()->count();
    }

    /**
     * Get the background color variant when the metric count is bigger then zero
     */
    public function backgroundColorVariant(): string
    {
        return 'info';
    }

    /**
     * Get the front-end route that the highly will redirect to
     */
    public function route(): array|string
    {
        $view = DataView::findByFlag('open-board');

        return [
            'name' => 'board-index',
            'query' => [
                'view_id' => $view?->id,
            ],
        ];
    }
}
