<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.5.0
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

namespace Modules\Board\Workflow\Actions;

use Modules\Core\Facades\ChangeLogger;
use Modules\Core\Workflow\Action;
use Modules\Board\Fields\LostReasonField;
use Modules\Board\Models\Board;

class MarkAssociatedBoardAsLost extends Action
{
    /**
     * Initialize MarkAssociatedBoardAsLost
     */
    public function __construct(protected string $relation) {}

    /**
     * Action name
     */
    public static function name(): string
    {
        return __('board::board.workflows.actions.mark_associated_board_as_lost');
    }

    /**
     * Run the trigger
     */
    public function run()
    {
        ChangeLogger::setCauser($this->workflow->creator);

        Board::open()->whereHas($this->relation, function ($query) {
            $query->where($this->model->getKeyName(), $this->model->getKey());
        })->get()->each(function (Board $board) {
            $board->broadcastToCurrentUser()->markAsLost($this->lost_reason);
        });

        ChangeLogger::setCauser(null);
    }

    /**
     * Action available fields
     */
    public function fields(): array
    {
        return [
            LostReasonField::make('lost_reason', __('board::board.workflows.actions.fields.lost_reason')),
        ];
    }
}
