/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.5.0
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */
import { translate } from '@/Core/i18n'

import CreateBoardModal from './components/CreateBoardModal.vue'
import BoardFloatingModal from './components/BoardFloatingModal.vue'
import BoardPresentationCard from './components/BoardPresentationCard.vue'
import ResourceBoardPanel from './components/ResourceBoardPanel.vue'
import SettingsBoard from './components/SettingsBoard.vue'
import FormLostReasonField from './fields/Form/LostReasonField.vue'
import FormPipelineStageField from './fields/Form/PipelineStageField.vue'
import IndexLostReasonField from './fields/Index/LostReasonField.vue'
import IndexPipelineStageField from './fields/Index/PipelineStageField.vue'
import BoardPipelinesCreate from './views/BoardPipelinesCreate.vue'
import BoardPipelinesEdit from './views/BoardPipelinesEdit.vue'
import routes from './routes'

if (window.Innoclapps) {
  Innoclapps.booting((app, router) => {
    app.component('BoardPresentationCard', BoardPresentationCard)
    app.component('BoardFloatingModal', BoardFloatingModal)
    app.component('CreateBoardModal', CreateBoardModal)
    app.component('ResourceBoardPanel', ResourceBoardPanel)

    // Fields
    app.component('FormLostReasonField', FormLostReasonField)
    app.component('FormPipelineStageField', FormPipelineStageField)
    app.component('IndexPipelineStageField', IndexPipelineStageField)
    app.component('IndexLostReasonField', IndexLostReasonField)

    // Routes
    routes.forEach(route => router.addRoute(route))

    router.addRoute('settings', {
      path: 'board',
      name: 'board-settings-index',
      component: SettingsBoard,
      meta: {
        title: translate('board::board.board'),
      },
      children: [
        {
          path: 'pipelines/create',
          name: 'create-pipeline',
          component: BoardPipelinesCreate,
          meta: { title: translate('board::board.pipeline.create') },
        },
      ],
    })

    router.addRoute('settings', {
      path: 'board/pipelines/:id/edit',
      name: 'edit-pipeline',
      component: BoardPipelinesEdit,
      meta: { title: translate('board::board.pipeline.edit') },
    })
  })
}
