/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.5.0
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */
import { useStorage } from '@vueuse/core'
import { translate } from '@/Core/i18n'

import BoardBoard from './views/BoardBoard.vue'
import BoardCreate from './views/BoardCreate.vue'
import BoardImport from './views/BoardImport.vue'
import BoardIndex from './views/BoardIndex.vue'
import BoardView from './views/BoardView.vue'

const isBoardDefaultView = useStorage('board-board-view-default', false)

export default [
  {
    path: '/board',
    name: 'board-index',
    component: BoardIndex,
    meta: {
      title: translate('board::board.board'),
      subRoutes: ['create-board'],
      boardRoute: 'board-board',
    },
    beforeEnter: async (to, from) => {
      const isSubRoute = to.meta.subRoutes.includes(to.name);
      if (isBoardDefaultView.value && from.name !== to.meta.boardRoute && !isSubRoute) {
        return { name: to.meta.boardRoute, query: to.query };
      }

      if (!isSubRoute) {
        isBoardDefaultView.value = false;
      }
    },
    children: [
      {
        path: 'create',
        name: 'create-board',
        component: BoardCreate,
        meta: { title: translate('board::board.create') },
      },
    ],
  },
  {
    path: '/import/board',
    name: 'import-board',
    component: BoardImport,
    meta: { title: translate('board::board.import') },
  },
  {
    path: '/board/board',
    name: 'board-board',
    component: BoardBoard,
    meta: {
      title: translate('board::board.board'),
    },
    beforeEnter: () => {
      isBoardDefaultView.value = true;
    },
  },
  {
    path: '/board/:id',
    name: 'view-board',
    component: BoardView,
  },
];
