<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.5.0
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

use Illuminate\Support\Facades\Route;
use Modules\Board\Http\Controllers\Api\BoardBoardController;
use Modules\Board\Http\Controllers\Api\BoardStatusController;
use Modules\Board\Http\Controllers\Api\PipelineStageController;

Route::middleware('auth:sanctum')->group(function () {
    /**
     * @deprecated Use regular board update with "status" attribute.
     */
    Route::put('/board/{board}/status/{status}', [BoardStatusController::class, 'handle']);

    Route::prefix('board/board')->group(function () {
        Route::get('{pipeline}', [BoardBoardController::class, 'board']);
        Route::post('{pipeline}', [BoardBoardController::class, 'update']);
        Route::get('{pipeline}/summary/{stageId?}', [BoardBoardController::class, 'summary']);
        Route::get('{pipeline}/{stageId}', [BoardBoardController::class, 'load']);
    });

    Route::get('/pipelines/{pipeline}/stages', [PipelineStageController::class, 'index']);
});
