<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.5.0
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

use Illuminate\Support\Facades\Broadcast;
use Modules\Board\Models\Board;
use Modules\Users\Models\User;

Broadcast::channel('Modules.Board.Models.Board.{boardId}', function (User $user, string $boardId) {
    return $user->can('view', Board::findOrFail($boardId));
});
