<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.5.0
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

namespace Modules\Board\Tests\Feature;

use Modules\Board\Models\Board;
use Tests\TestCase;

class BoardStatusControllerTest extends TestCase
{
    public function test_unauthenticated_user_cannot_access_board_status_endpoints(): void
    {
        $this->getJson('/api/board/FAKE_ID/status/FAKE_STATUS')->assertUnauthorized();
    }

    public function test_an_authorized_user_can_change_the_board_status(): void
    {
        $this->signIn();
        $board = Board::factory()->create();

        $this->putJson("/api/board/{$board->id}/status/won")
            ->assertOk()
            ->assertJson(['status' => 'won']);
    }

    public function test_unauthorized_user_cannot_change_the_board_status(): void
    {
        $user = $this->asRegularUser()->signIn();
        $board = Board::factory()->for($user)->create();

        $this->putJson("/api/board/{$board->id}/status/won")
            ->assertForbidden();
    }

    public function test_board_cant_be_marked_as_lost_when_has_status_won(): void
    {
        $this->signIn();
        $board = Board::factory()->won()->create();

        $this->putJson("/api/board/{$board->id}/status/lost")
            ->assertStatusConflict();
    }

    public function test_board_cant_be_marked_as_won_when_has_status_lost(): void
    {
        $this->signIn();
        $board = Board::factory()->lost()->create();

        $this->putJson("/api/board/{$board->id}/status/won")
            ->assertStatusConflict();
    }
}
