<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.5.0
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

namespace Modules\Board\Tests\Feature;

use Modules\Core\Tests\ResourceTestCase;
use Modules\Board\Enums\BoardStatus;

class MarkAsOpenTest extends ResourceTestCase
{
    protected $action = 'mark-as-open';

    protected $resourceName = 'board';

    public function test_super_admin_user_can_run_board_mark_as_open_action(): void
    {
        $this->signIn();
        $board = $this->factory()->won()->create();

        $this->runAction($this->action, $board)->assertActionOk();
        $this->assertSame(BoardStatus::open, $board->fresh()->status);
    }

    public function test_authorized_user_can_run_board_mark_as_open_action(): void
    {
        $this->asRegularUser()->withPermissionsTo('edit all board')->signIn();

        $user = $this->createUser();
        $board = $this->factory()->won()->for($user)->create();

        $this->runAction($this->action, $board)->assertActionOk();
        $this->assertSame(BoardStatus::open, $board->fresh()->status);
    }

    public function test_unauthorized_user_can_run_board_mark_as_open_action_on_own_board(): void
    {
        $signedInUser = $this->asRegularUser()->withPermissionsTo('edit own board')->signIn();

        $boardForSignedIn = $this->factory()->won()->for($signedInUser)->create();
        $otherBoard = $this->factory()->won()->create();

        $this->runAction($this->action, $otherBoard)->assertActionUnauthorized();
        $this->runAction($this->action, $boardForSignedIn);
        $this->assertSame(BoardStatus::open, $boardForSignedIn->fresh()->status);
    }
}
