<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.5.0
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

namespace Modules\Board\Tests\Feature;

use Modules\Core\Tests\ResourceTestCase;
use Modules\Board\Enums\BoardStatus;
use Modules\Users\Models\User;

class MarkAsWonTest extends ResourceTestCase
{
    protected $action = 'mark-as-won';

    protected $resourceName = 'board';

    public function test_super_admin_user_can_run_board_mark_as_won_action(): void
    {
        $this->signIn();
        $board = $this->factory()->create();

        $this->runAction($this->action, $board)->assertActionOk();
        $this->assertSame(BoardStatus::won, $board->fresh()->status);
    }

    public function test_board_mark_as_won_action_throws_confetti(): void
    {
        $this->signIn();
        $board = $this->factory()->create();

        $this->runAction($this->action, $board)->assertExactJson(['confetti' => true]);
    }

    public function test_authorized_user_can_run_board_mark_as_won_action(): void
    {
        $this->asRegularUser()->withPermissionsTo('edit all board')->signIn();

        $board = $this->factory()->for(User::factory())->create();

        $this->runAction($this->action, $board)->assertActionOk();
        $this->assertSame(BoardStatus::won, $board->fresh()->status);
    }

    public function test_unauthorized_user_can_run_board_mark_as_won_action_on_own_board(): void
    {
        $signedInUser = $this->asRegularUser()->withPermissionsTo('edit own board')->signIn();
        $this->createUser();

        $boardForSignedIn = $this->factory()->for($signedInUser)->create();
        $otherBoard = $this->factory()->create();

        $this->runAction($this->action, $otherBoard)->assertActionUnauthorized();
        $this->runAction($this->action, $boardForSignedIn);
        $this->assertSame(BoardStatus::won, $boardForSignedIn->fresh()->status);
    }
}
