<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.5.0
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

namespace Modules\Board\Tests\Feature;

use Modules\Board\Criteria\ViewAuthorizedBoardCriteria;
use Modules\Board\Models\Board;
use Tests\TestCase;

class ViewAuthorizedBoardCriteriaTest extends TestCase
{
    public function test_own_board_criteria_queries_only_own_board(): void
    {
        $user = $this->asRegularUser()->withPermissionsTo('view own board')->createUser();

        Board::factory()->for($user)->create();
        Board::factory()->create();

        $this->signIn($user);
        $query = Board::criteria(ViewAuthorizedBoardCriteria::class);
        $this->assertSame(1, $query->count());
    }

    public function test_it_returns_all_board_when_user_is_authorized_to_see_all_board(): void
    {
        $user = $this->asRegularUser()->withPermissionsTo('view all board')->createUser();

        Board::factory()->for($user)->create();
        Board::factory()->create();

        $this->signIn($user);
        $query = Board::criteria(ViewAuthorizedBoardCriteria::class);
        $this->assertSame(2, $query->count());

        $this->signIn();
        $query = Board::criteria(ViewAuthorizedBoardCriteria::class);
        $this->assertSame(2, $query->count());
    }
}
