<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.5.0
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

use App\ToModuleMigrator;
use Modules\Updater\UpdatePatcher;

return new class extends UpdatePatcher
{
    public function run(): void
    {
        ToModuleMigrator::make('board')
            ->migrateMorphs('App\\Models\\Board', 'Modules\\Board\\Models\\Board')
            ->migrateMailableTemplates([
                'App\\Mail\\UserAssignedToBoard' => 'Modules\Board\Mail\UserAssignedToBoard',
            ])
            ->migrateNotifications([
                'App\\Notifications\\UserAssignedToBoard' => 'Modules\Board\Notifications\UserAssignedToBoard',
            ])
            ->migrateDbLanguageKeys('board')
            ->migrateLanguageFiles(['board.php', 'board.php'])
            ->migrateWorkflowTriggers([
                'App\\Workflows\\Triggers\\BoardCreated' => 'Modules\Board\Workflow\Triggers\BoardCreated',
                'App\\Workflows\\Triggers\\BoardStageChanged' => 'Modules\Board\Workflow\Triggers\BoardStageChanged',
                'App\\Workflows\\Triggers\\BoardStatusChanged' => 'Modules\Board\Workflow\Triggers\BoardStatusChanged',
            ])
            ->migrateWorkflowActions([
                'App\\Workflows\\Triggers\\MarkAssociatedBoardAsLost' => 'Modules\Board\Workflow\Triggers\MarkAssociatedBoardAsLost',
                'App\\Workflows\\Triggers\\MarkAssociatedBoardAsWon' => 'Modules\Board\Workflow\Triggers\MarkAssociatedBoardAsWon',
            ])
            ->deleteConflictedFiles($this->getConflictedFiles());
    }

    public function shouldRun(): bool
    {
        return file_exists(app_path('Models/Board.php'));
    }

    protected function getConflictedFiles(): array
    {
        return [
            app_path('Resources/Board'),

            app_path('Mail/UserAssignedToBoard.php'),
            app_path('Mail/UserAssignedToBoard.php'),

            app_path('Notifications/UserAssignedToBoard.php'),
            app_path('Notifications/UserAssignedToBoard.php'),

            app_path('Workflows/Triggers/BoardCreated.php'),
            app_path('Workflows/Triggers/BoardStageChanged.php'),
            app_path('Workflows/Triggers/BoardStatusChanged.php'),

            app_path('Workflows/Actions/MarkAssociatedBoardAsLost.php'),
            app_path('Workflows/Actions/MarkAssociatedBoardAsWon.php'),

            app_path('Models/Board.php'),
            app_path('Models/Stage.php'),
            app_path('Models/Pipeline.php'),
            app_path('Models/LostReason.php'),
            app_path('Models/StageHistory.php'),
        ];
    }
};
